/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.jsqlparser.instrument;

import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.dialect.instrument.AbstractClauseTransformer;
import com.jn.sqlhelper.dialect.instrument.InjectPosition;
import com.jn.sqlhelper.dialect.instrument.TransformConfig;
import com.jn.sqlhelper.dialect.instrument.where.WhereTransformConfig;
import com.jn.sqlhelper.dialect.instrument.where.WhereTransformer;
import com.jn.sqlhelper.dialect.sqlparser.SqlStatementWrapper;
import com.jn.sqlhelper.dialect.tenant.Tenant;
import com.jn.sqlhelper.jsqlparser.expression.ExpressionConverters;
import com.jn.sqlhelper.jsqlparser.utils.JSqlParsers;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;

public class JSqlParserWhereTransformer
extends AbstractClauseTransformer<Statement>
implements WhereTransformer<Statement> {
    public void init() throws InitializationException {
    }

    public SqlStatementWrapper<Statement> transform(SqlStatementWrapper<Statement> statementWrapper, TransformConfig config) {
        if (Emptys.isEmpty(statementWrapper) || Emptys.isEmpty((Object)config)) {
            return statementWrapper;
        }
        Statement statement = (Statement)statementWrapper.get();
        List expressionConfigs = config.getWhereInstrumentConfigs();
        if (Emptys.isEmpty((Object)statement) || Emptys.isEmpty((Object)expressionConfigs)) {
            return statementWrapper;
        }
        if (!JSqlParsers.isDML(statement)) {
            return statementWrapper;
        }
        if (Reflects.isSubClassOrEquals(Select.class, statement.getClass())) {
            this.transform((Select)statement, false, expressionConfigs);
        } else if (Reflects.isSubClassOrEquals(Update.class, statement.getClass())) {
            this.transform((Update)statement, (List<WhereTransformConfig>)expressionConfigs);
        } else if (Reflects.isSubClassOrEquals(Delete.class, statement.getClass())) {
            this.transform((Delete)statement, (List<WhereTransformConfig>)expressionConfigs);
        } else if (Reflects.isSubClassOrEquals(Insert.class, statement.getClass())) {
            this.transform((Insert)statement, config.getTenant());
        }
        return statementWrapper;
    }

    private void transform(Select select, final boolean isSubSelect, List<WhereTransformConfig> expressionConfigs) {
        final PlainSelect plainSelect = JSqlParsers.extractPlainSelect(select.getSelectBody());
        if (plainSelect == null) {
            return;
        }
        Collects.forEach(expressionConfigs, (Predicate)new Predicate<WhereTransformConfig>(){

            public boolean test(WhereTransformConfig config) {
                return config != null && config.getExpression() != null && (!isSubSelect || config.isInstrumentSubSelect());
            }
        }, (Consumer)new Consumer<WhereTransformConfig>(){

            public void accept(WhereTransformConfig config) {
                Expression where = plainSelect.getWhere();
                Expression expression = ExpressionConverters.toJSqlParserExpression(config.getExpression());
                if (where == null) {
                    plainSelect.setWhere(expression);
                } else {
                    InjectPosition position = config.getPosition();
                    switch (position) {
                        case FIRST: {
                            plainSelect.setWhere((Expression)new AndExpression(expression, where));
                            break;
                        }
                        case LAST: {
                            plainSelect.setWhere((Expression)new AndExpression(where, expression));
                            break;
                        }
                    }
                }
            }
        });
    }

    private void transform(final Update update, List<WhereTransformConfig> expressionConfigs) {
        if (update.isUseSelect() && update.getSelect() != null) {
            this.transform(update.getSelect(), true, expressionConfigs);
        }
        Collects.forEach(expressionConfigs, (Predicate)new Predicate<WhereTransformConfig>(){

            public boolean test(WhereTransformConfig config) {
                return config != null && config.getExpression() != null;
            }
        }, (Consumer)new Consumer<WhereTransformConfig>(){

            public void accept(WhereTransformConfig config) {
                Expression where = update.getWhere();
                Expression expression = ExpressionConverters.toJSqlParserExpression(config.getExpression());
                if (where == null) {
                    update.setWhere(expression);
                } else {
                    InjectPosition position = config.getPosition();
                    switch (position) {
                        case FIRST: {
                            update.setWhere((Expression)new AndExpression(expression, where));
                            break;
                        }
                        case LAST: {
                            update.setWhere((Expression)new AndExpression(where, expression));
                            break;
                        }
                    }
                }
            }
        });
    }

    private void transform(final Delete delete, List<WhereTransformConfig> expressionConfigs) {
        Collects.forEach(expressionConfigs, (Predicate)new Predicate<WhereTransformConfig>(){

            public boolean test(WhereTransformConfig config) {
                return config != null && config.getExpression() != null;
            }
        }, (Consumer)new Consumer<WhereTransformConfig>(){

            public void accept(WhereTransformConfig config) {
                Expression where = delete.getWhere();
                Expression expression = ExpressionConverters.toJSqlParserExpression(config.getExpression());
                if (where == null) {
                    delete.setWhere(expression);
                } else {
                    InjectPosition position = config.getPosition();
                    switch (position) {
                        case FIRST: {
                            delete.setWhere((Expression)new AndExpression(expression, where));
                            break;
                        }
                        case LAST: {
                            delete.setWhere((Expression)new AndExpression(where, expression));
                            break;
                        }
                    }
                }
            }
        });
    }

    private void transform(Insert insert, Tenant tenant) {
    }
}

