/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.reflect.Reflects;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class CommonEnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private Class<E> enumType;

    public CommonEnumTypeHandler() {
    }

    public CommonEnumTypeHandler(@Nullable Class<E> enumType) {
        this.setEnumType(enumType);
    }

    public void setEnumType(Class<E> enumType) {
        if (enumType != null && Reflects.isSubClassOrEquals(Enum.class, enumType)) {
            this.enumType = enumType;
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        ps.setInt(i, ((CommonEnum)parameter).getCode());
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int code = rs.getInt(columnName);
        return (E)Enums.ofCode(this.enumType, (int)code);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int code = rs.getInt(columnIndex);
        return (E)Enums.ofCode(this.enumType, (int)code);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int code = cs.getInt(columnIndex);
        return (E)Enums.ofCode(this.enumType, (int)code);
    }
}

