/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis;

import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.dialect.DialectRegistry;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomVendorDatabaseIdProvider
extends VendorDatabaseIdProvider
implements DatabaseIdProvider {
    private static final Logger logger = LoggerFactory.getLogger(CustomVendorDatabaseIdProvider.class);

    public String getDatabaseId(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource cannot be null");
        }
        try {
            return DialectRegistry.guessDatabaseId((DataSource)dataSource);
        }
        catch (Exception e) {
            logger.error("Could not get a databaseId from dataSource", (Throwable)e);
            return null;
        }
    }

    public void setProperties(final Properties p) {
        Set<String> keys = p.stringPropertyNames();
        Collects.forEach(keys, (Consumer)new Consumer<String>(){

            public void accept(String key) {
                String databaseId = p.getProperty(key);
                if (Strings.isNotBlank((String)databaseId)) {
                    databaseId = Strings.trim((String)databaseId);
                    DialectRegistry.setDatabaseIdIfAbsent((String)key, (String)databaseId);
                }
            }
        });
    }
}

