/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.SqlRequest;
import com.jn.sqlhelper.dialect.SqlRequestContext;
import com.jn.sqlhelper.dialect.SqlRequestContextHolder;
import com.jn.sqlhelper.dialect.instrument.SQLStatementInstrumentor;
import com.jn.sqlhelper.mybatis.BoundSqls;
import com.jn.sqlhelper.mybatis.CustomVendorDatabaseIdProvider;
import java.sql.Connection;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisUtils {
    private static final Logger logger = LoggerFactory.getLogger(MybatisUtils.class);
    private static VendorDatabaseIdProvider vendorDatabaseIdProvider = new CustomVendorDatabaseIdProvider();

    public static VendorDatabaseIdProvider vendorDatabaseIdProvider() {
        return vendorDatabaseIdProvider;
    }

    public static boolean isPagingRowBounds(RowBounds rowBounds) {
        if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
            return false;
        }
        return rowBounds.getOffset() != 0 || rowBounds.getLimit() != Integer.MAX_VALUE;
    }

    public static boolean hasStatement(@NonNull SqlSessionFactory sessionFactory, String statementName) {
        return sessionFactory.getConfiguration().hasStatement(statementName);
    }

    public static boolean isQueryStatement(@NonNull MappedStatement statement) {
        return SqlCommandType.SELECT == statement.getSqlCommandType();
    }

    public static boolean isPreparedStatement(@NonNull MappedStatement statement) {
        return statement.getStatementType() == StatementType.PREPARED || statement.getStatementType() == StatementType.CALLABLE;
    }

    public static boolean isCallableStatement(@NonNull MappedStatement statement) {
        return statement.getStatementType() == StatementType.CALLABLE;
    }

    public static String getDatabaseId(@Nullable SqlRequestContextHolder sqlRequestContextHolder, @Nullable SQLStatementInstrumentor instrumentor, @NonNull MappedStatement ms, Executor executor) {
        return MybatisUtils.getDatabaseId(sqlRequestContextHolder, instrumentor, ms, executor, true);
    }

    public static String getDatabaseId(@Nullable SqlRequestContextHolder sqlRequestContextHolder, @Nullable SQLStatementInstrumentor instrumentor, @NonNull MappedStatement ms, @Nullable Executor executor, boolean enableExtractDialectUseNative) {
        SqlRequest request;
        SqlRequestContext sqlRequestContext;
        String databaseId = null;
        if (sqlRequestContextHolder != null && (sqlRequestContext = sqlRequestContextHolder.get()) != null && (request = sqlRequestContext.getRequest()) != null) {
            databaseId = request.getDialect();
        }
        if (Emptys.isEmpty(databaseId)) {
            databaseId = ms.getDatabaseId();
        }
        if (Emptys.isEmpty(databaseId) && instrumentor != null && instrumentor.getConfig() != null) {
            databaseId = instrumentor.getConfig().getDialect();
        }
        if (Emptys.isEmpty((Object)databaseId) && enableExtractDialectUseNative) {
            databaseId = ms.getConfiguration().getDatabaseId();
        }
        if (Emptys.isEmpty((Object)databaseId) && executor != null) {
            Transaction tx = executor.getTransaction();
            try {
                Connection connection = tx.getConnection();
                Dialect dialect = instrumentor.getDialect(connection.getMetaData());
                return dialect.getDatabaseId();
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
            }
        }
        return databaseId;
    }

    public static BoundSql rebuildBoundSql(String newSql, Configuration configuration, BoundSql boundSql) {
        BoundSql newBoundSql = new BoundSql(configuration, newSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        Map<String, Object> additionalParameters = BoundSqls.getAdditionalParameter(boundSql);
        for (Map.Entry<String, Object> entry : additionalParameters.entrySet()) {
            newBoundSql.setAdditionalParameter(entry.getKey(), entry.getValue());
        }
        return newBoundSql;
    }

    public static String getSql(BoundSql boundSql) {
        return boundSql.getSql();
    }
}

