/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.batch;

import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.common.batch.BatchStatement;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchStatement;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchUpdater;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.session.SqlSession;

public class BatchSqlBatchUpdater<E>
extends MybatisBatchUpdater<E> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchResult batchUpdate(MybatisBatchStatement statement, List<E> beans) throws SQLException {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkArgument((statement.getBatchMode() == BatchMode.BATCH_SQL ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.sessionFactory);
        SqlSession session = this.sessionFactory.openSession(true);
        BatchResult result = new BatchResult();
        result.setParameters(beans);
        result.setStatement((BatchStatement)statement);
        try {
            int updated = session.update(statement.getSql(), beans);
            result.setRowsAffected(updated);
        }
        catch (Throwable ex) {
            result.addThrowable(ex);
        }
        finally {
            session.close();
        }
        return result;
    }
}

