/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.batch;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.common.batch.BatchStatement;
import com.jn.sqlhelper.common.ddl.model.DatabaseDescription;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchStatement;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchUpdater;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcBatchUpdater<E>
extends MybatisBatchUpdater<E> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcBatchUpdater.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchResult<E> batchUpdate(MybatisBatchStatement statement, List<E> entities) throws SQLException {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkArgument((statement.getBatchMode() == BatchMode.JDBC_BATCH ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.sessionFactory);
        SqlSession session = this.sessionFactory.openSession(ExecutorType.BATCH);
        Connection connection = session.getConnection();
        DatabaseDescription databaseDescription = new DatabaseDescription(connection.getMetaData());
        if (!databaseDescription.supportsBatchUpdates()) {
            logger.warn("The database is not supports jdbc update");
            throw new UnsupportedOperationException("batch update");
        }
        BatchResult result = new BatchResult();
        result.setParameters(entities);
        result.setStatement((BatchStatement)statement);
        String statementId = statement.getStatementId();
        String statementIdFQN = statement.getSql();
        int affectedRows = 0;
        try {
            for (E entity : entities) {
                try {
                    if (statementId.contains("insert")) {
                        session.insert(statementIdFQN, entity);
                    } else if (statementId.contains("update")) {
                        session.update(statementIdFQN, entity);
                    } else if (statementId.contains("delete")) {
                        session.delete(statementIdFQN, entity);
                    } else {
                        session.update(statementIdFQN, entity);
                    }
                }
                catch (Exception ex) {
                    logger.error("Error occur when execute batch statement: {} with parameter: {}", (Object)statementIdFQN, (Object)JSONBuilderProvider.simplest().toJson(entity));
                    result.addThrowable((Throwable)ex);
                }
                ++affectedRows;
            }
            session.commit(false);
        }
        catch (Exception ex) {
            logger.error("Error occur when execute batch statement: {}", (Object)statementIdFQN);
            result.addThrowable((Throwable)ex);
            session.rollback(true);
            affectedRows = 0;
        }
        finally {
            session.close();
        }
        result.setRowsAffected(affectedRows);
        return result;
    }
}

