/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.batch;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchStatement;

public class MybatisBatchStatement
implements BatchStatement {
    private BatchMode batchMode = BatchMode.JDBC_BATCH;
    private String statementId;
    private String statementIdFQN;

    public MybatisBatchStatement() {
    }

    public MybatisBatchStatement(@NonNull String statementIdFQN) {
        this(BatchMode.JDBC_BATCH, statementIdFQN);
    }

    public MybatisBatchStatement(@Nullable BatchMode batchType, @NonNull String statementIdFQN) {
        this.setBatchMode(batchType);
        String[] segments = Strings.split((String)statementIdFQN, (String)".");
        if (segments.length <= 0) {
            throw new IllegalArgumentException("the mybatis statement id fqn is illegal");
        }
        this.setStatementId(segments[segments.length - 1]);
        this.setStatementIdFQN(statementIdFQN);
    }

    public MybatisBatchStatement(@NonNull Class mapperClass, @NonNull String statementId) {
        this(BatchMode.JDBC_BATCH, mapperClass, statementId);
    }

    public MybatisBatchStatement(@Nullable BatchMode batchType, @NonNull Class mapperClass, @NonNull String statementId) {
        this.setBatchMode(batchType);
        this.setStatementId(statementId);
        this.setStatementIdFQN(Reflects.getFQNClassName((Class)mapperClass) + "." + statementId);
    }

    public BatchMode getBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(BatchMode batchMode) {
        this.batchMode = batchMode;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public void setStatementId(String statementId) {
        Preconditions.checkNotNull((Object)statementId, (String)"mybatis sql statement id is null");
        this.statementId = statementId;
    }

    public String getSql() {
        return this.statementIdFQN;
    }

    public String getStatementIdFQN() {
        return this.statementIdFQN;
    }

    public void setStatementIdFQN(String statementIdFQN) {
        this.statementIdFQN = (String)Preconditions.checkNotNull((Object)statementIdFQN);
    }

    public String toString() {
        return JSONBuilderProvider.simplest().toJson((Object)this);
    }
}

