/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.batch;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Supplier;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.DialectRegistry;
import com.jn.sqlhelper.mybatis.MybatisUtils;
import com.jn.sqlhelper.mybatis.batch.BatchSqlBatchUpdater;
import com.jn.sqlhelper.mybatis.batch.JdbcBatchUpdater;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchStatement;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchUpdater;
import com.jn.sqlhelper.mybatis.batch.SimpleBatchUpdater;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisBatchUpdaters {
    private static final Logger logger = LoggerFactory.getLogger(MybatisBatchUpdaters.class);

    public static <E> MybatisBatchUpdater<E> createSimpleBatchUpdater(@NonNull SqlSessionFactory sessionFactory) {
        return MybatisBatchUpdaters.createBatchUpdater(sessionFactory, BatchMode.SIMPLE);
    }

    public static <E> MybatisBatchUpdater<E> createBatchSqlBatchUpdater(@NonNull SqlSessionFactory sessionFactory) {
        return MybatisBatchUpdaters.createBatchUpdater(sessionFactory, BatchMode.BATCH_SQL);
    }

    public static <E> MybatisBatchUpdater<E> createJdbcBatchUpdater(@NonNull SqlSessionFactory sessionFactory) {
        return MybatisBatchUpdaters.createBatchUpdater(sessionFactory, BatchMode.JDBC_BATCH);
    }

    public static <E> MybatisBatchUpdater<E> createBatchUpdater(@NonNull SqlSessionFactory sessionFactory, @Nullable BatchMode batchType) {
        MybatisBatchUpdater updater = null;
        if (batchType != null) {
            switch (batchType) {
                case SIMPLE: {
                    updater = new SimpleBatchUpdater();
                    break;
                }
                case BATCH_SQL: {
                    updater = new BatchSqlBatchUpdater();
                    break;
                }
                case JDBC_BATCH: {
                    updater = new JdbcBatchUpdater();
                    break;
                }
            }
        }
        if (Objects.isNotNull(updater)) {
            updater.setSessionFactory(sessionFactory);
        }
        return updater;
    }

    public static <E> BatchResult<E> batchUpdate(@NonNull SqlSessionFactory sessionFactory, @NonNull String statementIdFQN, @Nullable BatchMode batchMode, List<E> entities) throws SQLException {
        MybatisBatchStatement statement = new MybatisBatchStatement(batchMode, statementIdFQN);
        return MybatisBatchUpdaters.batch(sessionFactory, batchMode, statement, entities);
    }

    public static <E> BatchResult<E> batchUpdate(@NonNull SqlSessionFactory sessionFactory, @NonNull Class mapperClass, @NonNull String statementId, @Nullable BatchMode batchMode, List<E> entities) throws SQLException {
        MybatisBatchStatement statement = new MybatisBatchStatement(batchMode, mapperClass, statementId);
        return MybatisBatchUpdaters.batch(sessionFactory, batchMode, statement, entities);
    }

    private static <E> BatchResult<E> batch(@NonNull SqlSessionFactory sessionFactory, @Nullable BatchMode batchMode, final MybatisBatchStatement statement, List<E> entities) throws SQLException {
        boolean supportsJdbcBatch;
        Preconditions.checkArgument((boolean)Emptys.isNotEmpty(entities));
        Preconditions.checkArgument((boolean)MybatisBatchUpdaters.hasStatement(sessionFactory, statement), (Supplier)new Supplier<Object[], String>(){

            public String get(Object[] objects) {
                return StringTemplates.formatWithPlaceholder((String)"The statement {} is not exists", (Object[])new Object[]{statement.getSql()});
            }
        }, (Object[])new Object[0]);
        if (batchMode != null) {
            return MybatisBatchUpdaters.createBatchUpdater(sessionFactory, batchMode).batchUpdate(statement, entities);
        }
        Configuration configuration = sessionFactory.getConfiguration();
        String databaseId = configuration.getDatabaseId();
        Dialect dialect = null;
        if (!Strings.isEmpty((String)databaseId)) {
            dialect = DialectRegistry.getInstance().getDialectByName(databaseId);
        }
        if (Objects.isNull(dialect)) {
            SqlSession session = sessionFactory.openSession();
            Connection connection = session.getConnection();
            dialect = DialectRegistry.getInstance().getDialectByDatabaseMetadata(connection.getMetaData());
            session.close();
        }
        boolean supportsBatchSqlMode = dialect != null && dialect.isSupportsBatchSql();
        MybatisBatchUpdater<E> updater = null;
        BatchResult result = null;
        if (supportsBatchSqlMode) {
            statement.setBatchMode(BatchMode.BATCH_SQL);
            updater = MybatisBatchUpdaters.createBatchSqlBatchUpdater(sessionFactory);
            result = updater.batchUpdate(statement, entities);
            if (!result.hasThrowable()) {
                return result;
            }
            logger.warn("Error when execute batch update based on database's batch sql, may be the statement {} not a batch sql, will use jdbc batch method execute it. error: {}", (Object)statement.getSql(), result.getThrowables().get(0));
        }
        boolean bl = supportsJdbcBatch = dialect != null && dialect.isSupportsBatchUpdates();
        if (supportsJdbcBatch) {
            statement.setBatchMode(BatchMode.JDBC_BATCH);
            updater = MybatisBatchUpdaters.createJdbcBatchUpdater(sessionFactory);
            result = updater.batchUpdate(statement, entities);
            if (result.hasThrowable()) {
                logger.warn("Error when execute batch update based jdbc batch mode, statement: {}, errors:", (Object)statement.getSql());
                Collects.forEach((Collection)result.getThrowables(), (Consumer2)new Consumer2<Integer, Throwable>(){

                    public void accept(Integer index, Throwable throwable) {
                        logger.warn("errors[{}]", (Object)index, (Object)throwable);
                    }
                });
            } else {
                return result;
            }
        }
        statement.setBatchMode(BatchMode.SIMPLE);
        updater = MybatisBatchUpdaters.createSimpleBatchUpdater(sessionFactory);
        result = updater.batchUpdate(statement, entities);
        if (result.hasThrowable()) {
            logger.warn("Error when execute batch update based simple batch mode, statement: {}, errors", (Object)statement.getSql());
            Collects.forEach((Collection)result.getThrowables(), (Consumer2)new Consumer2<Integer, Throwable>(){

                public void accept(Integer index, Throwable throwable) {
                    logger.warn("errors[{}]", (Object)index, (Object)throwable);
                }
            });
        }
        return result;
    }

    public static boolean hasStatement(@NonNull SqlSessionFactory sessionFactory, @NonNull MybatisBatchStatement statement) {
        return MybatisUtils.hasStatement(sessionFactory, statement.getSql());
    }
}

