/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.batch;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.common.batch.BatchStatement;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchStatement;
import com.jn.sqlhelper.mybatis.batch.MybatisBatchUpdater;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBatchUpdater<E>
extends MybatisBatchUpdater<E> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBatchUpdater.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchResult<E> batchUpdate(MybatisBatchStatement statement, List<E> entities) throws SQLException {
        Preconditions.checkNotNull((Object)this.sessionFactory);
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkArgument((statement.getBatchMode() == BatchMode.SIMPLE ? 1 : 0) != 0);
        SqlSession session = this.sessionFactory.openSession(true);
        BatchResult result = new BatchResult();
        result.setParameters(entities);
        result.setStatement((BatchStatement)statement);
        String statementId = statement.getStatementId();
        String statementIdFQN = statement.getSql();
        int affectedRows = 0;
        try {
            for (E entity : entities) {
                int updated = 0;
                try {
                    updated = statementId.contains("insert") ? session.insert(statementIdFQN, entity) : (statementId.contains("update") ? session.update(statementIdFQN, entity) : (statementId.contains("delete") ? session.delete(statementIdFQN, entity) : session.update(statementIdFQN, entity)));
                }
                catch (Exception ex) {
                    logger.error("Error occur when execute batch statement: {} with parameter: {}", (Object)statementIdFQN, (Object)JSONBuilderProvider.simplest().toJson(entity));
                    result.addThrowable((Throwable)ex);
                }
                if (updated < 0) {
                    logger.warn("the affectedRows < 0 , maybe your default executor type is not simple");
                    updated = 1;
                }
                affectedRows += updated;
            }
            session.commit(true);
        }
        catch (Exception ex) {
            logger.error("Error occur when execute batch statement: {}", (Object)statementIdFQN);
            result.addThrowable((Throwable)ex);
        }
        finally {
            session.close();
        }
        result.setRowsAffected(affectedRows);
        return result;
    }
}

