/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.plugins;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objects;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.sqlhelper.dialect.SqlRequestContext;
import com.jn.sqlhelper.dialect.SqlRequestContextHolder;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import com.jn.sqlhelper.dialect.pagination.PagedPreparedParameterSetter;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContext;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContextHolder;
import com.jn.sqlhelper.dialect.pagination.QueryParameters;
import com.jn.sqlhelper.mybatis.MybatisUtils;
import com.jn.sqlhelper.mybatis.plugins.MybatisQueryParameters;
import com.jn.sqlhelper.mybatis.plugins.NestedStatements;
import com.jn.sqlhelper.mybatis.plugins.SqlHelperMybatisPlugin;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMybatisParameterHandler
implements ParameterHandler,
PagedPreparedParameterSetter {
    private static final Logger logger = LoggerFactory.getLogger(CustomMybatisParameterHandler.class);
    private static final PagingRequestContextHolder PAGING_CONTEXT = PagingRequestContextHolder.getContext();
    protected final TypeHandlerRegistry typeHandlerRegistry;
    protected final MappedStatement mappedStatement;
    protected Object parameterObject;
    protected final BoundSql boundSql;
    protected final Configuration configuration;

    public CustomMybatisParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        this.mappedStatement = mappedStatement;
        this.configuration = mappedStatement.getConfiguration();
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.parameterObject = parameterObject;
        this.boundSql = boundSql;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    protected Object getOriginParameterObject() {
        return this.parameterObject;
    }

    private boolean isPagingCountStatement() {
        PagingRequestContext requestContext = PAGING_CONTEXT.get();
        return requestContext.get("countSql") == this.boundSql;
    }

    private boolean isInPagingRequestScope() {
        return PAGING_CONTEXT.getPagingRequest() != null;
    }

    private boolean isInvalidPagingRequest() {
        return !PAGING_CONTEXT.getPagingRequest().isValidRequest();
    }

    private List<Integer> getEscapeLikeParametersIndexes() {
        SqlRequestContext sqlRequestContext = SqlRequestContextHolder.getInstance().get();
        if (Objects.isNull((Object)sqlRequestContext) || Objects.isNull((Object)sqlRequestContext.getRequest())) {
            return null;
        }
        if (Objects.isNull((Object)sqlRequestContext.get("LIKE_ESCAPER"))) {
            return null;
        }
        return (List)sqlRequestContext.get("LIKE_ESCAPE_PARAMETERS_INDEXES");
    }

    public void setParameters(PreparedStatement ps) {
        if (!MybatisUtils.isQueryStatement(this.mappedStatement) || !this.isInPagingRequestScope() || this.isInvalidPagingRequest() || this.isPagingCountStatement() || NestedStatements.isNestedStatement(this.mappedStatement)) {
            this.setParameters(ps, this.boundSql.getParameterMappings(), 1, this.getEscapeLikeParametersIndexes());
            return;
        }
        try {
            MybatisQueryParameters queryParameters = new MybatisQueryParameters();
            queryParameters.setRowSelection(PAGING_CONTEXT.getRowSelection());
            queryParameters.setCallable(MybatisUtils.isCallableStatement(this.mappedStatement));
            PagingRequestContext request = PAGING_CONTEXT.get();
            queryParameters.setParameters(this.getParameterObject(), request.getInteger((Object)"BEFORE_SUBQUERY_PARAMETERS_COUNT", Integer.valueOf(0)), request.getInteger((Object)"AFTER_SUBQUERY_PARAMETERS_COUNT", Integer.valueOf(0)));
            SqlHelperMybatisPlugin.getInstrumentor().bindParameters(ps, (PagedPreparedParameterSetter)this, (QueryParameters)queryParameters, true);
        }
        catch (SQLException ex) {
            logger.error("errorCode:{},message:{}", new Object[]{ex.getErrorCode(), ex.getMessage(), ex});
        }
    }

    public int setOriginalParameters(PreparedStatement ps, QueryParameters parameters, int startIndex) {
        List parameterMappings = this.boundSql.getParameterMappings();
        this.setParameters(ps, parameterMappings, startIndex, this.getEscapeLikeParametersIndexes());
        return this.boundSql.getParameterMappings().size();
    }

    private void setParameters(PreparedStatement ps, List<ParameterMapping> parameterMappings, int startIndex, List<Integer> escapeLikeParametersIndexes) {
        boolean needEscapeLikeParameters = Emptys.isNotEmpty(escapeLikeParametersIndexes);
        LikeEscaper likeEscaper = null;
        if (needEscapeLikeParameters) {
            likeEscaper = (LikeEscaper)SqlRequestContextHolder.getInstance().get().get("LIKE_ESCAPER");
        }
        ErrorContext.instance().activity("setting parameters").object(this.mappedStatement.getParameterMap().getId());
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                Object parameterObject = this.getOriginParameterObject();
                if (this.boundSql.hasAdditionalParameter(propertyName)) {
                    value = this.boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (this.typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = this.configuration.getJdbcTypeForNull();
                }
                try {
                    if (value instanceof String && needEscapeLikeParameters && escapeLikeParametersIndexes.contains(i + startIndex - 1)) {
                        value = likeEscaper.escape(value.toString());
                    }
                    typeHandler.setParameter(ps, i + startIndex, value, jdbcType);
                    continue;
                }
                catch (TypeException e) {
                    throw new TypeException("Could not set parameters for mapping: " + parameterMapping + ". Cause: " + (Object)((Object)e), (Throwable)e);
                }
                catch (SQLException e) {
                    throw new TypeException("Could not set parameters for mapping: " + parameterMapping + ". Cause: " + e, (Throwable)e);
                }
            }
        }
    }

    public int setBeforeSubqueryParameters(PreparedStatement statement, QueryParameters queryParameters, int startIndex) throws SQLException {
        List parameterMappings = this.boundSql.getParameterMappings();
        List before = Collects.limit((Collection)parameterMappings, (int)queryParameters.getBeforeSubqueryParameterCount());
        this.setParameters(statement, before, startIndex, this.getEscapeLikeParametersIndexes());
        return queryParameters.getBeforeSubqueryParameterCount();
    }

    public int setSubqueryParameters(PreparedStatement statement, QueryParameters queryParameters, int startIndex) throws SQLException {
        List parameterMappings = this.boundSql.getParameterMappings();
        List subquery = Pipeline.of((Iterable)parameterMappings).limit(parameterMappings.size() - queryParameters.getAfterSubqueryParameterCount()).skip(queryParameters.getBeforeSubqueryParameterCount()).asList();
        this.setParameters(statement, subquery, startIndex, this.getEscapeLikeParametersIndexes());
        return subquery.size();
    }

    public int setAfterSubqueryParameters(PreparedStatement statement, QueryParameters queryParameters, int startIndex) throws SQLException {
        List parameterMappings = this.boundSql.getParameterMappings();
        List after = Collects.skip((Collection)parameterMappings, (int)(parameterMappings.size() - queryParameters.getAfterSubqueryParameterCount()));
        this.setParameters(statement, after, startIndex, this.getEscapeLikeParametersIndexes());
        return queryParameters.getBeforeSubqueryParameterCount();
    }
}

