/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.plugins;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objects;
import java.lang.reflect.Method;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class ExecutorInvocation {
    @NonNull
    private Invocation invocation;
    @NonNull
    private String methodName;
    @NonNull
    private Executor executor;
    @NonNull
    private Object parameter;
    @NonNull
    private MappedStatement mappedStatement;
    @Nullable
    private RowBounds rowBounds;
    @Nullable
    private ResultHandler resultHandler;
    @Nullable
    private CacheKey cacheKey;
    @NonNull
    private BoundSql boundSql;
    private boolean boundSqlChanged = false;
    private Object result;

    public ExecutorInvocation(Invocation invocation) {
        this.invocation = invocation;
        this.executor = (Executor)invocation.getTarget();
        this.parse();
    }

    private void parse() {
        String methodName;
        Method method = this.invocation.getMethod();
        this.methodName = methodName = method.getName();
        if (methodName.equals("query")) {
            this.parseQuery();
        } else if (methodName.equals("queryCursor")) {
            this.parseQueryCursor();
        } else if (methodName.equals("update")) {
            this.parseUpdate();
        }
    }

    private BoundSql parseBoundSql() {
        if (Objects.isNull((Object)this.boundSql)) {
            Object[] args = this.invocation.getArgs();
            if (this.methodName.equals("query") && args.length > 4) {
                this.cacheKey = (CacheKey)args[4];
                this.boundSql = (BoundSql)args[5];
            }
            if (Objects.isNull((Object)this.boundSql)) {
                this.boundSql = this.mappedStatement.getBoundSql(this.parameter);
            }
            if (this.methodName.equals("query") && Objects.isNull((Object)this.cacheKey)) {
                this.cacheKey = this.executor.createCacheKey(this.mappedStatement, this.parameter, this.rowBounds, this.boundSql);
            }
        }
        return this.boundSql;
    }

    private void parseQuery() {
        Object[] args = this.invocation.getArgs();
        this.mappedStatement = (MappedStatement)args[0];
        this.parameter = args[1];
        this.rowBounds = (RowBounds)args[2];
        this.resultHandler = (ResultHandler)args[3];
    }

    private void parseQueryCursor() {
        Object[] args = this.invocation.getArgs();
        this.mappedStatement = (MappedStatement)args[0];
        this.parameter = args[1];
        this.rowBounds = (RowBounds)args[2];
    }

    private void parseUpdate() {
        Object[] args = this.invocation.getArgs();
        this.mappedStatement = (MappedStatement)args[0];
        this.parameter = args[1];
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public MappedStatement getMappedStatement() {
        return this.mappedStatement;
    }

    public RowBounds getRowBounds() {
        return this.rowBounds;
    }

    public ResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    public BoundSql getBoundSql() {
        return Objects.isNull((Object)this.boundSql) ? this.parseBoundSql() : this.boundSql;
    }

    public void setBoundSql(BoundSql boundSql) {
        if (Objects.isNotNull((Object)this.boundSql)) {
            this.boundSqlChanged = true;
        }
        this.boundSql = boundSql;
        if (!this.methodName.equals("update")) {
            this.cacheKey = this.executor.createCacheKey(this.mappedStatement, this.parameter, this.rowBounds, boundSql);
        }
    }

    public boolean isBoundSqlChanged() {
        return this.boundSqlChanged;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public String toString() {
        return "ExecutorInvocation{}";
    }
}

