/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.plugins;

import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.pipeline.DebugHandler;
import com.jn.langx.pipeline.DefaultPipeline;
import com.jn.langx.pipeline.Handler;
import com.jn.langx.pipeline.Pipeline;
import com.jn.langx.pipeline.Pipelines;
import com.jn.langx.text.properties.PropertiesAccessor;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.dialect.SqlRequestContext;
import com.jn.sqlhelper.dialect.SqlRequestContextHolder;
import com.jn.sqlhelper.dialect.instrument.SQLInstrumentorConfig;
import com.jn.sqlhelper.dialect.instrument.SQLStatementInstrumentor;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContext;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContextHolder;
import com.jn.sqlhelper.mybatis.plugins.ExecutorInvocation;
import com.jn.sqlhelper.mybatis.plugins.ExecutorInvocationSinkHandler;
import com.jn.sqlhelper.mybatis.plugins.NestedStatements;
import com.jn.sqlhelper.mybatis.plugins.likeescape.LikeParameterEscapeHandler;
import com.jn.sqlhelper.mybatis.plugins.pagination.PaginationConfig;
import com.jn.sqlhelper.mybatis.plugins.pagination.PaginationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="queryCursor", args={MappedStatement.class, Object.class, RowBounds.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SqlHelperMybatisPlugin
implements Interceptor,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(SqlHelperMybatisPlugin.class);
    private PaginationConfig paginationConfig = new PaginationConfig();
    private static SQLStatementInstrumentor instrumentor = new SQLStatementInstrumentor();
    private boolean inited = false;
    private Map<String, Handler> handlerRegistry = new HashMap<String, Handler>();

    public void init() throws InitializationException {
        if (!this.inited) {
            logger.info("===[SQLHelper]=== Initial SQLHelper MyBatis Plugin");
            instrumentor.init();
            DebugHandler debugHandler = new DebugHandler();
            this.handlerRegistry.put("debug", (Handler)debugHandler);
            LikeParameterEscapeHandler likeParameterEscapeHandler = new LikeParameterEscapeHandler();
            likeParameterEscapeHandler.setEscapeLikeParameter(instrumentor.getConfig().isEscapeLikeParameter());
            likeParameterEscapeHandler.setExtractDialectUseNativeEnabled(instrumentor.getConfig().isExtractDialectUseNativeEnabled());
            this.handlerRegistry.put("likeEscape", (Handler)likeParameterEscapeHandler);
            PaginationHandler paginationHandler = new PaginationHandler();
            paginationHandler.setPaginationConfig(this.paginationConfig);
            paginationHandler.setExtractDialectUseNativeEnabled(instrumentor.getConfig().isExtractDialectUseNativeEnabled());
            paginationHandler.init();
            this.handlerRegistry.put("pagination", (Handler)paginationHandler);
            if (this.paginationConfig.isPageHelperCompatible()) {
                try {
                    Class pageHelperHandlerClass = ClassLoaders.loadClass((String)this.paginationConfig.getPageHelperHandlerClass(), SqlHelperMybatisPlugin.class);
                    Handler pageHelperHandler = (Handler)Reflects.newInstance((Class)pageHelperHandlerClass);
                    this.handlerRegistry.put("pagehelper", pageHelperHandler);
                }
                catch (ClassNotFoundException ex) {
                    logger.info("Can't find the pageHelperHandler, maybe it is unnecessary");
                    this.paginationConfig.setPageHelperCompatible(false);
                }
            }
            ExecutorInvocationSinkHandler sinkHandler = new ExecutorInvocationSinkHandler();
            this.handlerRegistry.put("sink", (Handler)sinkHandler);
            this.inited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        SqlRequestContext requestContext = SqlRequestContextHolder.getInstance().get();
        if (requestContext == null) {
            return invocation.proceed();
        }
        if (requestContext.getBoolean((Object)"SQLHELPER_HANDLED", Boolean.valueOf(false)).booleanValue()) {
            return invocation.proceed();
        }
        ExecutorInvocation executorInvocation = new ExecutorInvocation(invocation);
        try {
            requestContext.setBoolean((Object)"SQLHELPER_HANDLED", true);
            Pipeline<ExecutorInvocation> pipeline = this.createPipeline(executorInvocation);
            pipeline.inbound();
            if (!pipeline.hadOutbound()) {
                Pipelines.outbound(pipeline);
            }
            Object object = executorInvocation.getResult();
            return object;
        }
        finally {
            requestContext = SqlRequestContextHolder.getInstance().get();
            if (requestContext != null) {
                requestContext.remove("SQLHELPER_HANDLED");
            }
            if (!NestedStatements.isNestedStatement(executorInvocation.getMappedStatement())) {
                SqlRequestContextHolder.getInstance().clear();
            }
        }
    }

    private Pipeline<ExecutorInvocation> createPipeline(ExecutorInvocation executorInvocation) {
        Handler debugHandler = this.handlerRegistry.get("debug");
        Handler sinkHandler = this.handlerRegistry.get("sink");
        List handlers = Collects.emptyArrayList();
        if ("query".equals(executorInvocation.getMethodName())) {
            PagingRequestContext context;
            boolean isPageHelperRequest;
            handlers.add(this.handlerRegistry.get("likeEscape"));
            handlers.add(this.handlerRegistry.get("pagination"));
            Handler pageHelperHandler = this.handlerRegistry.get("pagehelper");
            if (this.paginationConfig.isPageHelperCompatible() && pageHelperHandler != null && PagingRequestContextHolder.getContext().isPagingRequest() && (isPageHelperRequest = (context = PagingRequestContextHolder.getContext().get()).getBoolean((Object)"pagehelper", Boolean.valueOf(false)).booleanValue())) {
                handlers.add(pageHelperHandler);
            }
        }
        DefaultPipeline pipeline = Pipelines.newPipeline((Handler)debugHandler, (Handler)sinkHandler, (List)handlers);
        pipeline.bindTarget((Object)executorInvocation);
        return pipeline;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            if (logger.isDebugEnabled()) {
                logger.debug("wrap mybatis executor {}", target.getClass());
            }
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        logger.info("{}", (Object)properties);
        if (!this.inited) {
            PropertiesAccessor accessor = new PropertiesAccessor(properties);
            PaginationConfig paginationConfig = this.parsePaginationConfig(accessor);
            SQLInstrumentorConfig instrumentConfig = this.parseInstrumentorConfig(accessor);
            this.setInstrumentorConfig(instrumentConfig);
            this.setPaginationConfig(paginationConfig);
            this.init();
        }
    }

    public void setPaginationConfig(PaginationConfig config) {
        this.paginationConfig = config;
    }

    public void setInstrumentorConfig(SQLInstrumentorConfig config) {
        instrumentor.setConfig(config);
    }

    public static SQLStatementInstrumentor getInstrumentor() {
        return instrumentor;
    }

    private PaginationConfig parsePaginationConfig(PropertiesAccessor accessor) {
        PaginationConfig paginationConfig = new PaginationConfig();
        String paginationPluginConfigPrefix = "sqlhelper.mybatis.pagination.";
        paginationConfig.setCount(accessor.getBoolean((Object)(paginationPluginConfigPrefix + "count"), Boolean.valueOf(paginationConfig.isCount())));
        paginationConfig.setCountCacheExpireInSeconds(accessor.getInteger((Object)(paginationPluginConfigPrefix + "countCacheExpireInSeconds"), Integer.valueOf(paginationConfig.getCountCacheExpireInSeconds())));
        paginationConfig.setCountCacheInitCapacity(accessor.getInteger((Object)(paginationPluginConfigPrefix + "countCacheInitCapacity"), Integer.valueOf(paginationConfig.getCountCacheInitCapacity())));
        paginationConfig.setCountCacheMaxCapacity(accessor.getInteger((Object)(paginationPluginConfigPrefix + "countCacheMaxCapacity"), Integer.valueOf(paginationConfig.getCountCacheMaxCapacity())));
        paginationConfig.setCountSuffix(accessor.getString(paginationPluginConfigPrefix + "countSuffix", paginationConfig.getCountSuffix()));
        paginationConfig.setDefaultPageSize(accessor.getInteger((Object)(paginationPluginConfigPrefix + "defaultPageSize"), Integer.valueOf(paginationConfig.getDefaultPageSize())));
        paginationConfig.setUseLastPageIfPageOut(accessor.getBoolean((Object)(paginationPluginConfigPrefix + "useLastPageIfPageOut"), accessor.getBoolean((Object)(paginationPluginConfigPrefix + "useLastPageIfPageNoOut"), Boolean.valueOf(paginationConfig.isUseLastPageIfPageOut()))));
        paginationConfig.setPageHelperCompatible(accessor.getBoolean((Object)(paginationPluginConfigPrefix + "pageHelperCompatible"), Boolean.valueOf(paginationConfig.isPageHelperCompatible())));
        paginationConfig.setPageHelperHandlerClass(accessor.getString(paginationPluginConfigPrefix + "pageHelperHandlerClass", paginationConfig.getPageHelperHandlerClass()));
        return paginationConfig;
    }

    private SQLInstrumentorConfig parseInstrumentorConfig(PropertiesAccessor accessor) {
        SQLInstrumentorConfig instrumentConfig = new SQLInstrumentorConfig();
        String instrumentorConfigPrefix = "sqlhelper.mybatis.instrumentor.";
        instrumentConfig.setName(accessor.getString(instrumentorConfigPrefix + "name", "undefined"));
        instrumentConfig.setSubqueryPagingStartFlag(accessor.getString(instrumentorConfigPrefix + "subqueryPagingStartFlag", "[PAGING_START]"));
        instrumentConfig.setSubqueryPagingEndFlag(accessor.getString(instrumentorConfigPrefix + "subqueryPagingEndFlag", "[PAGING_END]"));
        instrumentConfig.setDialect(accessor.getString(instrumentorConfigPrefix + "dialect", instrumentConfig.getDialect()));
        instrumentConfig.setInstrumentation(accessor.getString(instrumentorConfigPrefix + "instrumentation", instrumentConfig.getInstrumentation()));
        instrumentConfig.setDialectClassName(accessor.getString(instrumentorConfigPrefix + "dialectClassName", instrumentConfig.getDialectClassName()));
        instrumentConfig.setCacheInstrumentedSql(accessor.getBoolean((Object)(instrumentorConfigPrefix + "cacheInstruemtedSql"), Boolean.valueOf(false)).booleanValue());
        instrumentConfig.setEscapeLikeParameter(accessor.getBoolean((Object)(instrumentorConfigPrefix + "escapeLikeParameter"), Boolean.valueOf(false)).booleanValue());
        instrumentConfig.setExtractDialectUseNativeEnabled(accessor.getBoolean((Object)(instrumentorConfigPrefix + "extractDialectUseNativeEnabled"), Boolean.valueOf(true)).booleanValue());
        return instrumentConfig;
    }
}

