/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.plugins.likeescape;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.pipeline.AbstractHandler;
import com.jn.langx.pipeline.HandlerContext;
import com.jn.langx.pipeline.Pipelines;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Strings;
import com.jn.langx.util.struct.Pair;
import com.jn.sqlhelper.common.formatter.SqlDmlFormatter;
import com.jn.sqlhelper.dialect.SqlRequest;
import com.jn.sqlhelper.dialect.SqlRequestContext;
import com.jn.sqlhelper.dialect.SqlRequestContextHolder;
import com.jn.sqlhelper.dialect.instrument.SQLStatementInstrumentor;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscapers;
import com.jn.sqlhelper.mybatis.MybatisUtils;
import com.jn.sqlhelper.mybatis.plugins.ExecutorInvocation;
import com.jn.sqlhelper.mybatis.plugins.SqlHelperMybatisPlugin;
import java.util.List;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeParameterEscapeHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(LikeParameterEscapeHandler.class);
    private boolean escapeLikeParameter;
    private boolean extractDialectUseNativeEnabled;

    public void setEscapeLikeParameter(boolean escapeLikeParameter) {
        this.escapeLikeParameter = escapeLikeParameter;
    }

    public void setExtractDialectUseNativeEnabled(boolean extractDialectUseNativeEnabled) {
        this.extractDialectUseNativeEnabled = extractDialectUseNativeEnabled;
    }

    public void inbound(HandlerContext ctx) throws Throwable {
        ExecutorInvocation executorInvocation = (ExecutorInvocation)ctx.getPipeline().getTarget();
        MappedStatement mappedStatement = executorInvocation.getMappedStatement();
        if (!(MybatisUtils.isQueryStatement(mappedStatement) && MybatisUtils.isPreparedStatement(mappedStatement) && this.isEnableLikeEscape())) {
            Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
            return;
        }
        SqlRequestContext sqlContext = SqlRequestContextHolder.getInstance().get();
        LikeEscaper likeEscaper = this.getLikeEscaper(mappedStatement, sqlContext.getRequest(), executorInvocation);
        if (Objects.isNull((Object)likeEscaper)) {
            logger.warn("Can't find a suitable LikeEscaper for the sql request: {}, statement id: {}", (Object)sqlContext.getRequest(), (Object)mappedStatement.getId());
            Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
            return;
        }
        sqlContext.getRequest().setLikeEscaper(likeEscaper);
        BoundSql boundSql = executorInvocation.getBoundSql();
        String sql = boundSql.getSql();
        Pair pair = LikeEscapers.findEscapedSlots((String)sql);
        if (Emptys.isEmpty((Object)pair.getKey()) && Emptys.isEmpty((Object)pair.getValue())) {
            Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
            return;
        }
        String newSql = LikeEscapers.insertLikeEscapeDeclares((String)sql, (List)((List)pair.getValue()), (LikeEscaper)likeEscaper);
        sqlContext.getRequest().setLikeParameterIndexes((List)pair.getKey());
        if (logger.isDebugEnabled()) {
            SqlDmlFormatter sqlDmlFormatter = new SqlDmlFormatter();
            logger.debug("\n---------------original sql---------------\n{} \n\n---------------after like escapse: ---------------\n{}", (Object)sqlDmlFormatter.format(sql, new Object[0]), (Object)sqlDmlFormatter.format(newSql, new Object[0]));
        }
        boundSql = MybatisUtils.rebuildBoundSql(newSql, mappedStatement.getConfiguration(), boundSql);
        executorInvocation.setBoundSql(boundSql);
        sqlContext.set("LIKE_ESCAPE_PARAMETERS_INDEXES", pair.getKey());
        sqlContext.set("LIKE_ESCAPER", (Object)likeEscaper);
        Pipelines.inbound((HandlerContext)ctx);
    }

    private boolean isEnableLikeEscape() {
        SqlRequestContext sqlContext = SqlRequestContextHolder.getInstance().get();
        if (sqlContext == null) {
            SqlRequestContextHolder.getInstance().setSqlRequest(new SqlRequest().setEscapeLikeParameter(Boolean.valueOf(this.escapeLikeParameter)));
            return this.escapeLikeParameter;
        }
        SqlRequest sqlRequest = sqlContext.getRequest();
        if (sqlRequest.isEscapeLikeParameter() == null) {
            sqlRequest.setEscapeLikeParameter(Boolean.valueOf(this.escapeLikeParameter));
            return this.escapeLikeParameter;
        }
        return sqlRequest.isEscapeLikeParameter();
    }

    private LikeEscaper getLikeEscaper(@NonNull MappedStatement ms, @Nullable SqlRequest sqlRequest, ExecutorInvocation executorInvocation) {
        LikeEscaper likeEscaper = null;
        if (sqlRequest != null) {
            likeEscaper = sqlRequest.getLikeEscaper();
        }
        if (likeEscaper == null) {
            SQLStatementInstrumentor instrumentor = SqlHelperMybatisPlugin.getInstrumentor();
            String databaseId = MybatisUtils.getDatabaseId(SqlRequestContextHolder.getInstance(), instrumentor, ms, executorInvocation.getExecutor(), this.extractDialectUseNativeEnabled);
            if (Strings.isNotBlank((String)databaseId) && (likeEscaper = instrumentor.getDialectRegistry().getDialectByName(databaseId)) != null && sqlRequest != null) {
                sqlRequest.setDialect(databaseId);
            }
        }
        return likeEscaper;
    }
}

