/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.plugins.pagination;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.cache.Cache;
import com.jn.langx.cache.CacheBuilder;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.pipeline.AbstractHandler;
import com.jn.langx.pipeline.HandlerContext;
import com.jn.langx.pipeline.Pipelines;
import com.jn.langx.util.Chars;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.sqlhelper.dialect.SqlRequestContextHolder;
import com.jn.sqlhelper.dialect.instrument.SQLStatementInstrumentor;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;
import com.jn.sqlhelper.dialect.pagination.PagingRequestBasedRowSelectionBuilder;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContext;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContextHolder;
import com.jn.sqlhelper.dialect.pagination.PagingResult;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import com.jn.sqlhelper.dialect.pagination.SqlPaginations;
import com.jn.sqlhelper.mybatis.MybatisUtils;
import com.jn.sqlhelper.mybatis.plugins.ExecutorInvocation;
import com.jn.sqlhelper.mybatis.plugins.NestedStatements;
import com.jn.sqlhelper.mybatis.plugins.SqlHelperMybatisPlugin;
import com.jn.sqlhelper.mybatis.plugins.pagination.PaginationConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationHandler
extends AbstractHandler
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(PaginationHandler.class);
    private static final PagingRequestContextHolder PAGING_CONTEXT = PagingRequestContextHolder.getContext();
    private PagingRequestBasedRowSelectionBuilder rowSelectionBuilder = new PagingRequestBasedRowSelectionBuilder();
    private PaginationConfig paginationConfig = new PaginationConfig();
    private Cache<String, MappedStatement> countStatementCache;
    private String countSuffix = "_COUNT";
    private static final String ORDER_BY_SUFFIX = "_orderBy";
    private boolean inited = false;
    private boolean extractDialectUseNativeEnabled = true;

    public String toString() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void init() {
        if (!this.inited) {
            this.rowSelectionBuilder.setDefaultPageSize(this.paginationConfig.getDefaultPageSize());
            if (this.paginationConfig.enableCountCache()) {
                this.countStatementCache = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite((long)this.paginationConfig.getCountCacheExpireInSeconds()).initialCapacity(this.paginationConfig.getCountCacheInitCapacity()).maxCapacity(this.paginationConfig.getCountCacheMaxCapacity()).build();
                this.countSuffix = Strings.isBlank((String)this.paginationConfig.getCountSuffix()) ? "_COUNT" : this.paginationConfig.getCountSuffix().trim();
            }
            this.inited = true;
        }
    }

    public void setPaginationConfig(PaginationConfig config) {
        this.paginationConfig = config;
    }

    public void setExtractDialectUseNativeEnabled(boolean extractDialectUseNativeEnabled) {
        this.extractDialectUseNativeEnabled = extractDialectUseNativeEnabled;
    }

    private boolean isUseLastPageIfPageOut(@NonNull PagingRequest request) {
        Preconditions.checkNotNull((Object)request);
        if (request.isUseLastPageIfPageOut() == null) {
            return this.paginationConfig.isUseLastPageIfPageOut();
        }
        return request.isUseLastPageIfPageOut();
    }

    public void inbound(HandlerContext ctx) throws Throwable {
        ExecutorInvocation executorInvocation = (ExecutorInvocation)ctx.getPipeline().getTarget();
        if (MybatisUtils.isQueryStatement(executorInvocation.getMappedStatement()) && executorInvocation.getMethodName().equals("query")) {
            this.intercept(ctx);
        } else {
            if (!MybatisUtils.isQueryStatement(executorInvocation.getMappedStatement()) && this.isPagingRequest(executorInvocation.getMappedStatement())) {
                logger.warn("The sql {} is not a select statement, but the PagingRequest was supplied . Please check your usage", (Object)MybatisUtils.getSql(executorInvocation.getBoundSql()));
            }
            Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(HandlerContext ctx) {
        block42: {
            ExecutorInvocation executorInvocation = (ExecutorInvocation)ctx.getPipeline().getTarget();
            MappedStatement ms = executorInvocation.getMappedStatement();
            Object parameter = executorInvocation.getParameter();
            RowBounds rowBounds = executorInvocation.getRowBounds();
            Executor executor = executorInvocation.getExecutor();
            BoundSql boundSql = executorInvocation.getBoundSql();
            CacheKey cacheKey = executorInvocation.getCacheKey();
            ResultHandler resultHandler = executorInvocation.getResultHandler();
            ArrayList rs = null;
            this.setPagingRequestBasedRowBounds(rowBounds);
            try {
                if (!this.isPagingRequest(ms)) {
                    if (PAGING_CONTEXT.isOrderByRequest() && !NestedStatements.isNestedStatement(ms)) {
                        rs = this.executeOrderBy(PAGING_CONTEXT.getPagingRequest().getOrderBy(), ms, parameter, RowBounds.DEFAULT, resultHandler, executor, boundSql);
                    } else {
                        Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
                        rs = executorInvocation.getResult();
                    }
                    if (rs == null) {
                        rs = Collects.emptyArrayList();
                    }
                    executorInvocation.setResult(rs);
                    break block42;
                }
                if (NestedStatements.isNestedStatement(ms)) {
                    Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
                    rs = executorInvocation.getResult();
                    if (rs == null) {
                        rs = Collects.emptyArrayList();
                    }
                    executorInvocation.setResult(rs);
                    break block42;
                }
                PagingRequest request = PAGING_CONTEXT.getPagingRequest();
                PagingResult result = new PagingResult();
                request.setResult(result);
                result.setPageSize(request.getPageSize());
                ArrayList items = new ArrayList();
                int requestPageNo = request.getPageNo();
                result.setPageNo(request.getPageNo());
                result.setItems(items);
                if (request.isEmptyRequest()) {
                    result.setTotal(0L);
                    rs = items;
                    executorInvocation.setResult(rs);
                    return;
                }
                if (request.isGetAllRequest()) {
                    if (PAGING_CONTEXT.isOrderByRequest()) {
                        rs = this.executeOrderBy(PAGING_CONTEXT.getPagingRequest().getOrderBy(), ms, parameter, RowBounds.DEFAULT, resultHandler, executor, boundSql);
                    } else {
                        Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
                        rs = executorInvocation.getResult();
                    }
                    if (rs == null) {
                        rs = Collects.emptyArrayList();
                    }
                    if (rs instanceof Collection) {
                        items.addAll(rs);
                        result.setTotal((long)items.size());
                    }
                    executorInvocation.setResult(items);
                    return;
                }
                if (this.beginIfSupportsLimit(ms, executorInvocation)) {
                    boolean needQuery = true;
                    try {
                        if (this.needCount(request)) {
                            int count = this.executeCount(ms, parameter, rowBounds, resultHandler, executor, boundSql);
                            if (count == 0) {
                                needQuery = false;
                            }
                            result.setTotal((long)count);
                            int maxPageCount = result.getMaxPage();
                            if (maxPageCount >= 0 && requestPageNo > maxPageCount) {
                                if (this.isUseLastPageIfPageOut(request)) {
                                    request.setPageNo(maxPageCount);
                                    result.setPageNo(maxPageCount);
                                } else {
                                    needQuery = false;
                                }
                            }
                        } else {
                            result.setTotal(-1L);
                        }
                    }
                    catch (Throwable ex) {
                        logger.error(ex.getMessage(), ex);
                    }
                    finally {
                        List rows;
                        if (needQuery && (rows = this.executeQuery(ms, parameter, rowBounds, resultHandler, executor, boundSql, cacheKey)) != null) {
                            items.addAll(rows);
                        }
                    }
                    request.setPageNo(requestPageNo);
                    result.setPageNo(request.getPageNo());
                    rs = items;
                    executorInvocation.setResult(rs);
                    break block42;
                }
                Pipelines.skipHandler((HandlerContext)ctx, (boolean)true);
                rs = executorInvocation.getResult();
                if (rs == null) {
                    rs = Collects.emptyArrayList();
                }
                executorInvocation.setResult(rs);
            }
            catch (Throwable ex2) {
                logger.error(ex2.getMessage(), ex2);
                throw Throwables.wrapAsRuntimeException((Throwable)ex2);
            }
            finally {
                boolean isPageHelperRequest = this.isPageHelperRequest(ms);
                this.invalidatePagingRequest(false);
                if (isPageHelperRequest && this.paginationConfig.isPageHelperCompatible()) {
                    try {
                        Pipelines.inbound((HandlerContext)ctx);
                    }
                    catch (Throwable ex) {
                        throw Throwables.wrapAsRuntimeException((Throwable)ex);
                    }
                }
                SQLStatementInstrumentor instrumentor = SqlHelperMybatisPlugin.getInstrumentor();
                instrumentor.finish();
            }
        }
    }

    private void setPagingRequestBasedRowBounds(RowBounds rowBounds) {
        if (MybatisUtils.isPagingRowBounds(rowBounds)) {
            PagingRequest request = new PagingRequest();
            request.setPageSize(rowBounds.getLimit());
            request.setPageNo(rowBounds.getOffset() / rowBounds.getLimit() + rowBounds.getOffset() % rowBounds.getLimit() == 0 ? 0 : 1);
            PagingRequestContextHolder.getContext().setPagingRequest(request);
        }
    }

    private void invalidatePagingRequest(boolean force) {
        PagingRequest request = PAGING_CONTEXT.getPagingRequest();
        if (request != null) {
            request.clear(force);
        }
        PAGING_CONTEXT.remove();
    }

    private boolean isPagingRequest(MappedStatement statement) {
        return MybatisUtils.isPreparedStatement(statement) && PAGING_CONTEXT.isPagingRequest();
    }

    private boolean isPageHelperRequest(MappedStatement statement) {
        if (!this.isPagingRequest(statement)) {
            return false;
        }
        return PAGING_CONTEXT.get().getBoolean((Object)"pagehelper", Boolean.valueOf(false));
    }

    private boolean beginIfSupportsLimit(MappedStatement statement, ExecutorInvocation executorInvocation) {
        if (!PAGING_CONTEXT.getPagingRequest().isValidRequest()) {
            this.invalidatePagingRequest(false);
            return false;
        }
        if (PAGING_CONTEXT.get().getString((Object)"querySqlId") != null) {
            if (NestedStatements.isNestedStatement(statement)) {
                return false;
            }
        } else {
            PAGING_CONTEXT.get().setString((Object)"querySqlId", statement.getId());
        }
        SQLStatementInstrumentor instrumentor = SqlHelperMybatisPlugin.getInstrumentor();
        String databaseId = MybatisUtils.getDatabaseId((SqlRequestContextHolder)PAGING_CONTEXT, instrumentor, statement, executorInvocation.getExecutor(), this.extractDialectUseNativeEnabled);
        return instrumentor.beginIfSupportsLimit(databaseId);
    }

    private List executeQuery(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, Executor executor, BoundSql boundSql, CacheKey cacheKey) throws SQLException {
        String pageSql;
        PagingRequest request = PAGING_CONTEXT.getPagingRequest();
        RowSelection rowSelection = this.rowSelectionBuilder.build(request);
        PAGING_CONTEXT.setRowSelection(rowSelection);
        boolean subQueryPagination = false;
        SQLStatementInstrumentor instrumentor = SqlHelperMybatisPlugin.getInstrumentor();
        if (SqlPaginations.isSubqueryPagingRequest((PagingRequest)request)) {
            if (!SqlPaginations.isValidSubQueryPagination((PagingRequest)request, (SQLStatementInstrumentor)instrumentor)) {
                logger.warn("Paging request is not a valid subquery pagination request, so the paging request will not as a subquery pagination request. request: {}, the instrument configuration is: {}", (Object)request, (Object)instrumentor.getConfig());
            } else {
                subQueryPagination = true;
            }
        }
        if (!subQueryPagination) {
            pageSql = PAGING_CONTEXT.isOrderByRequest() ? instrumentor.instrumentOrderByLimitSql(boundSql.getSql(), PAGING_CONTEXT.getPagingRequest().getOrderBy(), rowSelection) : instrumentor.instrumentLimitSql(boundSql.getSql(), rowSelection);
            PagingRequestContext ctx = PAGING_CONTEXT.get();
            ctx.setInteger((Object)"BEFORE_SUBQUERY_PARAMETERS_COUNT", 0);
            ctx.setInteger((Object)"AFTER_SUBQUERY_PARAMETERS_COUNT", 0);
        } else {
            String startFlag = SqlPaginations.getSubqueryPaginationStartFlag((PagingRequest)request, (SQLStatementInstrumentor)instrumentor);
            String endFlag = SqlPaginations.getSubqueryPaginationEndFlag((PagingRequest)request, (SQLStatementInstrumentor)instrumentor);
            String subqueryPartition = SqlPaginations.extractSubqueryPartition((String)boundSql.getSql(), (String)startFlag, (String)endFlag);
            String limitedSubqueryPartition = instrumentor.instrumentLimitSql(subqueryPartition, rowSelection);
            String beforeSubqueryPartition = SqlPaginations.extractBeforeSubqueryPartition((String)boundSql.getSql(), (String)startFlag);
            String afterSubqueryPartition = SqlPaginations.extractAfterSubqueryPartition((String)boundSql.getSql(), (String)endFlag);
            pageSql = beforeSubqueryPartition + " " + limitedSubqueryPartition + " " + afterSubqueryPartition;
            if (PAGING_CONTEXT.isOrderByRequest()) {
                pageSql = instrumentor.instrumentOrderBySql(pageSql, PAGING_CONTEXT.getPagingRequest().getOrderBy());
            }
            PagingRequestContext ctx = PAGING_CONTEXT.get();
            ctx.setInteger((Object)"BEFORE_SUBQUERY_PARAMETERS_COUNT", SqlPaginations.findPlaceholderParameterCount((String)beforeSubqueryPartition));
            ctx.setInteger((Object)"AFTER_SUBQUERY_PARAMETERS_COUNT", SqlPaginations.findPlaceholderParameterCount((String)afterSubqueryPartition));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n-------------after pagination ---------------:\n{}", (Object)pageSql);
        }
        BoundSql pageBoundSql = MybatisUtils.rebuildBoundSql(pageSql, ms.getConfiguration(), boundSql);
        cacheKey.update((Object)request.getPageNo());
        cacheKey.update((Object)request.getPageSize());
        return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, pageBoundSql);
    }

    private String getOrderById(MappedStatement ms, OrderBy orderBy) {
        String orderByString = orderBy.toString();
        StringBuilder builder = new StringBuilder(ms.getId() + "_");
        for (int i = 0; i < orderByString.length(); ++i) {
            char c = orderByString.charAt(i);
            if (!Chars.isNumber((char)c) && !Chars.isLowerCase((char)c) && !Chars.isUpperCase((char)c) && c != '_') continue;
            builder.append(c);
        }
        return builder.append(ORDER_BY_SUFFIX).toString();
    }

    private MappedStatement customOrderByStatement(MappedStatement ms, String orderByStatementId) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), orderByStatementId, ms.getSqlSource(), ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (Emptys.isNotEmpty((Object)ms.getKeyProperties())) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private Object executeOrderBy(OrderBy orderBy, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, Executor executor, BoundSql boundSql) throws Throwable {
        SQLStatementInstrumentor instrumentor = SqlHelperMybatisPlugin.getInstrumentor();
        String orderBySqlId = this.getOrderById(ms, orderBy);
        MappedStatement orderByStatement = this.customOrderByStatement(ms, orderBySqlId);
        CacheKey orderByCacheKey = executor.createCacheKey(orderByStatement, parameter, RowBounds.DEFAULT, boundSql);
        String orderBySql = instrumentor.instrumentOrderBySql(boundSql.getSql(), orderBy);
        if (logger.isDebugEnabled()) {
            logger.debug("\n-------------after pagination ---------------:\n{}", (Object)orderBySql);
        }
        BoundSql orderByBoundSql = MybatisUtils.rebuildBoundSql(orderBySql, orderByStatement.getConfiguration(), boundSql);
        return executor.query(orderByStatement, parameter, RowBounds.DEFAULT, resultHandler, orderByCacheKey, orderByBoundSql);
    }

    private int executeCount(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, Executor executor, BoundSql boundSql) throws Throwable {
        int count;
        PagingRequestContext requestContext = PAGING_CONTEXT.get();
        PagingRequest request = PAGING_CONTEXT.getPagingRequest();
        String countStatementId = this.getCountStatementId(request, ms.getId());
        BoundSql countBoundSql = null;
        try {
            MappedStatement countStatement = this.extractCountStatementFromConfiguration(ms.getConfiguration(), countStatementId);
            if (countStatement != null) {
                CacheKey countKey = executor.createCacheKey(countStatement, parameter, RowBounds.DEFAULT, boundSql);
                countKey.update((Object)request.getPageNo());
                countKey.update((Object)request.getPageSize());
                countBoundSql = countStatement.getBoundSql(parameter);
                requestContext.set("countSql", (Object)countBoundSql);
                List countResultList = executor.query(countStatement, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
                count = ((Number)countResultList.get(0)).intValue();
            } else {
                String querySql = boundSql.getSql();
                SQLStatementInstrumentor instrumentor = SqlHelperMybatisPlugin.getInstrumentor();
                String countSql = instrumentor.countSql(querySql, request.getCountColumn());
                countStatement = this.customCountStatement(ms, countStatementId, querySql, request);
                CacheKey countKey2 = executor.createCacheKey(countStatement, parameter, RowBounds.DEFAULT, boundSql);
                countKey2.update((Object)request.getPageNo());
                countKey2.update((Object)request.getPageSize());
                countBoundSql = MybatisUtils.rebuildBoundSql(countSql, countStatement.getConfiguration(), boundSql);
                requestContext.set("countSql", (Object)countBoundSql);
                List countResultList2 = executor.query(countStatement, parameter, RowBounds.DEFAULT, resultHandler, countKey2, countBoundSql);
                count = ((Number)countResultList2.get(0)).intValue();
            }
        }
        catch (Throwable ex) {
            if (countBoundSql != null) {
                logger.error("error occur when execute count sql [{}], error: {}", new Object[]{countBoundSql.getSql(), ex.getMessage(), ex});
            }
            throw ex;
        }
        finally {
            requestContext.set("countSql", null);
        }
        return count;
    }

    private boolean needCount(PagingRequest request) {
        if (request.needCount() == null) {
            return this.paginationConfig.isCount();
        }
        if (Boolean.TRUE.compareTo(request.needCount()) == 0) {
            return !SqlPaginations.isSubqueryPagingRequest((PagingRequest)request);
        }
        return false;
    }

    private String getCountStatementId(PagingRequest request, String currentSqlId) {
        String customCountSqlId = PAGING_CONTEXT.get().getString((Object)"countSqlId");
        if (!Strings.isBlank((String)customCountSqlId)) {
            return customCountSqlId;
        }
        return currentSqlId + this.countSuffix;
    }

    private MappedStatement extractCountStatementFromConfiguration(Configuration configuration, String countStatementId) {
        MappedStatement mappedStatement = null;
        try {
            mappedStatement = configuration.getMappedStatement(countStatementId, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mappedStatement;
    }

    private MappedStatement customCountStatement(MappedStatement ms, String countStatementId, String querySql, PagingRequest pagingRequest) {
        MappedStatement countStatement;
        MappedStatement mappedStatement = countStatement = this.paginationConfig.enableCountCache() ? (MappedStatement)this.countStatementCache.getIfPresent((Object)querySql) : null;
        if (countStatement == null) {
            MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), countStatementId, ms.getSqlSource(), ms.getSqlCommandType());
            builder.resource(ms.getResource());
            builder.fetchSize(ms.getFetchSize());
            builder.statementType(ms.getStatementType());
            builder.keyGenerator(ms.getKeyGenerator());
            if (Emptys.isNotEmpty((Object)ms.getKeyProperties())) {
                StringBuilder keyProperties = new StringBuilder();
                for (String keyProperty : ms.getKeyProperties()) {
                    keyProperties.append(keyProperty).append(",");
                }
                keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
                builder.keyProperty(keyProperties.toString());
            }
            builder.timeout(ms.getTimeout());
            builder.parameterMap(ms.getParameterMap());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), ms.getId(), Long.class, new ArrayList()).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
            builder.resultSetType(ms.getResultSetType());
            builder.cache(ms.getCache());
            builder.flushCacheRequired(ms.isFlushCacheRequired());
            boolean useCache = Objects.isNull((Object)pagingRequest.getCacheCount()) ? ms.isUseCache() : pagingRequest.getCacheCount().booleanValue();
            builder.useCache(useCache);
            countStatement = builder.build();
            if (this.paginationConfig.enableCountCache() && useCache) {
                this.countStatementCache.set((Object)querySql, (Object)countStatement);
            }
        }
        return countStatement;
    }
}

