/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.spring.datasource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.invocation.GenericMethodInvocation;
import com.jn.langx.invocation.MethodInvocation;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.DataSourceKeySelector;
import com.jn.sqlhelper.datasource.key.router.DataSourceKeyRouter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public class DynamicMapper<MAPPER>
implements InvocationHandler {
    @NonNull
    private Class<MAPPER> mapperInterface;
    @NonNull
    private Map<DataSourceKey, MAPPER> delegateMapperMap = Collects.emptyHashMap();
    @NonNull
    private DataSourceKeySelector selector;
    @Nullable
    private DataSourceKeyRouter router;

    public DynamicMapper(Class<MAPPER> mapperInterface, Map<DataSourceKey, MAPPER> delegateMapperMap, DataSourceKeySelector selector) {
        this.mapperInterface = mapperInterface;
        this.delegateMapperMap.putAll(delegateMapperMap);
        this.setSelector(selector);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        GenericMethodInvocation methodInvocation = new GenericMethodInvocation(proxy, proxy, method, args);
        Object mapper = this.getMapperDelegate((MethodInvocation)methodInvocation);
        try {
            Object object = method.invoke(mapper, args);
            return object;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            DataSourceKeySelector.removeCurrent();
        }
    }

    private Object getMapperDelegate(MethodInvocation methodInvocation) {
        NamedDataSource dataSource;
        DataSourceKey key = this.selector.getDataSourceKeyRegistry().get((Method)methodInvocation.getJoinPoint());
        if (key != null && (dataSource = this.selector.getDataSourceRegistry().get(key)) != null) {
            DataSourceKeySelector.setCurrent((DataSourceKey)key);
        }
        if ((key = DataSourceKeySelector.getCurrent()) == null && (key = this.selector.select(methodInvocation)) != null) {
            DataSourceKeySelector.setCurrent((DataSourceKey)key);
        }
        if (key == null) {
            throw new IllegalStateException(StringTemplates.formatWithPlaceholder((String)"Can't find a suitable jdbc datasource for method: {}", (Object[])new Object[]{Reflects.getMethodString((Method)((Method)methodInvocation.getJoinPoint()))}));
        }
        return this.delegateMapperMap.get(key);
    }

    public void setSelector(DataSourceKeySelector selector) {
        this.selector = selector;
    }
}

