/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.spring.datasource;

import com.jn.langx.util.collection.Collects;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.DataSourceKeySelector;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;

public class DynamicSqlSessionFactory
implements SqlSessionFactory {
    private ConcurrentHashMap<DataSourceKey, SqlSessionFactory> factoryMap = new ConcurrentHashMap();

    public void addSqlSessionFactory(DataSourceKey key, SqlSessionFactory sessionFactory) {
        this.factoryMap.putIfAbsent(key, sessionFactory);
    }

    public int size() {
        return this.factoryMap.size();
    }

    public SqlSession openSession() {
        return this.getDelegatingSqlSessionFactory().openSession();
    }

    public SqlSession openSession(boolean autoCommit) {
        return this.getDelegatingSqlSessionFactory().openSession(autoCommit);
    }

    public SqlSession openSession(Connection connection) {
        return this.getDelegatingSqlSessionFactory().openSession(connection);
    }

    public SqlSession openSession(TransactionIsolationLevel level) {
        return this.getDelegatingSqlSessionFactory().openSession(level);
    }

    public SqlSession openSession(ExecutorType execType) {
        return this.getDelegatingSqlSessionFactory().openSession(execType);
    }

    public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
        return this.getDelegatingSqlSessionFactory().openSession(execType, autoCommit);
    }

    public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        return this.getDelegatingSqlSessionFactory().openSession(execType, level);
    }

    public SqlSession openSession(ExecutorType execType, Connection connection) {
        return this.getDelegatingSqlSessionFactory().openSession(execType, connection);
    }

    public Configuration getConfiguration() {
        SqlSessionFactory delegate = this.getDelegatingSqlSessionFactory();
        if (delegate == null) {
            return ((SqlSessionFactory)Collects.findFirst(this.factoryMap.values())).getConfiguration();
        }
        return this.getDelegatingSqlSessionFactory().getConfiguration();
    }

    public Map<DataSourceKey, SqlSessionFactory> getDelegates() {
        return Collects.newHashMap(this.factoryMap);
    }

    private SqlSessionFactory getDelegatingSqlSessionFactory() {
        if (DataSourceKeySelector.getCurrent() != null) {
            return this.factoryMap.get(DataSourceKeySelector.getCurrent());
        }
        return null;
    }
}

