/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.spring.datasource;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.DataSourceKeySelector;
import com.jn.sqlhelper.mybatis.spring.datasource.DynamicMapper;
import com.jn.sqlhelper.mybatis.spring.datasource.DynamicSqlSessionFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class DynamicSqlSessionTemplate
extends SqlSessionTemplate {
    private DataSourceKeySelector selector;

    public DynamicSqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        this(sqlSessionFactory, null);
    }

    public DynamicSqlSessionTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        super(sqlSessionFactory, ExecutorType.SIMPLE, null);
    }

    public void setSelector(DataSourceKeySelector selector) {
        this.selector = selector;
    }

    private DynamicSqlSessionFactory getDynamicSqlSessionFactory() {
        return (DynamicSqlSessionFactory)this.getSqlSessionFactory();
    }

    public <T> T getMapper(final Class<T> mapperInterface) {
        DynamicSqlSessionFactory sessionFactory = this.getDynamicSqlSessionFactory();
        final HashMap delegateMapperMap = Collects.emptyHashMap();
        Collects.forEach(sessionFactory.getDelegates(), (Consumer2)new Consumer2<DataSourceKey, SqlSessionFactory>(){

            public void accept(DataSourceKey key, SqlSessionFactory delegateFactory) {
                Object mybatisMapperProxy = delegateFactory.getConfiguration().getMapper(mapperInterface, (SqlSession)DynamicSqlSessionTemplate.this);
                delegateMapperMap.put(key, mybatisMapperProxy);
            }
        });
        DynamicMapper<T> mapper = new DynamicMapper<T>(mapperInterface, delegateMapperMap, this.selector);
        return (T)Proxy.newProxyInstance(mapperInterface.getClassLoader(), new Class[]{mapperInterface}, mapper);
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return super.getSqlSessionFactory();
    }

    public SqlSessionFactory getLocalSqlSessionFactory() {
        DynamicSqlSessionFactory sessionFactory = this.getDynamicSqlSessionFactory();
        if (sessionFactory.size() == 1) {
            return sessionFactory;
        }
        return this.getSqlSessionFactory();
    }

    public Configuration getConfiguration() {
        DynamicSqlSessionFactory sessionFactory = this.getDynamicSqlSessionFactory();
        if (sessionFactory.size() == 1) {
            return sessionFactory.getConfiguration();
        }
        return this.getLocalSqlSessionFactory().getConfiguration();
    }

    private class MultiDataSourceSqlSessionInterceptor
    implements InvocationHandler {
        private MultiDataSourceSqlSessionInterceptor() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            SqlSession sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)DynamicSqlSessionTemplate.this.getSqlSessionFactory(), (ExecutorType)DynamicSqlSessionTemplate.this.getExecutorType(), (PersistenceExceptionTranslator)DynamicSqlSessionTemplate.this.getPersistenceExceptionTranslator());
            try {
                Object result = method.invoke((Object)sqlSession, args);
                if (!SqlSessionUtils.isSqlSessionTransactional((SqlSession)sqlSession, (SqlSessionFactory)DynamicSqlSessionTemplate.this.getSqlSessionFactory())) {
                    sqlSession.commit(true);
                }
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
                if (DynamicSqlSessionTemplate.this.getPersistenceExceptionTranslator() != null && unwrapped instanceof PersistenceException) {
                    SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)DynamicSqlSessionTemplate.this.getSqlSessionFactory());
                    sqlSession = null;
                    DataAccessException translated = DynamicSqlSessionTemplate.this.getPersistenceExceptionTranslator().translateExceptionIfPossible((RuntimeException)((PersistenceException)unwrapped));
                    if (translated != null) {
                        unwrapped = translated;
                    }
                }
                throw unwrapped;
            }
            finally {
                if (sqlSession != null) {
                    SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)DynamicSqlSessionTemplate.this.getSqlSessionFactory());
                }
            }
        }
    }
}

