/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.springboot.autoconfigure;

import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.dialect.instrument.SQLInstrumentorConfig;
import com.jn.sqlhelper.mybatis.SqlHelperMybatisProperties;
import com.jn.sqlhelper.mybatis.plugins.SqlHelperMybatisPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SqlHelperMybatisPluginAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SqlHelperMybatisPluginAutoConfiguration.class);

    @Bean
    @ConfigurationProperties(prefix="sqlhelper.mybatis")
    public SqlHelperMybatisProperties sqlHelperMybatisProperties() {
        SqlHelperMybatisProperties p = new SqlHelperMybatisProperties();
        SQLInstrumentorConfig config = p.getInstrumentor();
        config.setName("mybatis");
        return p;
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlHelperMybatisPlugin sqlHelperMybatisPlugin(SqlHelperMybatisProperties sqlHelperMybatisProperties) {
        SqlHelperMybatisPlugin plugin = new SqlHelperMybatisPlugin();
        plugin.setPaginationConfig(sqlHelperMybatisProperties.getPagination());
        plugin.setInstrumentorConfig(sqlHelperMybatisProperties.getInstrumentor());
        plugin.init();
        logger.info("===[SQLHelper]=== The properties of the mybatis plugin [{}] is: {}", (Object)Reflects.getFQNClassName(SqlHelperMybatisPlugin.class), (Object)sqlHelperMybatisProperties);
        return plugin;
    }
}

