/*
 * Decompiled with CFR 0.152.
 */
package javapns.communication;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javapns.communication.AppleServer;
import javapns.communication.WrappedKeystore;
import javapns.communication.exceptions.InvalidKeystoreFormatException;
import javapns.communication.exceptions.InvalidKeystorePasswordException;
import javapns.communication.exceptions.InvalidKeystoreReferenceException;
import javapns.communication.exceptions.KeystoreException;

public class KeystoreManager {
    private static final String REVIEW_MESSAGE = " Please review the procedure for generating a keystore for JavaPNS.";

    static KeyStore loadKeystore(AppleServer server) throws KeystoreException {
        return KeystoreManager.loadKeystore(server, server.getKeystoreStream());
    }

    static KeyStore loadKeystore(AppleServer server, Object keystore) throws KeystoreException {
        return KeystoreManager.loadKeystore(server, keystore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(AppleServer server, Object keystore, boolean verifyKeystore) throws KeystoreException {
        if (keystore instanceof KeyStore) {
            return (KeyStore)keystore;
        }
        AppleServer appleServer = server;
        synchronized (appleServer) {
            KeyStore keyStore;
            InputStream keystoreStream = KeystoreManager.streamKeystore(keystore);
            if (keystoreStream instanceof WrappedKeystore) {
                return ((WrappedKeystore)keystoreStream).getKeystore();
            }
            try {
                keyStore = KeyStore.getInstance(server.getKeystoreType());
                char[] password = KeystoreManager.getKeystorePasswordForSSL(server);
                keyStore.load(keystoreStream, password);
            }
            catch (Exception e) {
                throw KeystoreManager.wrapKeystoreException(e);
            }
            finally {
                try {
                    keystoreStream.close();
                }
                catch (Exception e) {}
            }
            return keyStore;
        }
    }

    static Object ensureReusableKeystore(AppleServer server, Object keystore) throws KeystoreException {
        if (keystore instanceof InputStream) {
            keystore = KeystoreManager.loadKeystore(server, keystore, false);
        }
        return keystore;
    }

    public static void verifyKeystoreContent(AppleServer server, Object keystore) throws KeystoreException {
        KeyStore keystoreToValidate = null;
        keystoreToValidate = keystore instanceof KeyStore ? (KeyStore)keystore : KeystoreManager.loadKeystore(server, keystore);
        KeystoreManager.verifyKeystoreContent(keystoreToValidate);
    }

    public static void verifyKeystoreContent(KeyStore keystore) throws KeystoreException {
        try {
            int numberOfCertificates = 0;
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keystore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate xcert = (X509Certificate)certificate;
                ++numberOfCertificates;
                xcert.checkValidity();
                boolean issuerIsApple = ((Object)xcert.getIssuerDN()).toString().contains("Apple");
                if (!issuerIsApple) {
                    throw new KeystoreException("Certificate was not issued by Apple. Please review the procedure for generating a keystore for JavaPNS.");
                }
                boolean[] keyUsage = xcert.getKeyUsage();
                if (keyUsage[0]) continue;
                throw new KeystoreException("Certificate usage is incorrect. Please review the procedure for generating a keystore for JavaPNS.");
            }
            if (numberOfCertificates == 0) {
                throw new KeystoreException("Keystore does not contain any valid certificate. Please review the procedure for generating a keystore for JavaPNS.");
            }
            if (numberOfCertificates > 1) {
                throw new KeystoreException("Keystore contains too many certificates. Please review the procedure for generating a keystore for JavaPNS.");
            }
        }
        catch (KeystoreException e) {
            throw e;
        }
        catch (CertificateExpiredException e) {
            throw new KeystoreException("Certificate is expired. A new one must be issued.", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new KeystoreException("Certificate is not yet valid. Wait until the validity period is reached or issue a new certificate.", e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static char[] getKeystorePasswordForSSL(AppleServer server) {
        String password = server.getKeystorePassword();
        if (password == null) {
            password = "";
        }
        char[] passchars = password != null ? password.toCharArray() : null;
        return passchars;
    }

    static KeystoreException wrapKeystoreException(Exception e) {
        if (e != null) {
            String msg = e.toString();
            if (msg.contains("javax.crypto.BadPaddingException")) {
                return new InvalidKeystorePasswordException();
            }
            if (msg.contains("DerInputStream.getLength(): lengthTag=127, too big")) {
                return new InvalidKeystoreFormatException();
            }
            if (msg.contains("java.lang.ArithmeticException: / by zero") || msg.contains("java.security.UnrecoverableKeyException: Get Key failed: / by zero")) {
                return new InvalidKeystorePasswordException("Blank passwords not supported (#38).  You must create your keystore with a non-empty password.");
            }
        }
        return new KeystoreException("Keystore exception: " + e.getMessage(), e);
    }

    static InputStream streamKeystore(Object keystore) throws InvalidKeystoreReferenceException {
        KeystoreManager.validateKeystoreParameter(keystore);
        try {
            if (keystore instanceof InputStream) {
                return (InputStream)keystore;
            }
            if (keystore instanceof KeyStore) {
                return new WrappedKeystore((KeyStore)keystore);
            }
            if (keystore instanceof File) {
                return new BufferedInputStream(new FileInputStream((File)keystore));
            }
            if (keystore instanceof String) {
                return new BufferedInputStream(new FileInputStream((String)keystore));
            }
            if (keystore instanceof byte[]) {
                return new ByteArrayInputStream((byte[])keystore);
            }
            return null;
        }
        catch (Exception e) {
            throw new InvalidKeystoreReferenceException("Invalid keystore reference: " + e.getMessage());
        }
    }

    public static void validateKeystoreParameter(Object keystore) throws InvalidKeystoreReferenceException {
        if (keystore == null) {
            throw new InvalidKeystoreReferenceException((Object)null);
        }
        if (keystore instanceof KeyStore) {
            return;
        }
        if (keystore instanceof InputStream) {
            return;
        }
        if (keystore instanceof String) {
            keystore = new File((String)keystore);
        }
        if (keystore instanceof File) {
            File file = (File)keystore;
            if (!file.exists()) {
                throw new InvalidKeystoreReferenceException("Invalid keystore reference.  File does not exist: " + file.getAbsolutePath());
            }
            if (!file.isFile()) {
                throw new InvalidKeystoreReferenceException("Invalid keystore reference.  Path does not refer to a valid file: " + file.getAbsolutePath());
            }
            if (file.length() <= 0L) {
                throw new InvalidKeystoreReferenceException("Invalid keystore reference.  File is empty: " + file.getAbsolutePath());
            }
            return;
        }
        if (keystore instanceof byte[]) {
            byte[] bytes = (byte[])keystore;
            if (bytes.length == 0) {
                throw new InvalidKeystoreReferenceException("Invalid keystore reference. Byte array is empty");
            }
            return;
        }
        throw new InvalidKeystoreReferenceException(keystore);
    }
}

