/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven.plugins.core;

import com.github.maven.plugins.core.RepositoryUtils;
import com.github.maven.plugins.core.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;

public abstract class GitHubProjectMojo
extends AbstractMojo {
    public static String getExceptionMessage(IOException e) {
        return e.getMessage();
    }

    protected boolean isDebug() {
        Log log = this.getLog();
        return log != null ? log.isDebugEnabled() : false;
    }

    protected boolean isInfo() {
        Log log = this.getLog();
        return log != null ? log.isInfoEnabled() : false;
    }

    protected void debug(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message);
        }
    }

    protected void debug(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message, throwable);
        }
    }

    protected void info(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message);
        }
    }

    protected void info(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message, throwable);
        }
    }

    protected GitHubClient createClient(String host, String userName, String password, String oauth2Token, String serverId, Settings settings) throws MojoExecutionException {
        GitHubClient client;
        if (!StringUtils.isEmpty(host)) {
            if (this.isDebug()) {
                this.debug("Using custom host: " + host);
            }
            client = this.createClient(host);
        } else {
            client = this.createClient();
        }
        if (this.configureUsernamePassword(client, userName, password) || this.configureOAuth2Token(client, oauth2Token) || this.configureServerCredentials(client, serverId, settings)) {
            return client;
        }
        throw new MojoExecutionException("No authentication credentials configured");
    }

    protected GitHubClient createClient(String hostname) {
        return new GitHubClient(hostname);
    }

    protected GitHubClient createClient() {
        return new GitHubClient();
    }

    protected boolean configureUsernamePassword(GitHubClient client, String userName, String password) {
        if (StringUtils.isEmpty(userName, password)) {
            return false;
        }
        if (this.isDebug()) {
            this.debug("Using basic authentication with username: " + userName);
        }
        client.setCredentials(userName, password);
        return true;
    }

    protected boolean configureOAuth2Token(GitHubClient client, String oauth2Token) {
        if (StringUtils.isEmpty(oauth2Token)) {
            return false;
        }
        if (this.isDebug()) {
            this.debug("Using OAuth2 access token authentication");
        }
        client.setOAuth2Token(oauth2Token);
        return true;
    }

    protected boolean configureServerCredentials(GitHubClient client, String serverId, Settings settings) throws MojoExecutionException {
        if (StringUtils.isEmpty(serverId)) {
            return false;
        }
        Server server = this.getServer(settings, serverId);
        if (server == null) {
            throw new MojoExecutionException(MessageFormat.format("Server ''{0}'' not found in settings", serverId));
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Using ''{0}'' server credentials", serverId));
        }
        String serverUsername = server.getUsername();
        String serverPassword = server.getPassword();
        if (!StringUtils.isEmpty(serverUsername, serverPassword)) {
            if (this.isDebug()) {
                this.debug("Using basic authentication with username: " + serverUsername);
            }
            client.setCredentials(serverUsername, serverPassword);
            return true;
        }
        if (!StringUtils.isEmpty(serverPassword)) {
            if (this.isDebug()) {
                this.debug("Using OAuth2 access token authentication");
            }
            client.setOAuth2Token(serverPassword);
            return true;
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Server ''{0}'' is missing username/password credentials", serverId));
        }
        return false;
    }

    protected RepositoryId getRepository(MavenProject project, String owner, String name) throws MojoExecutionException {
        RepositoryId repository = RepositoryUtils.getRepository(project, owner, name);
        if (repository == null) {
            throw new MojoExecutionException("No GitHub repository (owner and name) configured");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Using GitHub repository {0}", repository.generateId()));
        }
        return repository;
    }

    protected Server getServer(Settings settings, String serverId) {
        if (settings == null) {
            return null;
        }
        List servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        for (Server server : servers) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }
}

