/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven.plugins.core;

import com.github.maven.plugins.core.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.eclipse.egit.github.core.RepositoryId;

public class RepositoryUtils {
    public static RepositoryId extractRepositoryFromScmUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        int ghIndex = url.indexOf("github.com");
        if (ghIndex == -1 || ghIndex + 1 >= url.length()) {
            return null;
        }
        if (!url.endsWith(".git")) {
            return null;
        }
        url = url.substring(ghIndex + "github.com".length() + 1, url.length() - ".git".length());
        return RepositoryId.createFromId((String)url);
    }

    public static RepositoryId getRepository(MavenProject project, String owner, String name) {
        if (!StringUtils.isEmpty(owner, name)) {
            return RepositoryId.create((String)owner, (String)name);
        }
        if (project == null) {
            return null;
        }
        RepositoryId repo = null;
        Scm scm = project.getScm();
        if (scm != null) {
            if (!StringUtils.isEmpty(scm.getUrl())) {
                repo = RepositoryId.createFromUrl((String)scm.getUrl());
            }
            if (repo == null) {
                repo = RepositoryUtils.extractRepositoryFromScmUrl(scm.getConnection());
            }
            if (repo == null) {
                repo = RepositoryUtils.extractRepositoryFromScmUrl(scm.getDeveloperConnection());
            }
        }
        if (repo == null && !StringUtils.isEmpty(project.getUrl())) {
            repo = RepositoryId.createFromUrl((String)project.getUrl());
        }
        if (repo != null) {
            return repo;
        }
        return repo;
    }
}

