/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven.plugins.site;

import com.github.maven.plugins.core.GitHubProjectMojo;
import com.github.maven.plugins.core.PathUtils;
import com.github.maven.plugins.core.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.util.EncodingUtils;

public class SiteMojo
extends GitHubProjectMojo {
    public static final String BRANCH_DEFAULT = "refs/heads/gh-pages";
    public static final String NO_JEKYLL_FILE = ".nojekyll";
    private String branch = "refs/heads/gh-pages";
    private String path;
    private String message;
    private String repositoryName;
    private String repositoryOwner;
    private String userName;
    private String password;
    private String oauth2Token;
    private String host;
    private String server;
    private String[] includes;
    private String[] excludes;
    private File outputDirectory;
    private MavenProject project;
    private Settings settings;
    private boolean force;
    private boolean noJekyll;
    private boolean merge;
    private boolean dryRun;

    protected String createBlob(DataService service, RepositoryId repository, String path) throws MojoExecutionException {
        File file = new File(this.outputDirectory, path);
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        FileInputStream stream = null;
        try {
            int read;
            stream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file: " + SiteMojo.getExceptionMessage((IOException)e), (Exception)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.debug("Exception closing stream", e);
                }
            }
        }
        Blob blob = new Blob().setEncoding("base64");
        String encoded = EncodingUtils.toBase64((byte[])output.toByteArray());
        blob.setContent(encoded);
        try {
            if (this.isDebug()) {
                this.debug(MessageFormat.format("Creating blob from {0}", file.getAbsolutePath()));
            }
            if (!this.dryRun) {
                return service.createBlob((IRepositoryIdProvider)repository, blob);
            }
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating blob: " + SiteMojo.getExceptionMessage((IOException)e), (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        Commit created;
        void var10_20;
        File noJekyllFile;
        RepositoryId repository = this.getRepository(this.project, this.repositoryOwner, this.repositoryName);
        if (this.dryRun) {
            this.info("Dry run mode, repository will not be modified");
        }
        if (this.noJekyll && !(noJekyllFile = new File(this.outputDirectory, NO_JEKYLL_FILE)).exists()) {
            try {
                if (this.isDebug()) {
                    this.debug(MessageFormat.format("Creating '.nojekyll file in {0}", this.outputDirectory.getAbsolutePath()));
                }
                if (!noJekyllFile.createNewFile()) {
                    throw new MojoExecutionException(MessageFormat.format("Unable to create .nojekyll file in {0}", this.outputDirectory.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(MessageFormat.format("Unable to create .nojekyll file in {0}", this.outputDirectory.getAbsolutePath()), (Exception)e);
            }
        }
        String baseDir = this.outputDirectory.getAbsolutePath();
        Object[] includePaths = StringUtils.removeEmpties((String[])this.includes);
        Object[] excludePaths = StringUtils.removeEmpties((String[])this.excludes);
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanning {0} and including {1} and exluding {2}", baseDir, Arrays.toString(includePaths), Arrays.toString(excludePaths)));
        }
        Object[] paths = PathUtils.getMatchingPaths((String[])includePaths, (String[])excludePaths, (String)baseDir);
        if (this.noJekyll) {
            boolean containsNoJekyll = false;
            for (String string : paths) {
                if (!NO_JEKYLL_FILE.equals(string)) continue;
                containsNoJekyll = true;
                break;
            }
            if (!containsNoJekyll) {
                String[] extendedPaths = new String[paths.length + 1];
                System.arraycopy(paths, 0, extendedPaths, 1, paths.length);
                extendedPaths[0] = NO_JEKYLL_FILE;
                paths = extendedPaths;
            }
        }
        if (paths.length != 1) {
            this.info(MessageFormat.format("Creating {0} blobs", paths.length));
        } else {
            this.info("Creating 1 blob");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanned files to include: {0}", Arrays.toString(paths)));
        }
        DataService service = new DataService(this.createClient(this.host, this.userName, this.password, this.oauth2Token, this.server, this.settings));
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>(paths.length);
        String prefix = this.path;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if ('\\' == File.separatorChar) {
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = ((String)paths[i]).replace('\\', '/');
            }
        }
        for (Object path : paths) {
            TreeEntry entry = new TreeEntry();
            entry.setPath(prefix + (String)path);
            entry.setType("blob");
            entry.setMode("100644");
            entry.setSha(this.createBlob(service, repository, (String)path));
            entries.add(entry);
        }
        Reference ref = null;
        try {
            ref = service.getReference((IRepositoryIdProvider)repository, this.branch);
        }
        catch (RequestException requestException) {
            if (404 != requestException.getStatus()) {
                throw new MojoExecutionException("Error getting reference: " + SiteMojo.getExceptionMessage((IOException)((Object)requestException)), (Exception)((Object)requestException));
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Error getting reference: " + SiteMojo.getExceptionMessage((IOException)iOException), (Exception)iOException);
        }
        if (ref != null && !"commit".equals(ref.getObject().getType())) {
            throw new MojoExecutionException(MessageFormat.format("Existing ref {0} points to a {1} ({2}) instead of a commmit", ref.getRef(), ref.getObject().getType(), ref.getObject().getSha()));
        }
        try {
            int size = entries.size();
            if (size != 1) {
                this.info(MessageFormat.format("Creating tree with {0} blob entries", size));
            } else {
                this.info("Creating tree with 1 blob entry");
            }
            String baseTree = null;
            if (this.merge && ref != null) {
                Tree currentTree = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                this.info(MessageFormat.format("Merging with tree {0}", baseTree));
            }
            if (!this.dryRun) {
                Tree tree = service.createTree((IRepositoryIdProvider)repository, entries, baseTree);
            } else {
                Tree tree = new Tree();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating tree: " + SiteMojo.getExceptionMessage((IOException)e), (Exception)e);
        }
        Commit commit = new Commit();
        commit.setMessage(this.message);
        commit.setTree((Tree)var10_20);
        if (ref != null) {
            commit.setParents(Collections.singletonList(new Commit().setSha(ref.getObject().getSha())));
        }
        try {
            created = !this.dryRun ? service.createCommit((IRepositoryIdProvider)repository, commit) : new Commit();
            this.info(MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating commit: " + SiteMojo.getExceptionMessage((IOException)e), (Exception)e);
        }
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        if (ref != null) {
            ref.setObject(object);
            try {
                this.info(MessageFormat.format("Updating reference {0} from {1} to {2}", this.branch, ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                if (this.dryRun) return;
                service.editReference((IRepositoryIdProvider)repository, ref, this.force);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error editing reference: " + SiteMojo.getExceptionMessage((IOException)e), (Exception)e);
            }
        }
        ref = new Reference().setObject(object).setRef(this.branch);
        try {
            this.info(MessageFormat.format("Creating reference {0} starting at commit {1}", this.branch, created.getSha()));
            if (this.dryRun) return;
            service.createReference((IRepositoryIdProvider)repository, ref);
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating reference: " + SiteMojo.getExceptionMessage((IOException)e), (Exception)e);
        }
    }
}

