/*
 *  Copyright 2012 GWT-Bootstrap
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.github.gwtbootstrap.client.ui.constants;

//@formatter:off

/**
 * Type of the <a href="http://glyphicons.com/">Glyphicon</a>
 * and <a href="http://fortawesome.github.com/Font-Awesome/">Font Awesome</a>.
 *
 * @author Carlos Alexandro Becker
 * @author Dominik Mayer
 * @see <a href="http://twitter.github.com/bootstrap/base-css.html#icons">Bootstrap documentation</a>
 * @see <a href="http://fortawesome.github.com/Font-Awesome/">Font Awesome docs</a>
 * @since 2.0.4.0
 */
//@formatter:on
public enum IconType implements BaseIconType {

    // font awesome icons
    ADJUST("adjust"),
    ALIGN_CENTER("align-center"),
    ALIGN_JUSTIFY("align-justify"),
    ALIGN_LEFT("align-left"),
    ALIGN_RIGHT("align-right"),
    AMBULANCE("ambulance"),
    ANGLE_DOWN("angle-down"),
    ANGLE_LEFT("angle-left"),
    ANGLE_RIGHT("angle-right"),
    ANGLE_UP("angle-up"),
    ARROW_DOWN("arrow-down"),
    ARROW_LEFT("arrow-left"),
    ARROW_RIGHT("arrow-right"),
    ARROW_UP("arrow-up"),
    ASTERISK("asterisk"),
    BACKWARD("backward"),
    BAN_CIRCLE("ban-circle"),
    BAR_CHART("bar-chart"),
    BARCODE("barcode"),
    BEAKER("beaker"),
    BEER("beer"),
    BELL("bell"),
    BELL_ALT("bell-alt"),
    BOLD("bold"),
    BOLT("bolt"),
    BOOK("book"),
    BOOKMARK("bookmark"),
    BOOKMARK_EMPTY("bookmark-empty"),
    BRIEFCASE("briefcase"),
    BUILDING("building"),
    BULLHORN("bullhorn"),
    CALENDAR("calendar"),
    CAMERA("camera"),
    CAMERA_RETRO("camera-retro"),
    CARET_DOWN("caret-down"),
    CARET_LEFT("caret-left"),
    CARET_RIGHT("caret-right"),
    CARET_UP("caret-up"),
    CERTIFICATE("certificate"),
    CHECK("check"),
    CHECK_EMPTY("check-empty"),
    CHEVRON_DOWN("chevron-down"),
    CHEVRON_LEFT("chevron-left"),
    CHEVRON_RIGHT("chevron-right"),
    CHEVRON_UP("chevron-up"),
    CIRCLE_ARROW_DOWN("circle-arrow-down"),
    CIRCLE_ARROW_LEFT("circle-arrow-left"),
    CIRCLE_ARROW_RIGHT("circle-arrow-right"),
    CIRCLE_ARROW_UP("circle-arrow-up"),
    CIRCLE("circle"),
    CIRCLE_BLANK("circle-blank"),
    CLOUD("cloud"),
    CLOUD_DOWNLOAD("cloud-download"),
    CLOUD_UPLOAD("cloud-upload"),
    COFFEE("coffee"),
    COG("cog"),
    COGS("cogs"),
    COLUMNS("columns"),
    COMMENT("comment"),
    COMMENT_ALT("comment-alt"),
    COMMENTS("comments"),
    COMMENTS_ALT("comments-alt"),
    COPY("copy"),
    CREDIT_CARD("credit-card"),
    CUT("cut"),
    DASHBOARD("dashboard"),
    DESKTOP("desktop"),
    DOUBLE_ANGLE_DOWN("double-angle-down"),
    DOUBLE_ANGLE_LEFT("double-angle-left"),
    DOUBLE_ANGLE_RIGHT("double-angle-right"),
    DOUBLE_ANGLE_UP("double-angle-up"),
    DOWNLOAD("download"),
    DOWNLOAD_ALT("download-alt"),
    EDIT("edit"),
    EJECT("eject"),
    ENVELOPE("envelope"),
    ENVELOPE_ALT("envelope-alt"),
    EXCHANGE("exchange"),
    EXCLAMATION_SIGN("exclamation-sign"),
    EXTERNAL_LINK("external-link"),
    EYE_CLOSE("eye-close"),
    EYE_OPEN("eye-open"),
    FACEBOOK("facebook"),
    FACEBOOK_SIGN("facebook-sign"),
    FACETIME_VIDEO("facetime-video"),
    FAST_BACKWARD("fast-backward"),
    FAST_FORWARD("fast-forward"),
    FIGHTER_JET("fighter-jet"),
    FILE("file"),
    FILE_ALT("file-alt"),
    FILM("film"),
    FILTER("filter"),
    FIRE("fire"),
    FLAG("flag"),
    FOLDER_CLOSE("folder-close"),
    FOLDER_CLOSE_ALT("folder-close-alt"),
    FOLDER_OPEN("folder-open"),
    FOLDER_OPEN_ALT("folder-open-alt"),
    FONT("font"),
    FOOD("food"),
    FORWARD("forward"),
    FULLSCREEN("fullscreen"),
    GIFT("gift"),
    GITHUB("github"),
    GITHUB_ALT("github-alt"),
    GITHUB_SIGN("github-sign"),
    GLASS("glass"),
    GLOBE("globe"),
    GOOGLE_PLUS("google-plus"),
    GOOGLE_PLUS_SIGN("google-plus-sign"),
    GROUP("group"),
    H_SIGN("h-sign"),
    HAND_DOWN("hand-down"),
    HAND_LEFT("hand-left"),
    HAND_RIGHT("hand-right"),
    HAND_UP("hand-up"),
    HDD("hdd"),
    HEADPHONES("headphones"),
    HEART("heart"),
    HEART_EMPTY("heart-empty"),
    HOME("home"),
    HOSPITAL("hospital"),
    INBOX("inbox"),
    INDENT_LEFT("indent-left"),
    INDENT_RIGHT("indent-right"),
    INFO_SIGN("info-sign"),
    ITALIC("italic"),
    KEY("key"),
    LAPTOP("laptop"),
    LEAF("leaf"),
    LEGAL("legal"),
    LEMON("lemon"),
    LIGHTBULB("lightbulb"),
    LINK("link"),
    LINKEDIN("linkedin"),
    LINKEDIN_SIGN("linkedin-sign"),
    LIST("list"),
    LIST_ALT("list-alt"),
    LIST_OL("list-ol"),
    LIST_UL("list-ul"),
    LOCK("lock"),
    MAGIC("magic"),
    MAGNET("magnet"),
    MAP_MARKER("map-marker"),
    MEDKIT("medkit"),
    MINUS("minus"),
    MINUS_SIGN("minus-sign"),
    MOBILE_PHONE("mobile-phone"),
    MONEY("money"),
    MOVE("move"),
    MUSIC("music"),
    OFF("off"),
    OK("ok"),
    OK_CIRCLE("ok-circle"),
    OK_SIGN("ok-sign"),
    PAPER_CLIP("paper-clip"),
    PASTE("paste"),
    PAUSE("pause"),
    PENCIL("pencil"),
    PHONE("phone"),
    PHONE_SIGN("phone-sign"),
    PICTURE("picture"),
    PINTEREST("pinterest"),
    PINTEREST_SIGN("pinterest-sign"),
    PLANE("plane"),
    PLAY("play"),
    PLAY_CIRCLE("play-circle"),
    PLUS("plus"),
    PLUS_SIGN("plus-sign"),
    PLUS_SIGN_ALT("plus-sign-alt"),
    PRINT("print"),
    PUSHPIN("pushpin"),
    QRCODE("qrcode"),
    QUESTION_SIGN("question-sign"),
    QUOTE_LEFT("quote-left"),
    QUOTE_RIGHT("quote-right"),
    RANDOM("random"),
    REFRESH("refresh"),
    REMOVE("remove"),
    REMOVE_CIRCLE("remove-circle"),
    REMOVE_SIGN("remove-sign"),
    REORDER("reorder"),
    REPEAT("repeat"),
    REPLY("reply"),
    RESIZE_FULL("resize-full"),
    RESIZE_HORIZONTAL("resize-horizontal"),
    RESIZE_SMALL("resize-small"),
    RESIZE_VERTICAL("resize-vertical"),
    RETWEET("retweet"),
    ROAD("road"),
    RSS("rss"),
    SAVE("save"),
    SCREENSHOT("screenshot"),
    SEARCH("search"),
    SHARE("share"),
    SHARE_ALT("share-alt"),
    SHOPPING_CART("shopping-cart"),
    SIGN_BLANK("sign-blank"),
    SIGNAL("signal"),
    SIGNIN("signin"),
    SIGNOUT("signout"),
    SITEMAP("sitemap"),
    SORT("sort"),
    SORT_DOWN("sort-down"),
    SORT_UP("sort-up"),
    SPINNER("spinner"),
    STAR("star"),
    STAR_EMPTY("star-empty"),
    STAR_HALF("star-half"),
    STEP_BACKWARD("step-backward"),
    STEP_FORWARD("step-forward"),
    STETHOSCOPE("stethoscope"),
    STOP("stop"),
    STRIKETHROUGH("strikethrough"),
    SUITCASE("suitcase"),
    TABLE("table"),
    TABLET("tablet"),
    TAG("tag"),
    TAGS("tags"),
    TASKS("tasks"),
    TEXT_HEIGHT("text-height"),
    TEXT_WIDTH("text-width"),
    TH("th"),
    TH_LARGE("th-large"),
    TH_LIST("th-list"),
    THUMBS_DOWN("thumbs-down"),
    THUMBS_UP("thumbs-up"),
    TIME("time"),
    TINT("tint"),
    TRASH("trash"),
    TROPHY("trophy"),
    TRUCK("truck"),
    TWITTER("twitter"),
    TWITTER_SIGN("twitter-sign"),
    UMBRELLA("umbrella"),
    UNDERLINE("underline"),
    UNDO("undo"),
    UNLOCK("unlock"),
    UPLOAD("upload"),
    UPLOAD_ALT("upload-alt"),
    USER("user"),
    USER_MD("user-md"),
    VOLUME_DOWN("volume-down"),
    VOLUME_OFF("volume-off"),
    VOLUME_UP("volume-up"),
    WARNING_SIGN("warning-sign"),
    WRENCH("wrench"),
    ZOOM_IN("zoom-in"),
    ZOOM_OUT("zoom-out"),

    // original icons from bootstrap, that not exist in font awesome page, but 'exists'
    BAR("bar");

    private static final String PREFIX = "icon-";

    private String className;

    private IconType(String className) {
        this.className = className;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String get() {
        return PREFIX + className;
    }
}
