/*
 * Decompiled with CFR 0.152.
 */
package com.github.inspektr.audit.support;

import com.github.inspektr.audit.AuditActionContext;
import com.github.inspektr.audit.AuditTrailManager;
import com.github.inspektr.audit.support.NoMatchWhereClauseMatchCriteria;
import com.github.inspektr.audit.support.WhereClauseMatchCriteria;
import com.github.inspektr.common.Cleanable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public final class JdbcAuditTrailManager
extends SimpleJdbcDaoSupport
implements AuditTrailManager,
Cleanable {
    private static final String INSERT_SQL_TEMPLATE = "INSERT INTO %s (AUD_USER, AUD_CLIENT_IP, AUD_SERVER_IP, AUD_RESOURCE, AUD_ACTION, APPLIC_CD, AUD_DATE) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_SQL_TEMPLATE = "DELETE FROM %s %s";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    @Size(min=1)
    private String tableName = "COM_AUDIT_TRAIL";
    @NotNull
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private WhereClauseMatchCriteria cleanupCriteria = new NoMatchWhereClauseMatchCriteria();

    public JdbcAuditTrailManager(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void record(AuditActionContext auditActionContext) {
        this.executorService.execute(new LoggingTask(auditActionContext, this.transactionTemplate));
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCleanupCriteria(WhereClauseMatchCriteria criteria) {
        this.cleanupCriteria = criteria;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void clean() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                String sql = String.format(JdbcAuditTrailManager.DELETE_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName, JdbcAuditTrailManager.this.cleanupCriteria);
                List<?> params = JdbcAuditTrailManager.this.cleanupCriteria.getParameterValues();
                JdbcAuditTrailManager.this.logger.info("Cleaning audit records with query " + sql);
                JdbcAuditTrailManager.this.logger.debug("Query parameters: " + params);
                int count = JdbcAuditTrailManager.this.getSimpleJdbcTemplate().update(sql, params.toArray());
                JdbcAuditTrailManager.this.logger.info(count + " records deleted.");
            }
        });
    }

    protected class LoggingTask
    implements Runnable {
        private final AuditActionContext auditActionContext;
        private final TransactionTemplate transactionTemplate;

        public LoggingTask(AuditActionContext auditActionContext, TransactionTemplate transactionTemplate) {
            this.auditActionContext = auditActionContext;
            this.transactionTemplate = transactionTemplate;
        }

        public void run() {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    String userId = LoggingTask.this.auditActionContext.getPrincipal().length() <= 100 ? LoggingTask.this.auditActionContext.getPrincipal() : LoggingTask.this.auditActionContext.getPrincipal().substring(0, 100);
                    String resource = LoggingTask.this.auditActionContext.getResourceOperatedUpon().length() <= 100 ? LoggingTask.this.auditActionContext.getResourceOperatedUpon() : LoggingTask.this.auditActionContext.getResourceOperatedUpon().substring(0, 100);
                    String action = LoggingTask.this.auditActionContext.getActionPerformed().length() <= 100 ? LoggingTask.this.auditActionContext.getActionPerformed() : LoggingTask.this.auditActionContext.getActionPerformed().substring(0, 100);
                    JdbcAuditTrailManager.this.getSimpleJdbcTemplate().update(String.format(JdbcAuditTrailManager.INSERT_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName), new Object[]{userId, LoggingTask.this.auditActionContext.getClientIpAddress(), LoggingTask.this.auditActionContext.getServerIpAddress(), resource, action, LoggingTask.this.auditActionContext.getApplicationCode(), LoggingTask.this.auditActionContext.getWhenActionWasPerformed()});
                }
            });
        }
    }
}

