/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorage {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorage.class);
    private static final Predicate<Path> VALID = path -> path.getFileName().toString().matches("^\\d+$");
    private Path root;

    public FileStorage(String root) {
        this.root = Paths.get(root, new String[0]);
        try {
            Files.createDirectories(this.root, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn("Path at {} is not writable. Merge may fail", (Object)root);
        }
    }

    public void touch(Long id) {
        Path path = this.root.resolve(id.toString());
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn("Path at {} is not writable. Merge may fail", (Object)this.root);
        }
    }

    public long count() {
        try {
            return Files.list(this.root).filter(VALID).count();
        }
        catch (IOException e) {
            LOG.warn("Path at {} is not readable. Merge may fail", (Object)this.root);
            return 0L;
        }
    }

    public Set<Long> loadAndClean() {
        HashSet<Long> ids = new HashSet<Long>();
        try {
            Files.list(this.root).filter(VALID).forEach(path -> {
                ids.add(Long.parseLong(path.getFileName().toString()));
                FileStorage.secureRemove(path);
            });
            Files.delete(this.root);
        }
        catch (IOException e) {
            LOG.warn("Path at {} is not writable. Merge mechanism may fail", (Object)this.root);
        }
        return ids;
    }

    private static void secureRemove(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            LOG.debug("Unable to remove file at {}", (Object)path);
        }
    }
}

