/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.github.invictum.reportportal.EnhancedLogEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LogStorage.class);
    private ThreadLocal<List<EnhancedLogEntry>> logs = ThreadLocal.withInitial(ArrayList::new);
    private ThreadLocal<Optional<Set<String>>> types = ThreadLocal.withInitial(Optional::empty);
    private boolean enabled = true;

    public void collect(Logs seleniumLogs) {
        if (!this.enabled) {
            return;
        }
        try {
            if (!this.types.get().isPresent()) {
                Set discoveredTypes = seleniumLogs.getAvailableLogTypes();
                this.types.set(Optional.of(discoveredTypes));
            }
            this.types.get().ifPresent(types -> types.forEach(type -> {
                LogEntries logEntries = seleniumLogs.get(type);
                if (logEntries != null) {
                    List typedLogs = logEntries.getAll().stream().map(log -> new EnhancedLogEntry((String)type, (LogEntry)log)).collect(Collectors.toList());
                    this.logs.get().addAll(typedLogs);
                }
            }));
        }
        catch (WebDriverException e) {
            this.enabled = false;
            LOG.warn("Attempt to collect Selenium logs has been failed. Logs won't be collected");
            LOG.debug("Root cause", (Throwable)e);
        }
    }

    public void clean() {
        this.logs.remove();
        this.types.remove();
    }

    public List<EnhancedLogEntry> query(Predicate<EnhancedLogEntry> predicate) {
        List<EnhancedLogEntry> result = this.logs.get().stream().filter(predicate).collect(Collectors.toList());
        this.logs.get().removeAll(result);
        return result;
    }
}

