/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.thucydides.core.model.TestStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUnitsHolder {
    private static final Logger LOG = LoggerFactory.getLogger(LogUnitsHolder.class);
    private Set<Function<TestStep, Collection<SaveLogRQ>>> units = new HashSet<Function<TestStep, Collection<SaveLogRQ>>>();

    @SafeVarargs
    public final void register(Function<TestStep, Collection<SaveLogRQ>> ... units) {
        Preconditions.checkArgument((units != null ? 1 : 0) != 0, (Object)"Passed units must not be null");
        if (units.length == 0) {
            LOG.warn("Empty list of log units is passed. No logs will be emitted to Report Portal");
        }
        this.units = new HashSet<Function<TestStep, Collection<SaveLogRQ>>>(Arrays.asList(units));
    }

    public void proceed(TestStep step) {
        this.units.forEach(item -> {
            Collection logs = (Collection)item.apply(step);
            logs.forEach(log -> ReportPortal.emitLog(id -> {
                log.setItemUuid(id);
                return log;
            }));
        });
    }
}

