/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.github.invictum.reportportal.log.unit.Attachment;
import com.github.invictum.reportportal.log.unit.Error;
import com.github.invictum.reportportal.log.unit.Rest;
import com.github.invictum.reportportal.log.unit.Selenium;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import net.thucydides.core.model.TestStep;

public enum LogsPreset {
    DEFAULT{

        @Override
        public Function<TestStep, Collection<SaveLogRQ>>[] logUnits() {
            return new Function[]{Attachment.screenshots(), Rest.restQuery(), Error.basic(), Attachment.evidences()};
        }
    }
    ,
    FULL{

        @Override
        public Function<TestStep, Collection<SaveLogRQ>>[] logUnits() {
            return new Function[]{Attachment.screenshots(), Rest.restQuery(), Error.basic(), Attachment.htmlSources(), Attachment.evidences(), Selenium.allLogs()};
        }
    }
    ,
    CUSTOM{
        private Function<TestStep, Collection<SaveLogRQ>>[] units;

        @Override
        public Function<TestStep, Collection<SaveLogRQ>>[] logUnits() {
            return this.units == null ? new Function[]{} : this.units;
        }

        @Override
        @SafeVarargs
        public final LogsPreset register(Function<TestStep, Collection<SaveLogRQ>> ... units) {
            Preconditions.checkArgument((units != null ? 1 : 0) != 0, (Object)"Units list must not be null");
            this.units = units;
            return this;
        }
    };


    public abstract Function<TestStep, Collection<SaveLogRQ>>[] logUnits();

    public LogsPreset register(Function<TestStep, Collection<SaveLogRQ>> ... units) {
        throw new UnsupportedOperationException("Only CUSTOM preset allows to register log units");
    }
}

