/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import java.util.Optional;
import java.util.function.Function;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.requirements.annotations.NarrativeFinder;

public class NarrativeExtractor {
    private TestOutcome test;
    private Function<Narrative, String> formatter;

    public NarrativeExtractor(TestOutcome test, Function<Narrative, String> formatter) {
        this.test = test;
        this.formatter = formatter;
    }

    public Optional<String> extract() {
        String storyNarrative = this.test.getUserStory().getNarrative();
        return Optional.ofNullable(storyNarrative == null ? this.classNarrative() : storyNarrative);
    }

    private String classNarrative() {
        Class testCase = this.test.getTestCase();
        if (testCase == null) {
            return "";
        }
        return NarrativeFinder.forClass((Class)testCase).map(this.formatter).orElse(null);
    }
}

