/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.github.invictum.reportportal.LogsPreset;
import java.util.Objects;
import java.util.function.Function;
import net.thucydides.core.annotations.Narrative;

public class ReportIntegrationConfig {
    public static final String COMMUNICATION_DIR_KEY = "serenity.rp.communication.dir";
    public static final String MODULES_COUNT_KEY = "serenity.rp.modules.count";
    public static final String FAILSAFE_RERUN_KEY = "failsafe.rerunFailingTestsCount";
    public static final String SUREFIRE_RERUN_KEY = "surefire.rerunFailingTestsCount";
    private static volatile ReportIntegrationConfig instance;
    private LogsPreset preset = LogsPreset.DEFAULT;
    private Function<Narrative, String> classNarrativeFormatter = n -> String.join((CharSequence)"\n", n.text());
    boolean harvestSeleniumLogs = false;
    boolean truncateNames = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportIntegrationConfig get() {
        if (instance != null) return instance;
        Class<ReportIntegrationConfig> clazz = ReportIntegrationConfig.class;
        synchronized (ReportIntegrationConfig.class) {
            if (instance != null) return instance;
            instance = new ReportIntegrationConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ReportIntegrationConfig usePreset(LogsPreset preset) {
        this.preset = Objects.requireNonNull(preset, "Profile could not be null");
        return this;
    }

    public LogsPreset preset() {
        return this.preset;
    }

    public ReportIntegrationConfig useClassNarrativeFormatter(Function<Narrative, String> formatter) {
        this.classNarrativeFormatter = Objects.requireNonNull(formatter, "Formatter must not be null");
        return this;
    }

    public ReportIntegrationConfig harvestSeleniumLogs(boolean harvestLogs) {
        this.harvestSeleniumLogs = harvestLogs;
        return this;
    }

    public Function<Narrative, String> formatter() {
        return this.classNarrativeFormatter;
    }

    public ReportIntegrationConfig truncateNames(boolean setting) {
        this.truncateNames = setting;
        return this;
    }

    public String communicationDirectory() {
        return System.getProperty(COMMUNICATION_DIR_KEY);
    }

    public int retriesCount() {
        String value = System.getProperty(FAILSAFE_RERUN_KEY, System.getProperty(SUREFIRE_RERUN_KEY));
        try {
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong retires count", e);
        }
    }

    public int modulesQuantity() {
        String value = System.getProperty(MODULES_COUNT_KEY);
        return value == null ? 0 : Integer.parseInt(value);
    }
}

