/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.github.invictum.reportportal.LogStorage;
import com.github.invictum.reportportal.ReportIntegrationConfig;
import com.github.invictum.reportportal.SuiteStorage;
import com.github.invictum.reportportal.injector.IntegrationInjector;
import com.github.invictum.reportportal.recorder.TestRecorder;
import com.google.inject.Inject;
import java.util.Map;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.openqa.selenium.logging.Logs;

public class ReportPortalListener
implements StepListener {
    @Inject
    private LogStorage logStorage;
    @Inject
    private SuiteStorage suiteStorage;

    public ReportPortalListener() {
        IntegrationInjector.getInjector().injectMembers((Object)this);
    }

    public void testSuiteStarted(Class<?> storyClass) {
    }

    public void testSuiteStarted(Story story) {
    }

    public void testSuiteFinished() {
        this.suiteStorage.finalizeActive();
    }

    public void testStarted(String description) {
    }

    public void testStarted(String description, String id) {
    }

    public void testFinished(TestOutcome result) {
        TestRecorder recorder = TestRecorder.forTest(result);
        recorder.record(result);
        this.logStorage.clean();
    }

    public void testRetried() {
    }

    public void stepStarted(ExecutedStepDescription description) {
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    public void stepFailed(StepFailure failure) {
        this.harvestDriverLogs();
    }

    public void lastStepFailed(StepFailure failure) {
    }

    public void stepIgnored() {
    }

    public void stepPending() {
    }

    public void stepPending(String message) {
    }

    public void stepFinished() {
        this.harvestDriverLogs();
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    public void testIgnored() {
    }

    public void testSkipped() {
    }

    public void testPending() {
    }

    public void testIsManual() {
    }

    public void notifyScreenChange() {
    }

    public void useExamplesFrom(DataTable table) {
    }

    public void addNewExamplesFrom(DataTable table) {
    }

    public void exampleStarted(Map<String, String> data) {
    }

    public void exampleFinished() {
    }

    public void assumptionViolated(String message) {
    }

    public void testRunFinished() {
    }

    private void harvestDriverLogs() {
        boolean harvestLogs = ReportIntegrationConfig.get().harvestSeleniumLogs;
        if (harvestLogs && ThucydidesWebDriverSupport.isDriverInstantiated()) {
            Logs logs = ThucydidesWebDriverSupport.getDriver().manage().logs();
            this.logStorage.collect(logs);
        }
    }
}

