/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.github.invictum.reportportal.ItemType;
import com.github.invictum.reportportal.ReportIntegrationConfig;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.TestTag;
import org.apache.commons.lang3.StringUtils;

public class StartEventBuilder {
    private static final int NAME_LIMIT = 1024;
    private StartTestItemRQ startEvent = new StartTestItemRQ();

    public StartEventBuilder(ItemType type) {
        this.startEvent.setType(type.name());
    }

    public StartEventBuilder withStartTime(ZonedDateTime time) {
        this.startEvent.setStartTime(Date.from(time.toInstant()));
        return this;
    }

    public StartEventBuilder withName(String name) {
        this.startEvent.setName(name);
        return this;
    }

    public StartEventBuilder withDescription(String description) {
        this.startEvent.setDescription(description);
        return this;
    }

    public StartEventBuilder withRetry() {
        this.startEvent.setRetry(Boolean.valueOf(true));
        return this;
    }

    public StartEventBuilder withParameters(DataTable.RowValueAccessor data) {
        List parameters = data.toStringMap().entrySet().stream().map(param -> {
            ParameterResource parameter = new ParameterResource();
            parameter.setKey((String)param.getKey());
            parameter.setValue((String)param.getValue());
            return parameter;
        }).collect(Collectors.toList());
        this.startEvent.setParameters(parameters);
        return this;
    }

    public StartEventBuilder withTags(Set<TestTag> tags) {
        Set result = tags.stream().filter(t -> !t.getType().contentEquals("story")).map(tag -> new ItemAttributesRQ(tag.getType(), tag.getName())).collect(Collectors.toSet());
        this.startEvent.setAttributes(result);
        return this;
    }

    public StartEventBuilder treeOptimized(boolean isOptimized) {
        this.startEvent.setHasStats(!isOptimized);
        return this;
    }

    public StartTestItemRQ build() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.startEvent.getName()) ? 1 : 0) != 0, (Object)"Event name must not be null or empty");
        if (ReportIntegrationConfig.get().truncateNames) {
            String name = this.startEvent.getName();
            this.startEvent.setName(name.length() > 1024 ? StringUtils.truncate((String)name, (int)1021) + "..." : name);
        }
        Objects.requireNonNull(this.startEvent.getStartTime(), "Start date must not be null");
        return this.startEvent;
    }
}

