/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.github.invictum.reportportal.LogLevel;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.model.TestResult;

public enum Status {
    PASSED(LogLevel.INFO, TestResult.SUCCESS),
    FAILED(LogLevel.ERROR, TestResult.ERROR, TestResult.FAILURE),
    SKIPPED(LogLevel.DEBUG, TestResult.IGNORED, TestResult.SKIPPED, TestResult.PENDING, TestResult.COMPROMISED),
    CANCELLED(LogLevel.FATAL, TestResult.UNDEFINED, TestResult.UNSUCCESSFUL);

    private final List<TestResult> map;
    private final LogLevel level;

    private Status(LogLevel level, TestResult ... statuses) {
        this.map = Arrays.asList(statuses);
        this.level = level;
    }

    public LogLevel logLevel() {
        return this.level;
    }

    public static Status mapTo(TestResult result) {
        return Arrays.stream(Status.values()).filter(item -> item.map.contains(result)).findFirst().orElse(CANCELLED);
    }
}

