/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import io.reactivex.Maybe;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class SuiteStorage {
    private final ConcurrentHashMap<String, SuiteMetadata> suites = new ConcurrentHashMap();

    public Maybe<String> start(String id, Supplier<Maybe<String>> start) {
        this.suites.computeIfAbsent(id, old -> {
            SuiteMetadata metadata = new SuiteMetadata();
            metadata.id = (Maybe)start.get();
            return metadata;
        });
        SuiteMetadata meta = this.suites.get(id);
        return meta.id;
    }

    public void suiteFinisher(String id, Runnable finisher) {
        this.suites.computeIfPresent(id, (key, meta) -> {
            ((SuiteMetadata)meta).finisher = finisher;
            return meta;
        });
    }

    public void finalizeActive() {
        this.suites.forEachKey(Runtime.getRuntime().availableProcessors(), id -> {
            SuiteMetadata meta = this.suites.get(id);
            if (meta.failedTests.isEmpty()) {
                this.suites.remove(id);
                meta.finisher.run();
            }
        });
    }

    public void addNewFail(String suiteId, String testId) {
        SuiteMetadata meta = this.suites.get(suiteId);
        meta.failedTests.put(testId, new AtomicInteger(0));
    }

    public boolean isFailPresent(String suiteId, String testId) {
        SuiteMetadata meta = this.suites.get(suiteId);
        return meta.failedTests.containsKey(testId);
    }

    public void removeFail(String suiteId, String testId) {
        SuiteMetadata meta = this.suites.get(suiteId);
        meta.failedTests.remove(testId);
    }

    public int incrementAndGetRetriesCount(String suiteId, String testId) {
        SuiteMetadata meta = this.suites.get(suiteId);
        AtomicInteger failCount = (AtomicInteger)meta.failedTests.get(testId);
        return failCount.incrementAndGet();
    }

    private static class SuiteMetadata {
        private Maybe<String> id;
        private Runnable finisher;
        private final Map<String, AtomicInteger> failedTests = new HashMap<String, AtomicInteger>();

        private SuiteMetadata() {
        }
    }
}

