/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal;

import com.github.invictum.reportportal.Status;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;

public class Utils {
    private Utils() {
    }

    public static String logLevel(TestResult testResult) {
        return Status.mapTo(testResult).logLevel().toString();
    }

    public static Date stepEndDate(TestStep step) {
        ZonedDateTime endTimeZoned = step.getStartTime().plus(Duration.ofMillis(step.getDuration()));
        return Date.from(endTimeZoned.toInstant());
    }

    public static Date testEndDate(TestOutcome test) {
        ZonedDateTime endTimeZoned = test.getStartTime().plus(Duration.ofMillis(test.getDuration()));
        return Date.from(endTimeZoned.toInstant());
    }

    public static Date stepStartDate(TestStep step) {
        return Date.from(step.getStartTime().toInstant());
    }
}

