/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal.log.unit;

import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.github.invictum.reportportal.LogLevel;
import com.github.invictum.reportportal.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.model.ReportData;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attachment {
    private static final Logger LOG = LoggerFactory.getLogger(Attachment.class);
    private static final Tika TIKA = new Tika();

    public static Function<TestStep, Collection<SaveLogRQ>> screenshots() {
        return step -> {
            HashSet<SaveLogRQ> logs = new HashSet<SaveLogRQ>();
            if (!step.getScreenshots().isEmpty()) {
                Date stepStartTime = Date.from(step.getStartTime().toInstant());
                for (ScreenshotAndHtmlSource screenshotAndHtmlSource : step.getScreenshots()) {
                    File screenshotFile = screenshotAndHtmlSource.getScreenshot();
                    Date timestamp = screenshotFile.lastModified() < stepStartTime.getTime() ? stepStartTime : new Date(screenshotFile.lastModified());
                    try {
                        byte[] data = Files.readAllBytes(screenshotFile.toPath());
                        SaveLogRQ.File screenshot = new SaveLogRQ.File();
                        screenshot.setContent(data);
                        screenshot.setName(screenshotFile.getName());
                        screenshot.setContentType("image/png");
                        SaveLogRQ log = new SaveLogRQ();
                        log.setFile(screenshot);
                        log.setMessage("Screenshot");
                        log.setLogTime(timestamp);
                        log.setLevel(Utils.logLevel(step.getResult()));
                        logs.add(log);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to attach screenshot");
                    }
                }
            }
            return logs;
        };
    }

    public static Function<TestStep, Collection<SaveLogRQ>> htmlSources() {
        return step -> {
            HashSet sources = new HashSet();
            if (!step.getScreenshots().isEmpty()) {
                Date stepStartTime = Date.from(step.getStartTime().toInstant());
                for (ScreenshotAndHtmlSource screenshotAndHtmlSource : step.getScreenshots()) {
                    Optional sourceFile = screenshotAndHtmlSource.getHtmlSource();
                    sourceFile.ifPresent(file -> {
                        Date timestamp = file.lastModified() < stepStartTime.getTime() ? stepStartTime : new Date(file.lastModified());
                        try {
                            byte[] data = Files.readAllBytes(file.toPath());
                            SaveLogRQ.File attachment = new SaveLogRQ.File();
                            attachment.setContent(data);
                            attachment.setName(file.getName());
                            attachment.setContentType("text/plain");
                            SaveLogRQ log = new SaveLogRQ();
                            log.setFile(attachment);
                            log.setMessage("HTML Source");
                            log.setLevel(Utils.logLevel(step.getResult()));
                            log.setLogTime(timestamp);
                            sources.add(log);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to attach HTML sources");
                        }
                    });
                }
            }
            return sources;
        };
    }

    public static Function<TestStep, Collection<SaveLogRQ>> evidences() {
        return step -> step.getReportEvidence().stream().filter(ReportData::isEvidence).map(report -> report.getPath() == null ? Attachment.fromContent(report) : Attachment.fromFile(report)).filter(Objects::nonNull).peek(log -> log.setLogTime(Utils.stepEndDate(step))).collect(Collectors.toSet());
    }

    private static SaveLogRQ fromFile(ReportData data) {
        SaveLogRQ.File file = new SaveLogRQ.File();
        file.setName(data.getId());
        try {
            String reportRoot = ConfiguredEnvironment.getConfiguration().getOutputDirectory().toString();
            Path path = Paths.get(reportRoot, data.getPath());
            byte[] content = Files.readAllBytes(path);
            file.setContent(content);
            String mime = TIKA.detect(content, data.getPath());
            file.setContentType(mime);
        }
        catch (IOException e) {
            LOG.error("Unable to attach evidence", (Throwable)e);
            return null;
        }
        SaveLogRQ log = new SaveLogRQ();
        log.setMessage(data.getTitle());
        log.setFile(file);
        log.setLevel(LogLevel.DEBUG.toString());
        return log;
    }

    private static SaveLogRQ fromContent(ReportData data) {
        SaveLogRQ.File file = new SaveLogRQ.File();
        file.setName(data.getId());
        file.setContentType("application/txt");
        file.setContent(data.getContents().getBytes());
        SaveLogRQ log = new SaveLogRQ();
        log.setFile(file);
        log.setMessage(data.getTitle());
        log.setLevel(LogLevel.DEBUG.toString());
        return log;
    }
}

