/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal.log.unit;

import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.github.invictum.reportportal.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;

public class Error {
    private static final Function<TestStep, String> STEP_FORMATTER = step -> {
        Throwable cause = step.getException().getOriginalCause();
        return Error.stringifyStackTrace(cause);
    };
    private static final Function<TestOutcome, String> TEST_FORMATTER = testOutcome -> {
        Throwable cause = testOutcome.getTestFailureCause().toException();
        return Error.stringifyStackTrace(cause);
    };

    private static String stringifyStackTrace(Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static Function<TestStep, Collection<SaveLogRQ>> configuredStepError(Function<TestStep, String> errorFormatter) {
        return step -> {
            if (step.getException() != null) {
                SaveLogRQ log = new SaveLogRQ();
                log.setMessage((String)errorFormatter.apply((TestStep)step));
                log.setLevel(Utils.logLevel(step.getResult()));
                log.setLogTime(Utils.stepEndDate(step));
                return Collections.singleton(log);
            }
            return Collections.emptySet();
        };
    }

    public static Function<TestOutcome, Collection<SaveLogRQ>> configuredTestError(Function<TestOutcome, String> errorFormatter) {
        return testOutcome -> {
            if (!testOutcome.getFailingStep().isPresent() && testOutcome.getTestFailureCause() != null) {
                SaveLogRQ log = new SaveLogRQ();
                log.setMessage((String)errorFormatter.apply((TestOutcome)testOutcome));
                log.setLevel(Utils.logLevel(testOutcome.getResult()));
                log.setLogTime(Utils.testEndDate(testOutcome));
                return Collections.singleton(log);
            }
            return Collections.emptySet();
        };
    }

    public static Function<TestStep, Collection<SaveLogRQ>> basic() {
        return Error.configuredStepError(STEP_FORMATTER);
    }

    public static Function<TestOutcome, Collection<SaveLogRQ>> errorInTest() {
        return Error.configuredTestError(TEST_FORMATTER);
    }
}

