/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal.log.unit;

import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.github.invictum.reportportal.EnhancedLogEntry;
import com.github.invictum.reportportal.LogLevel;
import com.github.invictum.reportportal.LogStorage;
import com.github.invictum.reportportal.Utils;
import com.github.invictum.reportportal.injector.IntegrationInjector;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thucydides.core.model.TestStep;

public class Selenium {
    public static Function<TestStep, Collection<SaveLogRQ>> allLogs() {
        return Selenium.filteredLogs(log -> true);
    }

    public static Function<TestStep, Collection<SaveLogRQ>> filteredLogs(Predicate<EnhancedLogEntry> filter) {
        return step -> {
            long start = Utils.stepStartDate(step).getTime();
            long end = Utils.stepEndDate(step).getTime();
            LogStorage storage = (LogStorage)IntegrationInjector.getInjector().getInstance(LogStorage.class);
            HashSet logs = new HashSet();
            storage.query(filter.and(entry -> start >= entry.getTimestamp() && entry.getTimestamp() <= end)).forEach(log -> {
                String message = String.format("[Selenium-%s] [%s] %s", log.getType(), log.getLevel(), log.getMessage());
                SaveLogRQ entry = new SaveLogRQ();
                entry.setMessage(message);
                entry.setLevel(LogLevel.DEBUG.toString());
                entry.setLogTime(new Date(log.getTimestamp()));
                logs.add(entry);
            });
            return logs;
        };
    }
}

