/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal.recorder;

import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.github.invictum.reportportal.FinishEventBuilder;
import com.github.invictum.reportportal.ItemType;
import com.github.invictum.reportportal.LogUnitsHolder;
import com.github.invictum.reportportal.StartEventBuilder;
import com.github.invictum.reportportal.Status;
import com.github.invictum.reportportal.SuiteStorage;
import com.github.invictum.reportportal.recorder.TestRecorder;
import com.google.inject.Inject;
import io.reactivex.Maybe;
import java.util.Arrays;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;

public class BddDataDriven
extends TestRecorder {
    @Inject
    public BddDataDriven(SuiteStorage suiteStorage, Launch launch, LogUnitsHolder holder) {
        super(suiteStorage, launch, holder);
    }

    @Override
    public void record(TestOutcome out) {
        int last = out.getTestSteps().size() - 1;
        TestStep test = (TestStep)out.getTestSteps().get(last);
        StartTestItemRQ startStory = new StartEventBuilder(ItemType.TEST).withName(out.getUserStory().getName()).withStartTime(test.getStartTime()).withDescription(out.getUserStory().getNarrative()).build();
        Maybe<String> id = this.suiteStorage.start(out.getUserStory().getId(), () -> this.launch.startTestItem(startStory));
        StartTestItemRQ startScenario = new StartEventBuilder(ItemType.STEP).withName(out.getName()).withStartTime(test.getStartTime()).withParameters(out.getDataTable().row(last)).withTags(out.getTags()).build();
        Maybe testId = this.launch.startTestItem(id, startScenario);
        this.proceedSteps((Maybe<String>)testId, Arrays.asList(test));
        FinishTestItemRQ finishScenario = new FinishEventBuilder().withStatus(Status.mapTo(test.getResult())).withEndTime(test.getStartTime(), test.getDuration()).build();
        this.launch.finishTestItem(testId, finishScenario);
        FinishTestItemRQ finishStory = new FinishEventBuilder().withStatus(Status.PASSED).withEndTime(test.getStartTime(), test.getDuration()).build();
        this.suiteStorage.suiteFinisher(out.getUserStory().getId(), () -> this.launch.finishTestItem(id, finishStory));
    }
}

