/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal.recorder;

import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.github.invictum.reportportal.FinishEventBuilder;
import com.github.invictum.reportportal.ItemType;
import com.github.invictum.reportportal.LogUnitsHolder;
import com.github.invictum.reportportal.NarrativeExtractor;
import com.github.invictum.reportportal.ReportIntegrationConfig;
import com.github.invictum.reportportal.StartEventBuilder;
import com.github.invictum.reportportal.Status;
import com.github.invictum.reportportal.SuiteStorage;
import com.github.invictum.reportportal.log.unit.Error;
import com.github.invictum.reportportal.recorder.TestRecorder;
import com.google.inject.Inject;
import io.reactivex.Maybe;
import java.util.Collection;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;

public class Regular
extends TestRecorder {
    static final int RETRIES_COUNT = ReportIntegrationConfig.get().retriesCount();

    @Inject
    public Regular(SuiteStorage suiteStorage, Launch launch, LogUnitsHolder holder) {
        super(suiteStorage, launch, holder);
    }

    @Override
    public void record(TestOutcome out) {
        StartEventBuilder suiteEventBuilder = new StartEventBuilder(ItemType.TEST).withName(out.getUserStory().getDisplayName()).withStartTime(out.getStartTime()).withDescription(out.getUserStory().getNarrative());
        NarrativeExtractor extractor = new NarrativeExtractor(out, ReportIntegrationConfig.get().formatter());
        extractor.extract().ifPresent(suiteEventBuilder::withDescription);
        StartTestItemRQ startSuite = suiteEventBuilder.build();
        Maybe<String> suiteId = this.suiteStorage.start(out.getUserStory().getId(), () -> this.launch.startTestItem(startSuite));
        StartEventBuilder testEventBuilder = new StartEventBuilder(ItemType.STEP).withName(out.getName()).withStartTime(out.getStartTime()).withTags(out.getTags());
        if (RETRIES_COUNT > 0) {
            this.processRetries(out, testEventBuilder);
        }
        if (out.isDataDriven()) {
            testEventBuilder.withParameters(out.getDataTable().row(0));
        }
        Maybe testId = this.launch.startTestItem(suiteId, testEventBuilder.build());
        this.proceedSteps((Maybe<String>)testId, out.getTestSteps());
        this.recordNonStepFailure(out);
        FinishTestItemRQ finishTest = new FinishEventBuilder().withStatus(Status.mapTo(out.getResult())).withEndTime(out.getStartTime(), out.getDuration()).build();
        this.launch.finishTestItem(testId, finishTest);
        FinishTestItemRQ finishSuite = new FinishEventBuilder().withStatus(Status.PASSED).withEndTime(out.getStartTime(), out.getDuration()).build();
        this.suiteStorage.suiteFinisher(out.getUserStory().getId(), () -> this.launch.finishTestItem(suiteId, finishSuite));
    }

    private void recordNonStepFailure(TestOutcome out) {
        Collection<SaveLogRQ> logs = Error.errorInTest().apply(out);
        logs.forEach(log -> ReportPortal.emitLog(id -> {
            log.setItemUuid(id);
            return log;
        }));
    }

    private boolean isTestFailed(TestOutcome out) {
        TestResult testResult = out.getResult();
        return testResult == TestResult.ERROR || testResult == TestResult.FAILURE;
    }

    private void processRetries(TestOutcome out, StartEventBuilder builder) {
        String testId = out.getId();
        String suiteId = out.getUserStory().getId();
        if (this.suiteStorage.isFailPresent(suiteId, testId)) {
            builder.withRetry();
            int retriesCount = this.suiteStorage.incrementAndGetRetriesCount(suiteId, testId);
            if (!this.isTestFailed(out) || retriesCount == RETRIES_COUNT) {
                this.suiteStorage.removeFail(suiteId, testId);
            }
        } else if (this.isTestFailed(out)) {
            this.suiteStorage.addNewFail(suiteId, testId);
        }
    }
}

