/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.reportportal.recorder;

import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.github.invictum.reportportal.FinishEventBuilder;
import com.github.invictum.reportportal.ItemType;
import com.github.invictum.reportportal.LogUnitsHolder;
import com.github.invictum.reportportal.StartEventBuilder;
import com.github.invictum.reportportal.Status;
import com.github.invictum.reportportal.SuiteStorage;
import com.github.invictum.reportportal.injector.IntegrationInjector;
import com.github.invictum.reportportal.recorder.BddDataDriven;
import com.github.invictum.reportportal.recorder.Regular;
import com.google.inject.Injector;
import io.reactivex.Maybe;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;

public abstract class TestRecorder {
    protected SuiteStorage suiteStorage;
    protected Launch launch;
    protected LogUnitsHolder holder;

    public TestRecorder(SuiteStorage suiteStorage, Launch launch, LogUnitsHolder holder) {
        this.suiteStorage = suiteStorage;
        this.launch = launch;
        this.holder = holder;
    }

    public abstract void record(TestOutcome var1);

    public static TestRecorder forTest(TestOutcome testOutcome) {
        Injector injector = IntegrationInjector.getInjector();
        if (testOutcome.isDataDriven() && testOutcome.getTestSource().toLowerCase().matches("(cucumber|jbehave)")) {
            return (TestRecorder)injector.getInstance(BddDataDriven.class);
        }
        return (TestRecorder)injector.getInstance(Regular.class);
    }

    protected void proceedSteps(Maybe<String> parent, List<TestStep> steps) {
        steps.forEach(step -> {
            StartTestItemRQ startStep = new StartEventBuilder(ItemType.STEP).withName(step.getDescription()).withStartTime(step.getStartTime()).treeOptimized(true).build();
            Maybe current = this.launch.startTestItem(parent, startStep);
            this.holder.proceed((TestStep)step);
            if (step.hasChildren()) {
                this.proceedSteps((Maybe<String>)current, step.getChildren());
            }
            FinishTestItemRQ finishStep = new FinishEventBuilder().withEndTime(step.getStartTime(), step.getDuration()).withStatus(Status.mapTo(step.getResult())).build();
            this.launch.finishTestItem(current, finishStep);
        });
    }
}

