/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.xew;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementWrapperPlugin
extends Plugin {
    private static final String PLUGIN_NAME = "Xxew";
    private static final String OPTION_NAME_DELETE = "-Xxew:delete";
    private static final String OPTION_NAME_INCLUDE = "-Xxew:includeFile";
    private static final String OPTION_NAME_EXCLUDE = "-Xxew:excludeFile";
    private static final String OPTION_NAME_SUMMARY = "-Xxew:summaryFile";
    private static final String OPTION_NAME_COLLECTION = "-Xxew:collection";
    private static final String OPTION_NAME_INSTANTIATE = "-Xxew:instantiate";
    private static final String FACTORY_CLASS_NAME = "ObjectFactory";
    private File includeFile = null;
    private Set<String> include = null;
    private File excludeFile = null;
    private Set<String> exclude = null;
    private File summaryFile = null;
    private PrintWriter summary = null;
    private boolean debugMode = false;
    private boolean verbose = false;
    private Class<?> collectionInterfaceClass = List.class;
    private Class<?> collectionImplClass = ArrayList.class;
    private Instantiation instantiation = Instantiation.EARLY;
    private boolean deleteCandidates = false;
    private static boolean applyPluralForm = false;

    public String getOptionName() {
        return PLUGIN_NAME;
    }

    public String getUsage() {
        return "  -Xxew: Replace collection types with fields having the @XmlElementWrapper and @XmlElement annotations.";
    }

    public void onActivated(Options opts) {
        this.debugMode = opts.debugMode;
        this.verbose = opts.verbose;
        this.writeDebug("JAXB Compilation started (XmlElementWrapperPlugin.onActivated):");
        this.writeDebug("\tbuildId        :\t" + Options.getBuildID());
        this.writeDebug("\tdefaultPackage :\t" + opts.defaultPackage);
        this.writeDebug("\tdefaultPackage2:\t" + opts.defaultPackage2);
        this.writeDebug("\tquiet          :\t" + opts.quiet);
        this.writeDebug("\tdebug          :\t" + opts.debugMode);
        this.writeDebug("\ttargetDir      :\t" + opts.targetDir);
        this.writeDebug("\tverbose        :\t" + opts.verbose);
        this.writeDebug("\tGrammars       :\t" + opts.getGrammars().length);
        for (int i = 0; i < opts.getGrammars().length; ++i) {
            this.writeDebug("\t  [" + i + "]: " + opts.getGrammars()[i].getSystemId());
        }
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int recognized = 0;
        String arg = args[i];
        this.writeDebug("Argument[" + i + "] = " + arg);
        if (arg.startsWith(OPTION_NAME_DELETE)) {
            ++recognized;
            this.deleteCandidates = true;
        } else if (arg.startsWith(OPTION_NAME_INCLUDE)) {
            String filename;
            ++recognized;
            this.include = new HashSet<String>();
            if (arg.length() > OPTION_NAME_INCLUDE.length()) {
                filename = arg.substring(OPTION_NAME_INCLUDE.length()).trim();
            } else {
                filename = args[i + 1];
                ++recognized;
            }
            this.includeFile = new File(filename);
            XmlElementWrapperPlugin.readCandidates(this.includeFile, this.include);
        } else if (arg.startsWith(OPTION_NAME_EXCLUDE)) {
            String filename;
            ++recognized;
            this.exclude = new HashSet<String>();
            if (arg.length() > OPTION_NAME_EXCLUDE.length()) {
                filename = arg.substring(OPTION_NAME_EXCLUDE.length()).trim();
            } else {
                filename = args[i + 1];
                ++recognized;
            }
            this.excludeFile = new File(filename);
            XmlElementWrapperPlugin.readCandidates(this.excludeFile, this.exclude);
        } else if (arg.startsWith(OPTION_NAME_SUMMARY)) {
            String filename;
            ++recognized;
            if (arg.length() > OPTION_NAME_SUMMARY.length()) {
                filename = arg.substring(OPTION_NAME_SUMMARY.length()).trim();
            } else {
                filename = args[i + 1];
                ++recognized;
            }
            this.summaryFile = new File(filename);
            this.summary = new PrintWriter(new FileOutputStream(this.summaryFile));
        } else if (arg.startsWith(OPTION_NAME_COLLECTION)) {
            String ccn;
            ++recognized;
            if (arg.length() > OPTION_NAME_COLLECTION.length()) {
                ccn = arg.substring(OPTION_NAME_COLLECTION.length()).trim();
            } else {
                ccn = args[i + 1];
                ++recognized;
            }
            try {
                this.collectionImplClass = Class.forName(ccn);
            }
            catch (ClassNotFoundException e) {
                throw new BadCommandLineException("-Xxew:collection " + ccn + ": Class not found.");
            }
        } else if (arg.startsWith(OPTION_NAME_INSTANTIATE)) {
            String instantiate;
            ++recognized;
            if (arg.length() > OPTION_NAME_INSTANTIATE.length()) {
                instantiate = arg.substring(OPTION_NAME_INSTANTIATE.length()).trim().toUpperCase();
            } else {
                instantiate = args[i + 1].trim().toUpperCase();
                ++recognized;
            }
            this.instantiation = Instantiation.valueOf(instantiate);
        } else if (arg.startsWith("-Xxew:")) {
            throw new BadCommandLineException("Invalid argument " + arg);
        }
        return recognized;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        this.writeDebug("JAXB Process Model (run)...");
        this.writeSummary(" ");
        this.writeSummary("Compilation:");
        this.writeSummary("\tDate         :\t-");
        this.writeSummary("\tVersion      :\t-");
        this.writeSummary("\tJAXB version :\t" + Options.getBuildID());
        this.writeSummary("\tInclude file :\t" + (this.includeFile == null ? "<none>" : this.includeFile));
        this.writeSummary("\tExclude file :\t" + (this.excludeFile == null ? "<none>" : this.excludeFile));
        this.writeSummary("\tSummary file :\t" + (this.summaryFile == null ? "<none>" : this.summaryFile));
        this.writeSummary("\tInstantiate  :\t" + (Object)((Object)this.instantiation));
        this.writeSummary("\tCollection   :\t" + this.collectionImplClass);
        this.writeSummary("\tInterface    :\t" + this.collectionInterfaceClass);
        this.writeSummary("\tDelete       :\t" + this.deleteCandidates);
        this.writeSummary(" ");
        Map<String, Candidate> candidates = this.findCandidateClasses(outline);
        this.writeSummary("Candidates:");
        Iterator<Map.Entry<String, Candidate>> iter = candidates.entrySet().iterator();
        while (iter.hasNext()) {
            Candidate candidate = iter.next().getValue();
            if (this.isIncluded(candidate)) {
                this.writeSummary("\t[" + (candidate.isMarkedForRemoval() ? "!" : "+") + "]: " + this.getIncludeOrExcludeReason() + ":\t" + candidate.getClassName());
                continue;
            }
            this.writeSummary("\t[-]: " + this.getIncludeOrExcludeReason() + ":\t" + candidate.getClassName());
            iter.remove();
        }
        this.writeSummary("\t" + candidates.size() + " candidate(s) being considered.");
        this.writeSummary(" ");
        this.writeSummary("Modifications:");
        int modificationCount = 0;
        for (ClassOutline outlineClass : outline.getClasses()) {
            JDefinedClass implementationClass = outlineClass.implClass;
            this.cancelRemovalIfNecessary(candidates, implementationClass);
            for (FieldOutline field : outlineClass.getDeclaredFields()) {
                String namespace;
                String fieldName = field.getPropertyInfo().getName(false);
                String typeName = field.getRawType().fullName();
                Candidate candidate = null;
                for (Candidate c : candidates.values()) {
                    if (c.getClassName().equals(typeName)) {
                        candidate = c;
                        break;
                    }
                    if (!XmlElementWrapperPlugin.isListedAsParametrisation((JClass)c.getDefinedClass(), field.getRawType())) continue;
                    this.writeDebug("Candidate " + c.getClassName() + " is listed as parametrisation and hence won't be removed.");
                    c.setMarkedForRemoval(false);
                    break;
                }
                if (candidate == null) continue;
                this.writeSummary("\t" + outlineClass.target.getName() + "#" + fieldName + "\t" + typeName);
                ++modificationCount;
                List itemNarrowing = candidate.getFieldType().getTypeParameters();
                JClass collectionInterfaceClass = implementationClass.owner().ref(this.collectionInterfaceClass).narrow(itemNarrowing);
                JClass collectionImplClass = implementationClass.owner().ref(this.collectionImplClass).narrow(itemNarrowing);
                JFieldVar originalImplField = (JFieldVar)implementationClass.fields().get(fieldName);
                implementationClass.removeField(originalImplField);
                if (XmlElementWrapperPlugin.isPluralFormApplicable(field)) {
                    String oldFieldName = fieldName;
                    fieldName = JJavaName.getPluralForm((String)fieldName);
                    field.getPropertyInfo().setName(false, fieldName);
                    for (JAnnotationUse annotation : implementationClass.annotations()) {
                        JAnnotationUse ann;
                        String annotationClassName = annotation.getAnnotationClass().name();
                        if (!annotationClassName.equals("XmlType")) continue;
                        Iterator i$ = ((JAnnotationArrayMember)annotation.getAnnotationMembers().get("propOrder")).annotations().iterator();
                        while (i$.hasNext() && !oldFieldName.equals(XmlElementWrapperPlugin.getAnnotationStringValue((JAnnotationValue)(ann = (JAnnotationUse)i$.next())))) {
                        }
                        break;
                    }
                }
                JFieldVar implField = implementationClass.field(2, (JType)collectionInterfaceClass, fieldName);
                if (this.instantiation == Instantiation.EARLY) {
                    this.writeDebug("Applying EARLY instantiation...");
                    implField.init((JExpression)JExpr._new((JClass)collectionImplClass));
                }
                JAnnotationUse xmlElementWrapperAnnotation = implField.annotate(XmlElementWrapper.class);
                String xmlElementName = XmlElementWrapperPlugin.extractXmlElementName(field.getPropertyInfo());
                xmlElementWrapperAnnotation.param("name", xmlElementName);
                if (XmlElementWrapperPlugin.isXmlRequired((JVar)originalImplField)) {
                    xmlElementWrapperAnnotation.param("required", true);
                }
                if ((namespace = XmlElementWrapperPlugin.getXmlNamespace((JVar)originalImplField)) != null) {
                    xmlElementWrapperAnnotation.param("namespace", namespace);
                }
                JAnnotationUse xmlElementAnnotation = implField.annotate(XmlElement.class);
                xmlElementAnnotation.param("name", candidate.getXmlElementName());
                if (namespace != null) {
                    xmlElementAnnotation.param("namespace", namespace);
                }
                StringWriter w = new StringWriter();
                JFormatter f = new JFormatter((Writer)w);
                xmlElementWrapperAnnotation.generate(f);
                w.write(" ");
                xmlElementAnnotation.generate(f);
                this.writeDebug(w.toString());
                String fieldPublicName = field.getPropertyInfo().getName(true);
                Iterator iter2 = implementationClass.methods().iterator();
                while (iter2.hasNext()) {
                    JMethod m = (JMethod)iter2.next();
                    if (!m.name().equals("set" + fieldPublicName) && !m.name().equals("get" + fieldPublicName)) continue;
                    iter2.remove();
                }
                if (XmlElementWrapperPlugin.isPluralFormApplicable(field)) {
                    fieldPublicName = JJavaName.getPluralForm((String)fieldPublicName);
                    field.getPropertyInfo().setName(true, fieldPublicName);
                }
                JMethod getterMethod = implementationClass.method(1, (JType)collectionInterfaceClass, "get" + fieldPublicName);
                if (this.instantiation == Instantiation.LAZY) {
                    this.writeDebug("Applying LAZY instantiation...");
                    getterMethod.body()._if(JExpr.ref((String)fieldName).eq(JExpr._null()))._then().assign((JAssignmentTarget)JExpr.ref((String)fieldName), (JExpression)JExpr._new((JClass)collectionImplClass));
                }
                getterMethod.body()._return((JExpression)JExpr.ref((String)fieldName));
                JMethod setterMethod = implementationClass.method(1, (JType)outline.getCodeModel().VOID, "set" + fieldPublicName);
                setterMethod.body().assign((JAssignmentTarget)JExpr._this().ref(fieldName), (JExpression)setterMethod.param((JType)collectionInterfaceClass, fieldName));
            }
        }
        this.writeSummary("\t" + modificationCount + " modification(s) to original code.");
        this.writeSummary(" ");
        int deletionCount = 0;
        if (this.deleteCandidates) {
            deletionCount = this.deleteCandidates(candidates);
        }
        this.writeSummary("\t" + deletionCount + " deletion(s) from original code.");
        this.writeSummary(" ");
        this.writeDebug("Closing summary...");
        this.closeSummary();
        this.writeDebug("Done");
        return true;
    }

    private void cancelRemovalIfNecessary(Map<String, Candidate> candidates, JDefinedClass implementationClass) {
        Candidate candidate;
        JClass parentClass = implementationClass._extends();
        if (parentClass != null && (candidate = candidates.get(parentClass.name())) != null) {
            this.writeDebug("Candidate " + candidate.getClassName() + " is a parent of " + implementationClass.name() + " and hence won't be removed.");
            candidate.setMarkedForRemoval(false);
        }
        for (JFieldVar field : implementationClass.fields().values()) {
            this.checkAnnotationReference(candidates, (JAnnotatable)field);
        }
    }

    private void checkAnnotationReference(Map<String, Candidate> candidates, JAnnotatable annotatable) {
        for (JAnnotationUse annotation : annotatable.annotations()) {
            Candidate candidate;
            String typeClassName;
            String annotationClassName = annotation.getAnnotationClass().name();
            if (annotationClassName.equals("XmlElementRefs") || annotationClassName.equals("XmlElements")) {
                this.checkAnnotationReference(candidates, (JAnnotatable)((JAnnotationArrayMember)annotation.getAnnotationMembers().get("value")));
                continue;
            }
            if (!annotationClassName.equals("XmlElementRef") && !annotationClassName.equals("XmlElement") || (typeClassName = XmlElementWrapperPlugin.getAnnotationMemberStringValue(annotation, "type")) == null || (candidate = candidates.get(typeClassName = typeClassName.replace(".class", ""))) == null) continue;
            this.writeDebug("Candidate " + candidate.getClassName() + " is used in XmlElements/XmlElementRef and hence won't be removed.");
            candidate.setMarkedForRemoval(false);
        }
    }

    private int deleteCandidates(Map<String, Candidate> candidates) {
        int deletionCount = 0;
        this.writeSummary("Deletions:");
        for (Candidate c : candidates.values()) {
            if (!this.isIncluded(c) || !c.isMarkedForRemoval()) continue;
            JDefinedClass candidateClass = c.getDefinedClass();
            JPackage pkg = candidateClass._package();
            JDefinedClass factoryClass = pkg._getClass(FACTORY_CLASS_NAME);
            Iterator iter = factoryClass.methods().iterator();
            while (iter.hasNext()) {
                JMethod m = (JMethod)iter.next();
                if (m.type().compareTo((JType)candidateClass) != 0 && !XmlElementWrapperPlugin.isListedAsParametrisation((JClass)candidateClass, m.type())) continue;
                this.writeSummary("\tRemoving method " + m.type().fullName() + " " + m.name() + " from " + factoryClass.fullName());
                iter.remove();
                ++deletionCount;
            }
            if (candidateClass.parentContainer().isClass()) {
                JDefinedClass parent = (JDefinedClass)candidateClass.parentContainer();
                this.writeSummary("\tRemoving class " + candidateClass.fullName() + " from class " + parent.fullName());
                Iterator itor = parent.classes();
                while (itor.hasNext()) {
                    if (!((JDefinedClass)itor.next()).equals(candidateClass)) continue;
                    itor.remove();
                    break;
                }
                ++deletionCount;
                continue;
            }
            this.writeSummary("\tRemoving class " + candidateClass.fullName() + " from package " + pkg.name());
            pkg.remove((JClass)candidateClass);
            ++deletionCount;
        }
        return deletionCount;
    }

    private boolean isIncluded(Candidate candidate) {
        if (!this.hasIncludes() && !this.hasExcludes()) {
            return true;
        }
        if (this.hasIncludes() && !this.hasExcludes()) {
            return this.include.contains(candidate.getClassName());
        }
        if (!this.hasIncludes() && this.hasExcludes()) {
            return !this.exclude.contains(candidate.getClassName());
        }
        return this.include.contains(candidate.getClassName()) && !this.exclude.contains(candidate.getClassName());
    }

    private String getIncludeOrExcludeReason() {
        if (!this.hasIncludes() && !this.hasExcludes()) {
            return "(default)";
        }
        if (this.hasIncludes() && !this.hasExcludes()) {
            return "(included)";
        }
        if (!this.hasIncludes() && this.hasExcludes()) {
            return "(excluded)";
        }
        return "(override)";
    }

    private boolean hasIncludes() {
        return this.include != null;
    }

    private boolean hasExcludes() {
        return this.exclude != null;
    }

    private static void readCandidates(File file, Set<String> candidates) throws IOException {
        String line;
        LineNumberReader input = new LineNumberReader(new FileReader(file));
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            candidates.add(line);
        }
        input.close();
    }

    private Map<String, Candidate> findCandidateClasses(Outline outline) {
        HashMap<String, Candidate> candidates = new HashMap<String, Candidate>();
        for (CClassInfo classInfo : outline.getModel().beans().values()) {
            CPropertyInfo property;
            String className = classInfo.fullName();
            if (classInfo.getProperties().size() != 1 || classInfo.getBaseClass() != null || !(property = (CPropertyInfo)classInfo.getProperties().get(0)).isCollection() || property.ref().size() != 1) continue;
            Candidate candidate = new Candidate(outline.getClazz((CClassInfo)classInfo).implClass, property);
            candidates.put(className, candidate);
            this.writeDebug("Candidate found: " + candidate.getClassName() + " [private " + candidate.getFieldType().name() + " " + candidate.getFieldName() + "]");
        }
        return candidates;
    }

    private static boolean isXmlRequired(JVar var) {
        for (JAnnotationUse annotation : var.annotations()) {
            if (!annotation.getAnnotationClass().name().equals("XmlElement")) continue;
            return annotation.getAnnotationMembers().containsKey("required");
        }
        return false;
    }

    private static String getXmlNamespace(JVar var) {
        for (JAnnotationUse annotation : var.annotations()) {
            if (!annotation.getAnnotationClass().name().equals("XmlElement")) continue;
            return XmlElementWrapperPlugin.getAnnotationMemberStringValue(annotation, "namespace");
        }
        return null;
    }

    private static final String getAnnotationMemberStringValue(JAnnotationUse annotation, String annotationMember) {
        JAnnotationValue annotationValue = (JAnnotationValue)annotation.getAnnotationMembers().get(annotationMember);
        if (annotationValue != null) {
            return XmlElementWrapperPlugin.getAnnotationStringValue(annotationValue);
        }
        return null;
    }

    private static final String getAnnotationStringValue(JAnnotationValue annotationValue) {
        StringWriter w = new StringWriter();
        annotationValue.generate(new JFormatter((Writer)w));
        return ((Object)w).toString().replace("\"", "");
    }

    private static boolean isListedAsParametrisation(JClass classToCheck, JType type) {
        return type instanceof JClass && ((JClass)type).getTypeParameters().contains(classToCheck);
    }

    private static boolean isPluralFormApplicable(FieldOutline field) {
        return applyPluralForm && field.getPropertyInfo().getCustomizations().isEmpty();
    }

    private void writeSummary(String s) {
        if (this.summary != null) {
            this.summary.println(s);
        }
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private void closeSummary() {
        if (this.summary != null) {
            this.summary.close();
        }
    }

    private void writeDebug(String s) {
        if (this.debugMode) {
            System.out.println("DEBUG:" + s);
        }
    }

    static String extractXmlElementName(CPropertyInfo property) {
        if (!(property instanceof CElementPropertyInfo)) {
            return null;
        }
        CElementPropertyInfo propertyInfo = (CElementPropertyInfo)property;
        if (propertyInfo.getTypes().isEmpty()) {
            return null;
        }
        return ((CTypeRef)propertyInfo.getTypes().get(0)).getTagName().getLocalPart();
    }

    private static class Candidate {
        private JDefinedClass clazz;
        private String fieldName;
        private JClass fieldType;
        private String xmlElementName = null;
        private boolean markedForRemoval = true;

        public Candidate(JDefinedClass clazz, CPropertyInfo property) {
            this.clazz = clazz;
            this.fieldName = property.getName(false);
            this.fieldType = (JClass)((JFieldVar)clazz.fields().get(this.fieldName)).type();
            this.xmlElementName = XmlElementWrapperPlugin.extractXmlElementName(property);
            if (this.xmlElementName == null) {
                this.xmlElementName = this.fieldName;
            }
        }

        public JDefinedClass getDefinedClass() {
            return this.clazz;
        }

        public String getClassName() {
            return this.clazz.fullName();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public JClass getFieldType() {
            return this.fieldType;
        }

        public String getXmlElementName() {
            return this.xmlElementName;
        }

        public boolean isMarkedForRemoval() {
            return this.markedForRemoval;
        }

        public void setMarkedForRemoval(boolean markedForRemoval) {
            this.markedForRemoval = markedForRemoval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Instantiation {
        EARLY,
        LAZY;

    }
}

