/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.xew;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtils {
    public static boolean isHiddenClass(JClass clazz) {
        return !(clazz instanceof JDefinedClass) || ((JDefinedClass)clazz).isHidden();
    }

    public static boolean isListedAsParametrisation(JClass classToCheck, JType type) {
        return type instanceof JClass && ((JClass)type).getTypeParameters().contains(classToCheck);
    }

    public static JAnnotationUse getAnnotation(JAnnotatable annotatable, JClass annotationClass) {
        for (JAnnotationUse annotation : annotatable.annotations()) {
            if (!annotation.getAnnotationClass().equals(annotationClass)) continue;
            return annotation;
        }
        return null;
    }

    public static JAnnotationValue getAnnotationMember(JAnnotationUse annotation, String annotationMember) {
        if (annotation == null) {
            return null;
        }
        Map memberValues = (Map)CommonUtils.getPrivateField(annotation, "memberValues");
        if (memberValues == null) {
            return null;
        }
        return (JAnnotationValue)memberValues.get(annotationMember);
    }

    public static JExpression getAnnotationMemberExpression(JAnnotationUse annotation, String annotationMember) {
        JAnnotationValue annotationValue = CommonUtils.getAnnotationMember(annotation, annotationMember);
        if (annotationValue == null) {
            return null;
        }
        try {
            return (JExpression)CommonUtils.getPrivateField(annotationValue, annotationValue.getClass(), "value");
        }
        catch (NoSuchFieldException e) {
            return JExpr.lit((String)CommonUtils.generableToString((JGenerable)annotationValue));
        }
    }

    public static void addAnnotation(JVar field, JAnnotationUse annotation) {
        ((List)CommonUtils.getPrivateField(field, "annotations")).add(annotation);
    }

    public static void removeAnnotation(JVar field, JAnnotationUse annotation) {
        ((List)CommonUtils.getPrivateField(field, "annotations")).remove(annotation);
    }

    public static boolean hasPropertyNameCustomization(CPropertyInfo fieldPropertyInfo) {
        XSAnnotation annotation = fieldPropertyInfo.getSchemaComponent().getAnnotation();
        if (annotation == null) {
            annotation = CommonUtils.getXsdDeclaration(fieldPropertyInfo).getAnnotation();
        }
        if (annotation == null || !(annotation.getAnnotation() instanceof BindInfo)) {
            return false;
        }
        for (BIDeclaration declaration : (BindInfo)annotation.getAnnotation()) {
            if (!(declaration instanceof BIProperty)) continue;
            return true;
        }
        return false;
    }

    public static final String generableToString(JGenerable generable) {
        StringWriter w = new StringWriter();
        generable.generate(new JFormatter((Writer)w));
        return ((Object)w).toString().replace("\"", "");
    }

    public static void setPrivateField(Object obj, String fieldName, Object newValue) {
        try {
            CommonUtils.setPrivateField(obj, obj.getClass(), fieldName, newValue);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setPrivateField(Object obj, Class<?> clazz, String fieldName, Object newValue) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, newValue);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() == Object.class) {
                throw e;
            }
            CommonUtils.setPrivateField(obj, clazz.getSuperclass(), fieldName, newValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getPrivateField(Object obj, String fieldName) {
        try {
            return CommonUtils.getPrivateField(obj, obj.getClass(), fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getPrivateField(Object obj, Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() == Object.class) {
                throw e;
            }
            return CommonUtils.getPrivateField(obj, clazz.getSuperclass(), fieldName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static XSDeclaration getXsdDeclaration(CPropertyInfo propertyInfo) {
        XSComponent schemaComponent = propertyInfo.getSchemaComponent();
        if (!(schemaComponent instanceof XSParticle)) {
            return null;
        }
        XSTerm term = ((XSParticle)schemaComponent).getTerm();
        if (!(term instanceof XSDeclaration)) {
            return null;
        }
        return (XSDeclaration)term;
    }
}

