/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.xew;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Cloneable {
    private Class<?> collectionImplClass = ArrayList.class;
    private Class<?> collectionInterfaceClass = List.class;
    private InstantiationMode instantiationMode = InstantiationMode.EARLY;
    private List<ControlEntry> controlList = new ArrayList<ControlEntry>();
    private boolean applyPluralForm = false;
    private final Log logger;

    public Configuration(Log logger) {
        this.logger = logger;
    }

    public Class<?> getCollectionImplClass() {
        return this.collectionImplClass;
    }

    public void setCollectionImplClass(Class<?> collectionImplClass) {
        this.collectionImplClass = collectionImplClass;
    }

    public Class<?> getCollectionInterfaceClass() {
        return this.collectionInterfaceClass;
    }

    public void setCollectionInterfaceClass(Class<?> collectionInterfaceClass) {
        this.collectionInterfaceClass = collectionInterfaceClass;
    }

    public InstantiationMode getInstantiationMode() {
        return this.instantiationMode;
    }

    public void setInstantiationMode(InstantiationMode instantiationMode) {
        this.instantiationMode = instantiationMode;
    }

    public boolean isApplyPluralForm() {
        return this.applyPluralForm;
    }

    public void setApplyPluralForm(boolean applyPluralForm) {
        this.applyPluralForm = applyPluralForm;
    }

    void readControlFile(String fileName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        this.controlList.clear();
        while ((line = reader.readLine()) != null) {
            ControlMode controlMode;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            int separatorIndex = line.indexOf(61);
            if (separatorIndex <= 0) {
                this.logger.warn((Object)("Control file line \"" + line + "\" is invalid as does not have '=' separator."));
                continue;
            }
            String className = line.substring(0, separatorIndex);
            try {
                controlMode = ControlMode.valueOf(line.substring(separatorIndex + 1).trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.logger.warn((Object)("Control file line \"" + line + "\" is invalid as control mode is unknown."));
                continue;
            }
            this.controlList.add(new ControlEntry(className.startsWith("/") && className.endsWith("/") && className.length() > 2 ? Pattern.compile(className.substring(1, className.length() - 1)) : Pattern.compile(className, 16), controlMode));
        }
        reader.close();
    }

    public boolean isClassIncluded(String className) {
        boolean inclusionForced = false;
        boolean exclusionForced = false;
        for (ControlEntry controlEntry : this.controlList) {
            if (!controlEntry.pattern.matcher(className).matches()) continue;
            switch (controlEntry.controlMode) {
                case INCLUDE: {
                    inclusionForced = true;
                    break;
                }
                case EXCLUDE: {
                    exclusionForced = true;
                    break;
                }
            }
        }
        if (inclusionForced) {
            return true;
        }
        return !exclusionForced;
    }

    public boolean isClassUnmarkedForRemoval(String className) {
        for (ControlEntry controlEntry : this.controlList) {
            if (!controlEntry.pattern.matcher(className).matches() || controlEntry.controlMode != ControlMode.KEEP) continue;
            return true;
        }
        return false;
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "[Configuration collectionImplClass:" + this.collectionImplClass.getName() + " collectionInterfaceClass:" + this.collectionInterfaceClass.getName() + " instantiationMode:" + (Object)((Object)this.instantiationMode) + " controlList:" + this.controlList + " applyPluralForm:" + this.applyPluralForm + "]";
    }

    private static class ControlEntry {
        Pattern pattern;
        ControlMode controlMode;

        ControlEntry(Pattern pattern, ControlMode controlMode) {
            this.pattern = pattern;
            this.controlMode = controlMode;
        }

        public String toString() {
            return "[ControlEntry " + this.pattern + "=" + (Object)((Object)this.controlMode) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlMode {
        EXCLUDE,
        INCLUDE,
        KEEP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstantiationMode {
        EARLY,
        LAZY,
        NONE;

    }
}

