/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.xew;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.addon.xew.CommonUtils;
import com.sun.tools.xjc.addon.xew.Configuration;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.api.impl.NameConverter;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSDeclaration;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementWrapperPlugin
extends AbstractParameterizablePlugin {
    private static final QName XEW_QNAME = new QName("http://github.com/jaxb-xew-plugin", "xew");
    private static final String PLUGIN_NAME = "Xxew";
    private static final String OPTION_NAME_CONTROL = "control";
    private static final String OPTION_NAME_SUMMARY = "summary";
    private static final String OPTION_NAME_COLLECTION = "collection";
    private static final String OPTION_NAME_COLLECTION_INTERFACE = "collectionInterface";
    private static final String OPTION_NAME_INSTANTIATE = "instantiate";
    private static final String OPTION_NAME_APPLY_PLURAL_FORM = "plural";
    private PrintWriter summary = null;
    private Map<String, String> globalOptions = new HashMap<String, String>();
    private JClass xmlElementDeclModelClass;
    private static final String FACTORY_CLASS_NAME = "ObjectFactory";
    static final String COMMONS_LOGGING_LOG_LEVEL_PROPERTY_KEY = "org.apache.commons.logging.simplelog.defaultlog";

    public XmlElementWrapperPlugin() {
        this.logger = null;
    }

    public String getOptionName() {
        return PLUGIN_NAME;
    }

    public String getUsage() {
        return "  " + XmlElementWrapperPlugin.getArgumentName("") + " Replace collection types with fields having the @XmlElementWrapper and @XmlElement annotations.";
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(XEW_QNAME);
    }

    void initLoggerIfNecessary(Options opts) {
        if (this.logger != null) {
            return;
        }
        if (System.getProperty(COMMONS_LOGGING_LOG_LEVEL_PROPERTY_KEY) == null) {
            String logLevel = "WARN";
            if (opts.quiet) {
                logLevel = "FATAL";
            } else if (opts.debugMode) {
                logLevel = "DEBUG";
            } else if (opts.verbose) {
                logLevel = "INFO";
            }
            System.setProperty(COMMONS_LOGGING_LOG_LEVEL_PROPERTY_KEY, logLevel);
        }
        LogFactory.getFactory().release();
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public void onActivated(Options opts) {
        this.initLoggerIfNecessary(opts);
    }

    private static String getArgumentName(String optionName) {
        return "-Xxew:" + optionName;
    }

    private int parseArgument(String[] args, int index, String optionName) {
        int recognized = 0;
        String arg = args[index];
        String argumentName = XmlElementWrapperPlugin.getArgumentName(optionName);
        if (arg.startsWith(argumentName)) {
            ++recognized;
            if (arg.length() > argumentName.length()) {
                this.globalOptions.put(optionName, arg.substring(argumentName.length()).trim());
            } else {
                this.globalOptions.put(optionName, args[index + 1].trim());
                ++recognized;
            }
        }
        return recognized;
    }

    private void applyConfigurationFromOptions(Configuration configuration, Map<String, String> options) throws IOException, ClassNotFoundException {
        for (Map.Entry<String, String> option : options.entrySet()) {
            if (OPTION_NAME_APPLY_PLURAL_FORM.equals(option.getKey())) {
                configuration.setApplyPluralForm(Boolean.parseBoolean(option.getValue()));
                continue;
            }
            if (OPTION_NAME_CONTROL.equals(option.getKey())) {
                configuration.readControlFile(option.getValue());
                continue;
            }
            if (OPTION_NAME_SUMMARY.equals(option.getKey())) {
                this.summary = new PrintWriter(new FileOutputStream(option.getValue()));
                continue;
            }
            if (OPTION_NAME_COLLECTION.equals(option.getKey())) {
                configuration.setCollectionImplClass(Class.forName(option.getValue()));
                continue;
            }
            if (OPTION_NAME_COLLECTION_INTERFACE.equals(option.getKey())) {
                configuration.setCollectionInterfaceClass(Class.forName(option.getValue()));
                continue;
            }
            if (OPTION_NAME_INSTANTIATE.equals(option.getKey())) {
                try {
                    configuration.setInstantiationMode(Configuration.InstantiationMode.valueOf(option.getValue().toUpperCase()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unknown instantiation mode \"" + option.getValue() + "\"");
                }
            }
            throw new IllegalArgumentException("Unknown option " + option.getKey());
        }
    }

    private Configuration applyConfigurationFromCustomizations(Configuration configuration, CCustomizations customizations) throws IOException, ClassNotFoundException {
        CPluginCustomization customization = customizations.find(XEW_QNAME.getNamespaceURI(), XEW_QNAME.getLocalPart());
        if (customization != null) {
            configuration = configuration.clone();
            customization.markAsAcknowledged();
            NamedNodeMap attributes = customization.element.getAttributes();
            HashMap<String, String> options = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNamespaceURI() != null) continue;
                options.put(attribute.getNodeName(), attribute.getNodeValue());
            }
            this.applyConfigurationFromOptions(configuration, options);
        }
        return configuration;
    }

    public int parseArgument(Options opts, String[] args, int i) throws BadCommandLineException {
        this.initLoggerIfNecessary(opts);
        int recognized = 0;
        String arg = args[i];
        this.logger.trace((Object)("Argument[" + i + "] = " + arg));
        if (arg.equals(XmlElementWrapperPlugin.getArgumentName(OPTION_NAME_APPLY_PLURAL_FORM))) {
            this.globalOptions.put(OPTION_NAME_APPLY_PLURAL_FORM, "true");
            return 1;
        }
        recognized = this.parseArgument(args, i, OPTION_NAME_CONTROL);
        if (recognized == 0 && (recognized = this.parseArgument(args, i, OPTION_NAME_SUMMARY)) == 0 && (recognized = this.parseArgument(args, i, OPTION_NAME_COLLECTION_INTERFACE)) == 0 && (recognized = this.parseArgument(args, i, OPTION_NAME_COLLECTION)) == 0 && (recognized = this.parseArgument(args, i, OPTION_NAME_INSTANTIATE)) == 0 && arg.startsWith(XmlElementWrapperPlugin.getArgumentName(""))) {
            throw new BadCommandLineException("Invalid argument " + arg);
        }
        return recognized;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        try {
            this.runInternal(outline);
            return true;
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to read the file", (Throwable)e);
            throw new SAXException(e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"Invalid class", (Throwable)e);
            throw new SAXException(e);
        }
    }

    private void runInternal(Outline outline) throws IOException, ClassNotFoundException {
        JCodeModel codeModel = outline.getCodeModel();
        JClass xmlElementWrapperModelClass = codeModel.ref(XmlElementWrapper.class);
        JClass xmlElementModelClass = codeModel.ref(XmlElement.class);
        JClass xmlAnyElementModelClass = codeModel.ref(XmlAnyElement.class);
        JClass xmlMixedModelClass = codeModel.ref(XmlMixed.class);
        JClass xmlElementRefModelClass = codeModel.ref(XmlElementRef.class);
        JClass xmlElementRefsModelClass = codeModel.ref(XmlElementRefs.class);
        JClass xmlElementsModelClass = codeModel.ref(XmlElements.class);
        JClass xmlJavaTypeAdapterModelClass = codeModel.ref(XmlJavaTypeAdapter.class);
        JClass xmlTypeModelClass = codeModel.ref(XmlType.class);
        this.xmlElementDeclModelClass = codeModel.ref(XmlElementDecl.class);
        this.logger.debug((Object)"JAXB Process Model (run)...");
        Configuration globalConfiguration = new Configuration(this.logger);
        this.applyConfigurationFromOptions(globalConfiguration, this.globalOptions);
        globalConfiguration = this.applyConfigurationFromCustomizations(globalConfiguration, CustomizationUtils.getCustomizations((Model)outline.getModel()));
        this.writeSummary("Compilation:");
        this.writeSummary("  JAXB version         : " + Options.getBuildID());
        this.writeSummary("  Control file         : " + (!this.globalOptions.containsKey(OPTION_NAME_CONTROL) ? "<none>" : this.globalOptions.get(OPTION_NAME_CONTROL)));
        this.writeSummary("  Summary file         : " + (!this.globalOptions.containsKey(OPTION_NAME_SUMMARY) ? "<none>" : this.globalOptions.get(OPTION_NAME_SUMMARY)));
        this.writeSummary("  Instantiation mode   : " + (Object)((Object)globalConfiguration.getInstantiationMode()));
        this.writeSummary("  Collection impl      : " + globalConfiguration.getCollectionImplClass().getName());
        this.writeSummary("  Collection interface : " + globalConfiguration.getCollectionInterfaceClass().getName());
        this.writeSummary("  Plural form          : " + globalConfiguration.isApplyPluralForm());
        this.writeSummary("");
        HashMap<String, Candidate> candidatesMap = new HashMap<String, Candidate>();
        this.writeSummary("Candidates:");
        for (Candidate candidate : this.findCandidateClasses(outline)) {
            if (globalConfiguration.isClassIncluded(candidate.getClassName())) {
                if (globalConfiguration.isClassUnmarkedForRemoval(candidate.getClassName())) {
                    candidate.unmarkForRemoval();
                    this.writeSummary("\t[!]: " + candidate.getClassName());
                } else {
                    this.writeSummary("\t[+]: " + candidate.getClassName());
                }
                candidatesMap.put(candidate.getClassName(), candidate);
                continue;
            }
            this.writeSummary("\t[-]: " + candidate.getClassName());
        }
        this.writeSummary("\t" + candidatesMap.size() + " candidate(s) being considered.");
        this.writeSummary("");
        this.writeSummary("Modifications:");
        int modificationCount = 0;
        for (ClassOutline outlineClass : outline.getClasses()) {
            JDefinedClass targetClass = outlineClass.implClass;
            Configuration classConfiguration = this.applyConfigurationFromCustomizations(globalConfiguration, CustomizationUtils.getCustomizations((ClassOutline)outlineClass));
            Candidate parentCandidate = (Candidate)candidatesMap.get(targetClass._extends().fullName());
            if (parentCandidate != null) {
                this.logger.debug((Object)("Candidate " + parentCandidate.getClassName() + " is a parent of " + targetClass.name() + " and hence won't be removed."));
                parentCandidate.unmarkForRemoval();
            }
            for (FieldOutline field : outlineClass.getDeclaredFields()) {
                JAnnotationUse adapterAnnotation;
                JExpression wrapperXmlNamespace;
                JExpression wrapperXmlNillable;
                if (!(field.getRawType() instanceof JClass)) continue;
                JClass fieldType = (JClass)field.getRawType();
                CPropertyInfo fieldPropertyInfo = field.getPropertyInfo();
                if (fieldPropertyInfo.kind() != PropertyKind.ELEMENT && fieldPropertyInfo.kind() != PropertyKind.REFERENCE) continue;
                String fieldName = fieldPropertyInfo.getName(false);
                Candidate candidate = null;
                for (Candidate c : candidatesMap.values()) {
                    if (fieldType.isAssignableFrom((JClass)c.getClazz()) && !CommonUtils.isHiddenClass(fieldType)) {
                        candidate = c;
                        break;
                    }
                    if (!CommonUtils.isListedAsParametrisation((JClass)c.getClazz(), (JType)fieldType)) continue;
                    this.logger.debug((Object)("Candidate " + c.getClassName() + " is listed as parametrisation of " + targetClass.fullName() + "#" + fieldName + " and hence won't be removed."));
                    c.unmarkForRemoval();
                }
                JFieldVar originalImplField = (JFieldVar)targetClass.fields().get(fieldName);
                if (candidate == null) {
                    this.checkAnnotationReference(candidatesMap, (JAnnotatable)originalImplField);
                    continue;
                }
                this.writeSummary("\tReplacing field [" + fieldType.name() + " " + targetClass.fullName() + "#" + fieldName + "]");
                candidate.incrementSubstitutions();
                ++modificationCount;
                if (this.moveInnerClassToParent(outline, candidate)) {
                    ++modificationCount;
                }
                Configuration fieldConfiguration = this.applyConfigurationFromCustomizations(classConfiguration, CustomizationUtils.getCustomizations((FieldOutline)field));
                List fieldTypeParametrisations = candidate.getFieldClass().getTypeParameters();
                JClass collectionInterfaceClass = codeModel.ref(fieldConfiguration.getCollectionInterfaceClass()).narrow(fieldTypeParametrisations);
                JClass collectionImplClass = codeModel.ref(fieldConfiguration.getCollectionImplClass()).narrow(fieldTypeParametrisations);
                boolean pluralFormWasApplied = false;
                if (fieldConfiguration.isApplyPluralForm() && !CommonUtils.hasPropertyNameCustomization(fieldPropertyInfo)) {
                    String oldFieldName = fieldName;
                    if ((fieldName = JJavaName.getPluralForm((String)fieldName)).startsWith("_") && JJavaName.isJavaIdentifier((String)fieldName.substring(1))) {
                        fieldName = fieldName.substring(1);
                    }
                    if (!fieldName.equals(oldFieldName)) {
                        pluralFormWasApplied = true;
                        originalImplField.name(fieldName);
                        fieldPropertyInfo.setName(false, fieldName);
                        JAnnotationArrayMember propOrderValue = (JAnnotationArrayMember)CommonUtils.getAnnotation((JAnnotatable)targetClass, xmlTypeModelClass).getAnnotationMembers().get("propOrder");
                        if (propOrderValue != null) {
                            for (JAnnotationValue annotationValue : propOrderValue.annotations()) {
                                if (!oldFieldName.equals(CommonUtils.generableToString((JGenerable)annotationValue))) continue;
                                CommonUtils.setPrivateField(annotationValue, "value", JExpr.lit((String)fieldName));
                                break;
                            }
                        }
                    }
                }
                originalImplField.type((JType)collectionInterfaceClass);
                if (fieldConfiguration.getInstantiationMode() == Configuration.InstantiationMode.EARLY) {
                    this.logger.debug((Object)"Applying EARLY instantiation...");
                    originalImplField.init((JExpression)JExpr._new((JClass)collectionImplClass));
                }
                JAnnotationUse xmlElementWrapperAnnotation = originalImplField.annotate(xmlElementWrapperModelClass);
                JAnnotationUse xmlElementOriginalAnnotation = CommonUtils.getAnnotation((JAnnotatable)originalImplField, xmlElementModelClass);
                JExpression wrapperXmlName = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "name");
                if (wrapperXmlName != null) {
                    xmlElementWrapperAnnotation.param("name", wrapperXmlName);
                } else if (fieldConfiguration.isApplyPluralForm()) {
                    xmlElementWrapperAnnotation.param("name", CommonUtils.getXsdDeclaration(fieldPropertyInfo).getName());
                }
                JExpression wrapperXmlRequired = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "required");
                if (wrapperXmlRequired != null) {
                    xmlElementWrapperAnnotation.param("required", wrapperXmlRequired);
                }
                if ((wrapperXmlNillable = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "nillable")) != null) {
                    xmlElementWrapperAnnotation.param("nillable", wrapperXmlNillable);
                }
                if ((wrapperXmlNamespace = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "namespace")) != null) {
                    xmlElementWrapperAnnotation.param("namespace", wrapperXmlNamespace);
                }
                if (xmlElementOriginalAnnotation != null) {
                    CommonUtils.removeAnnotation((JVar)originalImplField, xmlElementOriginalAnnotation);
                }
                boolean xmlElementInfoWasTransferred = false;
                for (JClass annotationModelClass : new JClass[]{xmlAnyElementModelClass, xmlMixedModelClass, xmlElementRefModelClass, xmlElementRefsModelClass, xmlElementsModelClass}) {
                    JAnnotationArrayMember annotationArrayMember;
                    JAnnotationUse annotation = CommonUtils.getAnnotation((JAnnotatable)candidate.getField(), annotationModelClass);
                    if (annotation == null) continue;
                    if (candidate.getFieldTargetNamespace() != null && (annotationArrayMember = (JAnnotationArrayMember)CommonUtils.getAnnotationMember(annotation, "value")) != null) {
                        for (JAnnotationUse subAnnotation : annotationArrayMember.annotations()) {
                            if (CommonUtils.getAnnotationMemberExpression(subAnnotation, "namespace") != null) continue;
                            subAnnotation.param("namespace", candidate.getFieldTargetNamespace());
                        }
                    }
                    xmlElementInfoWasTransferred = true;
                    CommonUtils.addAnnotation((JVar)originalImplField, annotation);
                }
                if (!xmlElementInfoWasTransferred) {
                    JAnnotationUse xmlElementAnnotation = originalImplField.annotate(xmlElementModelClass);
                    xmlElementOriginalAnnotation = CommonUtils.getAnnotation((JAnnotatable)candidate.getField(), xmlElementModelClass);
                    JExpression xmlName = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "name");
                    if (xmlName != null) {
                        xmlElementAnnotation.param("name", xmlName);
                    } else {
                        xmlElementAnnotation.param("name", candidate.getFieldName());
                    }
                    JExpression xmlNamespace = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "namespace");
                    if (xmlNamespace != null) {
                        xmlElementAnnotation.param("namespace", xmlNamespace);
                    } else if (candidate.getFieldTargetNamespace() != null) {
                        xmlElementAnnotation.param("namespace", candidate.getFieldTargetNamespace());
                    }
                    JExpression type = CommonUtils.getAnnotationMemberExpression(xmlElementOriginalAnnotation, "type");
                    if (type != null) {
                        xmlElementAnnotation.param("type", type);
                    }
                }
                if ((adapterAnnotation = CommonUtils.getAnnotation((JAnnotatable)candidate.getField(), xmlJavaTypeAdapterModelClass)) != null) {
                    CommonUtils.addAnnotation((JVar)originalImplField, adapterAnnotation);
                }
                String propertyName = fieldPropertyInfo.getName(true);
                JDefinedClass implementationInterface = null;
                Iterator iter = targetClass._implements();
                while (iter.hasNext()) {
                    JClass interfaceClass = (JClass)iter.next();
                    if (!(interfaceClass instanceof JDefinedClass) || !this.deleteSettersGetters((JDefinedClass)interfaceClass, propertyName)) continue;
                    implementationInterface = (JDefinedClass)interfaceClass;
                    break;
                }
                this.deleteSettersGetters(targetClass, propertyName);
                if (pluralFormWasApplied) {
                    propertyName = JJavaName.getPluralForm((String)propertyName);
                    fieldPropertyInfo.setName(true, propertyName);
                }
                JMethod getterMethod = targetClass.method(1, (JType)collectionInterfaceClass, "get" + propertyName);
                if (fieldConfiguration.getInstantiationMode() == Configuration.InstantiationMode.LAZY) {
                    this.logger.debug((Object)"Applying LAZY instantiation...");
                    getterMethod.body()._if(JExpr.ref((String)fieldName).eq(JExpr._null()))._then().assign((JAssignmentTarget)JExpr.ref((String)fieldName), (JExpression)JExpr._new((JClass)collectionImplClass));
                }
                getterMethod.body()._return((JExpression)JExpr.ref((String)fieldName));
                JMethod setterMethod = targetClass.method(1, (JType)codeModel.VOID, "set" + propertyName);
                setterMethod.body().assign((JAssignmentTarget)JExpr._this().ref(fieldName), (JExpression)setterMethod.param((JType)collectionInterfaceClass, fieldName));
                if (implementationInterface != null) {
                    this.writeSummary("\tCorrecting interface " + implementationInterface.fullName());
                    implementationInterface.method(1, (JType)collectionInterfaceClass, "get" + propertyName);
                    setterMethod = implementationInterface.method(1, (JType)codeModel.VOID, "set" + propertyName);
                    setterMethod.param((JType)collectionInterfaceClass, fieldName);
                }
                modificationCount += this.createScopedFactoryMethods(codeModel, candidate.getValueObjectFactoryClass(), candidate.getScopedElementInfos().values(), targetClass);
                if (!candidate.isValueObjectDisabled()) continue;
                modificationCount += this.createScopedFactoryMethods(codeModel, candidate.getObjectFactoryClass(), candidate.getScopedElementInfos().values(), targetClass);
            }
        }
        this.writeSummary("\t" + modificationCount + " modification(s) to original code.");
        this.writeSummary("");
        int deletionCount = this.deleteCandidates(outline, candidatesMap.values());
        this.writeSummary("\t" + deletionCount + " deletion(s) from original code.");
        this.writeSummary("");
        this.closeSummary();
        this.logger.debug((Object)"Done");
    }

    private boolean moveInnerClassToParent(Outline outline, Candidate candidate) {
        if (candidate.getFieldParametrisationClass() == null) {
            return false;
        }
        JDefinedClass fieldParametrisationImpl = candidate.getFieldParametrisationImpl();
        if (candidate.getClazz() != fieldParametrisationImpl.parentContainer()) {
            return false;
        }
        JDefinedClass fieldParametrisationClass = candidate.getFieldParametrisationClass();
        String oldFactoryMethodName = fieldParametrisationClass.outer().name() + fieldParametrisationClass.name();
        this.moveClassLevelUp(outline, fieldParametrisationImpl);
        this.renameFactoryMethod(fieldParametrisationImpl._package()._getClass(FACTORY_CLASS_NAME), oldFactoryMethodName, fieldParametrisationClass.name());
        if (candidate.isValueObjectDisabled()) {
            this.moveClassLevelUp(outline, fieldParametrisationClass);
            this.renameFactoryMethod(fieldParametrisationClass._package()._getClass(FACTORY_CLASS_NAME), oldFactoryMethodName, fieldParametrisationClass.name());
        }
        return true;
    }

    private int createScopedFactoryMethods(JCodeModel codeModel, JDefinedClass factoryClass, Collection<ScopedElementInfo> scopedElementInfos, JDefinedClass targetClass) {
        int createdMethods = 0;
        block0: for (ScopedElementInfo info : scopedElementInfos) {
            String dotClazz = targetClass.fullName() + ".class";
            for (JMethod method : factoryClass.methods()) {
                JAnnotationUse xmlElementDeclAnnotation = CommonUtils.getAnnotation((JAnnotatable)method, this.xmlElementDeclModelClass);
                JExpression scope = CommonUtils.getAnnotationMemberExpression(xmlElementDeclAnnotation, "scope");
                JExpression name = CommonUtils.getAnnotationMemberExpression(xmlElementDeclAnnotation, "name");
                if (scope == null || !dotClazz.equals(CommonUtils.generableToString((JGenerable)scope)) || !CommonUtils.generableToString((JGenerable)info.name).equals(CommonUtils.generableToString((JGenerable)name))) continue;
                continue block0;
            }
            StringBuilder methodName = new StringBuilder();
            JDefinedClass container = targetClass;
            while (true) {
                methodName.insert(0, container.name());
                if (!container.parentContainer().isClass()) break;
                container = (JDefinedClass)container.parentContainer();
            }
            methodName.insert(0, "create").append(NameConverter.standard.toPropertyName(CommonUtils.generableToString((JGenerable)info.name)));
            JClass wrapperType = codeModel.ref(JAXBElement.class).narrow(info.type);
            JMethod method = factoryClass.method(1, (JType)wrapperType, methodName.toString());
            method.annotate(this.xmlElementDeclModelClass).param("namespace", info.namespace).param("name", info.name).param("scope", (JType)targetClass);
            JInvocation qname = JExpr._new((JClass)codeModel.ref(QName.class)).arg(info.namespace).arg(info.name);
            method.body()._return((JExpression)JExpr._new((JClass)wrapperType).arg((JExpression)qname).arg(info.type.boxify().dotclass()).arg(targetClass.dotclass()).arg((JExpression)method.param(info.type, "value")));
            ++createdMethods;
        }
        return createdMethods;
    }

    private Collection<Candidate> findCandidateClasses(Outline outline) {
        HashMap<String, ClassOutline> interfaceImplementations = new HashMap<String, ClassOutline>();
        for (ClassOutline classOutline : outline.getClasses()) {
            Iterator iter = classOutline.implClass._implements();
            while (iter.hasNext()) {
                JClass interfaceClass = (JClass)iter.next();
                if (!(interfaceClass instanceof JDefinedClass)) continue;
                interfaceImplementations.put(interfaceClass.fullName(), classOutline);
            }
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        JClass collectionModelClass = outline.getCodeModel().ref(Collection.class);
        JClass xmlSchemaModelClass = outline.getCodeModel().ref(XmlSchema.class);
        for (ClassOutline classOutline : outline.getClasses()) {
            JClass interfaceClass;
            JClass fieldType;
            JDefinedClass candidateClass = classOutline.implClass;
            if (!CommonUtils.isHiddenClass(candidateClass._extends())) continue;
            JFieldVar field = null;
            for (JFieldVar f : candidateClass.fields().values()) {
                if ((f.mods().getValue() & 0x10) == 16) continue;
                if (field != null) {
                    field = null;
                    break;
                }
                field = f;
            }
            if (field == null || !(field.type() instanceof JClass) || !collectionModelClass.isAssignableFrom(fieldType = (JClass)field.type())) continue;
            List fieldParametrisations = fieldType.getTypeParameters();
            assert (fieldParametrisations.size() == 1);
            JDefinedClass fieldParametrisationClass = null;
            JDefinedClass fieldParametrisationImpl = null;
            if (fieldParametrisations.get(0) instanceof JDefinedClass) {
                fieldParametrisationClass = (JDefinedClass)fieldParametrisations.get(0);
                ClassOutline fieldParametrisationClassOutline = (ClassOutline)interfaceImplementations.get(fieldParametrisationClass.fullName());
                if (fieldParametrisationClassOutline != null) {
                    assert (fieldParametrisationClassOutline.ref == fieldParametrisationClass);
                    fieldParametrisationImpl = fieldParametrisationClassOutline.implClass;
                } else {
                    fieldParametrisationImpl = fieldParametrisationClass;
                }
            }
            JDefinedClass objectFactoryClass = null;
            Iterator iter = candidateClass._implements();
            while (iter.hasNext() && (CommonUtils.isHiddenClass(interfaceClass = (JClass)iter.next()) || (objectFactoryClass = interfaceClass._package()._getClass(FACTORY_CLASS_NAME)) == null)) {
            }
            JDefinedClass valueObjectFactoryClass = candidateClass._package()._getClass(FACTORY_CLASS_NAME);
            assert (objectFactoryClass != valueObjectFactoryClass);
            String fieldTargetNamespace = null;
            XSDeclaration xsdDeclaration = CommonUtils.getXsdDeclaration(classOutline.target.getProperty(field.name()));
            if (xsdDeclaration != null && !xsdDeclaration.getTargetNamespace().isEmpty()) {
                fieldTargetNamespace = xsdDeclaration.getTargetNamespace();
            } else {
                JExpression packageWideNamespace;
                JAnnotationUse schemaAnnotation = CommonUtils.getAnnotation((JAnnotatable)(objectFactoryClass != null ? objectFactoryClass : valueObjectFactoryClass).getPackage(), xmlSchemaModelClass);
                JExpression elementFormDefault = CommonUtils.getAnnotationMemberExpression(schemaAnnotation, "elementFormDefault");
                if (elementFormDefault != null && CommonUtils.generableToString((JGenerable)elementFormDefault).endsWith(".QUALIFIED") && (packageWideNamespace = CommonUtils.getAnnotationMemberExpression(schemaAnnotation, "namespace")) != null) {
                    fieldTargetNamespace = CommonUtils.generableToString((JGenerable)packageWideNamespace);
                }
            }
            Candidate candidate = new Candidate(candidateClass, field, fieldTargetNamespace, fieldParametrisationClass, fieldParametrisationImpl, objectFactoryClass, valueObjectFactoryClass, this.xmlElementDeclModelClass);
            candidates.add(candidate);
            this.logger.debug((Object)("Found " + candidate));
        }
        return candidates;
    }

    private int deleteCandidates(Outline outline, Collection<Candidate> candidates) {
        int deletionCount = 0;
        this.writeSummary("Deletions:");
        for (Candidate candidate : candidates) {
            if (!candidate.canBeRemoved()) continue;
            JDefinedClass candidateClass = candidate.getClazz();
            deletionCount += this.deleteFactoryMethod(candidate.getValueObjectFactoryClass(), candidate);
            this.deleteClass(outline, candidateClass);
            ++deletionCount;
            if (!candidate.isValueObjectDisabled()) continue;
            deletionCount += this.deleteFactoryMethod(candidate.getObjectFactoryClass(), candidate);
            Iterator iter = candidateClass._implements();
            while (iter.hasNext()) {
                JClass interfaceClass = (JClass)iter.next();
                if (CommonUtils.isHiddenClass(interfaceClass)) continue;
                this.deleteClass(outline, (JDefinedClass)interfaceClass);
                ++deletionCount;
            }
        }
        return deletionCount;
    }

    private void renameFactoryMethod(JDefinedClass factoryClass, String oldMethodName, String newMethodName) {
        for (JMethod method : factoryClass.methods()) {
            String methodName = method.name();
            if (!methodName.contains(oldMethodName)) continue;
            method.name(methodName.replace(oldMethodName, newMethodName));
            this.writeSummary("\tRenamed " + methodName + " -> " + method.name() + " in " + factoryClass.fullName());
        }
    }

    private int deleteFactoryMethod(JDefinedClass factoryClass, Candidate candidate) {
        int deletedMethods = 0;
        Iterator iter = factoryClass.methods().iterator();
        while (iter.hasNext()) {
            JMethod method = (JMethod)iter.next();
            if ((!(method.type() instanceof JDefinedClass) || !((JDefinedClass)method.type()).isAssignableFrom((JClass)candidate.getClazz())) && !CommonUtils.isListedAsParametrisation((JClass)candidate.getClazz(), method.type()) && !candidate.getScopedElementInfos().containsKey(method.name())) continue;
            this.writeSummary("\tRemoving factory method [" + method.type().fullName() + "#" + method.name() + "()] from " + factoryClass.fullName());
            iter.remove();
            ++deletedMethods;
        }
        return deletedMethods;
    }

    private boolean deleteSettersGetters(JDefinedClass clazz, String fieldPublicName) {
        boolean result = false;
        Iterator iter = clazz.methods().iterator();
        while (iter.hasNext()) {
            JMethod m = (JMethod)iter.next();
            if (!m.name().equals("set" + fieldPublicName) && !m.name().equals("get" + fieldPublicName)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    private void moveClassLevelUp(Outline outline, JDefinedClass clazz) {
        Map classes;
        JDefinedClass parent = (JDefinedClass)clazz.parentContainer();
        JClassContainer grandParent = parent.parentContainer();
        if (grandParent.isClass()) {
            JDefinedClass grandParentClass = (JDefinedClass)grandParent;
            this.writeSummary("\tMoving inner class " + clazz.fullName() + " to class " + grandParentClass.fullName());
            classes = (Map)CommonUtils.getPrivateField(grandParentClass, "classes");
        } else {
            JPackage grandParentPackage = (JPackage)grandParent;
            this.writeSummary("\tMoving inner class " + clazz.fullName() + " to package " + grandParentPackage.name());
            classes = (Map)CommonUtils.getPrivateField(grandParentPackage, "classes");
            CommonUtils.setPrivateField(clazz.mods(), "mods", clazz.mods().getValue() & 0xFFFFFFEF);
            for (ClassOutline classOutline : outline.getClasses()) {
                if (classOutline.implClass != clazz) continue;
                XSComponent sc = classOutline.target.getSchemaComponent();
                assert (sc instanceof XSDeclaration && ((XSDeclaration)sc).isLocal());
                CommonUtils.setPrivateField(sc, "anonymous", Boolean.FALSE);
                break;
            }
        }
        if (classes.containsKey(clazz.name())) {
            this.writeSummary("\tRenaming class " + clazz.fullName() + " to class " + parent.name() + clazz.name());
            CommonUtils.setPrivateField(clazz, "name", parent.name() + clazz.name());
        }
        classes.put(clazz.name(), clazz);
        CommonUtils.setPrivateField(clazz, "outer", grandParent);
    }

    private void deleteClass(Outline outline, JDefinedClass clazz) {
        if (clazz.parentContainer().isClass()) {
            JDefinedClass parentClass = (JDefinedClass)clazz.parentContainer();
            this.writeSummary("\tRemoving class " + clazz.fullName() + " from class " + parentClass.fullName());
            Iterator iter = parentClass.classes();
            while (iter.hasNext()) {
                if (!((JDefinedClass)iter.next()).equals(clazz)) continue;
                iter.remove();
                break;
            }
        } else {
            JPackage parentPackage = (JPackage)clazz.parentContainer();
            this.writeSummary("\tRemoving class " + clazz.fullName() + " from package " + parentPackage.name());
            parentPackage.remove((JClass)clazz);
            Iterator iter = outline.getClasses().iterator();
            while (iter.hasNext()) {
                ClassOutline classOutline = (ClassOutline)iter.next();
                if (classOutline.implClass != clazz) continue;
                outline.getModel().beans().remove(classOutline.target);
                iter.remove();
                break;
            }
        }
    }

    private static boolean isAnnotationContainer(JAnnotationUse annotation) {
        String annotationClassName = annotation.getAnnotationClass().name();
        return annotationClassName.equals("XmlElementRefs") || annotationClassName.equals("XmlElements");
    }

    private void checkAnnotationReference(Map<String, Candidate> candidatesMap, JAnnotatable annotatable) {
        for (JAnnotationUse annotation : annotatable.annotations()) {
            Candidate candidate;
            JAnnotationValue annotationMember = CommonUtils.getAnnotationMember(annotation, "value");
            if (annotationMember instanceof JAnnotationArrayMember) {
                this.checkAnnotationReference(candidatesMap, (JAnnotatable)((JAnnotationArrayMember)annotationMember));
                continue;
            }
            JExpression type = CommonUtils.getAnnotationMemberExpression(annotation, "type");
            if (type == null || (candidate = candidatesMap.get(CommonUtils.generableToString((JGenerable)type).replace(".class", ""))) == null) continue;
            this.logger.debug((Object)("Candidate " + candidate.getClassName() + " is used in XmlElements/XmlElementRef and hence won't be removed."));
            candidate.unmarkForRemoval();
        }
    }

    private void writeSummary(String s) {
        if (this.summary != null) {
            this.summary.println(s);
        }
        this.logger.info((Object)s);
    }

    private void closeSummary() {
        if (this.summary != null) {
            this.summary.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Candidate {
        private final JDefinedClass candidateClass;
        private final JFieldVar field;
        private final String fieldTargetNamespace;
        private final JDefinedClass fieldParametrisationClass;
        private final JDefinedClass fieldParametrisationImpl;
        private final JDefinedClass objectFactoryClass;
        private final JDefinedClass valueObjectFactoryClass;
        private final Map<String, ScopedElementInfo> scopedElementInfos = new HashMap<String, ScopedElementInfo>();
        private boolean markedForRemoval = true;
        private int substitutionsCount;

        Candidate(JDefinedClass candidateClass, JFieldVar field, String fieldTargetNamespace, JDefinedClass fieldParametrizationClass, JDefinedClass fieldParametrisationImpl, JDefinedClass objectFactoryClass, JDefinedClass valueObjectFactoryClass, JClass xmlElementDeclModelClass) {
            this.candidateClass = candidateClass;
            this.field = field;
            this.fieldTargetNamespace = fieldTargetNamespace;
            this.fieldParametrisationClass = fieldParametrizationClass;
            this.fieldParametrisationImpl = fieldParametrisationImpl;
            this.objectFactoryClass = objectFactoryClass;
            this.valueObjectFactoryClass = valueObjectFactoryClass;
            String dotClazz = candidateClass.fullName() + ".class";
            for (JMethod method : valueObjectFactoryClass.methods()) {
                JAnnotationUse xmlElementDeclAnnotation = CommonUtils.getAnnotation((JAnnotatable)method, xmlElementDeclModelClass);
                JExpression scope = CommonUtils.getAnnotationMemberExpression(xmlElementDeclAnnotation, "scope");
                if (scope == null || !dotClazz.equals(CommonUtils.generableToString((JGenerable)scope))) continue;
                this.scopedElementInfos.put(method.name(), new ScopedElementInfo(CommonUtils.getAnnotationMemberExpression(xmlElementDeclAnnotation, "name"), CommonUtils.getAnnotationMemberExpression(xmlElementDeclAnnotation, "namespace"), ((JVar)method.params().get(0)).type()));
            }
        }

        public JDefinedClass getClazz() {
            return this.candidateClass;
        }

        public String getClassName() {
            return this.candidateClass.fullName();
        }

        public JFieldVar getField() {
            return this.field;
        }

        public String getFieldName() {
            return this.field.name();
        }

        public JClass getFieldClass() {
            return (JClass)this.field.type();
        }

        public String getFieldTargetNamespace() {
            return this.fieldTargetNamespace;
        }

        public JDefinedClass getFieldParametrisationClass() {
            return this.fieldParametrisationClass;
        }

        public JDefinedClass getFieldParametrisationImpl() {
            return this.fieldParametrisationImpl;
        }

        public Map<String, ScopedElementInfo> getScopedElementInfos() {
            return this.scopedElementInfos;
        }

        public JDefinedClass getObjectFactoryClass() {
            return this.objectFactoryClass;
        }

        public JDefinedClass getValueObjectFactoryClass() {
            return this.valueObjectFactoryClass;
        }

        public boolean isValueObjectDisabled() {
            return this.objectFactoryClass != null;
        }

        public boolean canBeRemoved() {
            return this.markedForRemoval && this.substitutionsCount > 0;
        }

        public void incrementSubstitutions() {
            ++this.substitutionsCount;
        }

        public void unmarkForRemoval() {
            this.markedForRemoval = false;
        }

        public String toString() {
            return "Candidate[" + this.getClassName() + " field " + this.getFieldClass().name() + " " + this.getFieldName() + "]";
        }
    }

    private static class ScopedElementInfo {
        public JExpression name;
        public JExpression namespace;
        public JType type;

        public ScopedElementInfo(JExpression name, JExpression namespace, JType type) {
            this.name = name;
            this.namespace = namespace;
            this.type = type;
        }

        public String toString() {
            return "[ScopedElementInfo name:" + this.name + " namespace:" + this.namespace + " type:" + this.type + "]";
        }
    }
}

