/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

class CUBRIDBlobOutputStream
extends OutputStream {
    private CUBRIDBlob blob;
    private long lob_pos;

    CUBRIDBlobOutputStream(CUBRIDBlob blob, long pos) {
        this.blob = blob;
        this.lob_pos = pos;
    }

    public synchronized void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.blob == null) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.lob_pos += (long)this.blob.setBytes(this.lob_pos, b, off, len);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.blob.removeFlushableStream(this);
        this.blob = null;
    }
}

