/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class CUBRIDClobInputStream
extends InputStream {
    private CUBRIDClob clob;
    private long lob_pos;
    private long lob_length;

    CUBRIDClobInputStream(CUBRIDClob clob) throws SQLException {
        this.clob = clob;
        this.lob_pos = 1L;
        this.lob_length = clob.getLobHandle().getLobSize();
    }

    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == 1) {
            return 0xFF & b[0];
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int read_len;
        if (this.clob == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (this.lob_pos - 1L + (long)len > this.lob_length && (len = (int)(this.lob_length - this.lob_pos + 1L)) < 0) {
                len = 0;
            }
            byte[] buf = this.clob.getBytes(this.lob_pos, len);
            System.arraycopy(buf, 0, b, off, buf.length);
            read_len = buf.length;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        this.lob_pos += (long)read_len;
        if (read_len < len || this.lob_pos > this.lob_length) {
            this.clob = null;
        }
        return read_len;
    }

    public synchronized long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.clob == null) {
            return 0L;
        }
        long lob_remains_len = this.lob_length - this.lob_pos + 1L;
        if (n > lob_remains_len) {
            n = lob_remains_len;
            this.clob = null;
        }
        this.lob_pos += n;
        return n;
    }

    public synchronized void close() throws IOException {
        this.clob = null;
    }
}

