/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDCallableStatement;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDConnectionKey;
import cubrid.jdbc.driver.CUBRIDDatabaseMetaData;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDOutResultSet;
import cubrid.jdbc.driver.CUBRIDPreparedStatement;
import cubrid.jdbc.driver.CUBRIDShardMetaData;
import cubrid.jdbc.driver.CUBRIDStatement;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UStatement;
import java.io.UnsupportedEncodingException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDConnection
implements Connection {
    public static final int TRAN_REP_CLASS_REP_INSTANCE = 4;
    public static final int TRAN_REP_CLASS_COMMIT_INSTANCE = 16;
    public static final int TRAN_REP_CLASS_UNCOMMIT_INSTANCE = 32;
    public static final int TRAN_COMMIT_CLASS_COMMIT_INSTANCE = 2;
    public static final int TRAN_COMMIT_CLASS_UNCOMMIT_INSTANCE = 1;
    public static final int TRAN_SERIALIZABLE = 8;
    public static final int CAS_CHANGE_MODE_AUTO = 1;
    public static final int CAS_CHANGE_MODE_KEEP = 2;
    UConnection u_con;
    String user;
    String url;
    protected boolean is_closed;
    protected boolean auto_commit;
    protected int holdability;
    private UError error;
    private boolean ending;
    private ArrayList<Statement> statements;
    private CUBRIDDatabaseMetaData mdata;
    private CUBRIDShardMetaData shard_mdata;
    private boolean isServerSideJdbc;
    private ArrayList<CUBRIDOutResultSet> outRs;
    private boolean isAutoGeneratedKeys = false;

    protected CUBRIDConnection(UConnection u, String r, String s) {
        this.u_con = u;
        this.u_con.setCUBRIDConnection(this);
        this.url = r;
        this.user = s;
        this.is_closed = false;
        this.auto_commit = true;
        this.holdability = 1;
        this.error = null;
        this.mdata = null;
        this.ending = false;
        this.statements = new ArrayList();
        this.outRs = new ArrayList();
        this.isServerSideJdbc = false;
        this.shard_mdata = null;
    }

    public CUBRIDConnection(UConnection u, String r, String s, boolean isServerSideJdbc) {
        this(u, r, s);
        if (isServerSideJdbc) {
            this.auto_commit = false;
            this.isServerSideJdbc = true;
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getName());
        str.append(String.format("(%s:%d, %d, %d)", this.u_con.CASIp, this.u_con.CASPort, this.u_con.casId, this.u_con.processId));
        return str.toString();
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepare(sql, 1003, 1007, this.holdability, 2);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkIsOpen();
        UStatement us = this.prepare(sql, (byte)64);
        CUBRIDCallableStatement cstmt = new CUBRIDCallableStatement(this, us);
        this.addStatement(cstmt);
        return cstmt;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIsOpen();
        if (!this.isServerSideJdbc) {
            if (this.auto_commit != autoCommit) {
                this.commit();
            }
            this.auto_commit = autoCommit;
            this.u_con.setAutoCommit(autoCommit);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkIsOpen();
        return this.auto_commit;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkIsOpen();
        if (this.ending) {
            return;
        }
        this.ending = true;
        if (!this.isServerSideJdbc) {
            this.completeStatementForCommit();
            try {
                this.end(true);
            }
            finally {
                this.ending = false;
            }
        }
        this.ending = false;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkIsOpen();
        if (this.ending) {
            return;
        }
        this.ending = true;
        if (!this.isServerSideJdbc) {
            this.completeAllStatements();
            try {
                this.end(false);
            }
            finally {
                this.ending = false;
            }
        }
        this.ending = false;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.clear();
        this.is_closed = true;
        this.u_con.close();
        this.u_con = null;
        this.url = null;
        this.user = null;
        this.mdata = null;
        this.statements = null;
        this.error = null;
        this.shard_mdata = null;
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.is_closed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.mdata != null) {
            return this.mdata;
        }
        this.mdata = new CUBRIDDatabaseMetaData(this);
        return this.mdata;
    }

    public synchronized CUBRIDShardMetaData getShardMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.shard_mdata != null) {
            return this.shard_mdata;
        }
        this.shard_mdata = new CUBRIDShardMetaData(this);
        return this.shard_mdata;
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        int uni_level;
        this.checkIsOpen();
        this.commit();
        switch (level) {
            case 2: {
                uni_level = 4;
                break;
            }
            case 1: {
                uni_level = 3;
                break;
            }
            case 4: {
                uni_level = 5;
                break;
            }
            case 8: {
                uni_level = 6;
                break;
            }
            case 16: {
                uni_level = 4;
                break;
            }
            case 32: {
                uni_level = 3;
                break;
            }
            default: {
                throw this.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_trans_iso_level, null);
            }
        }
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            this.u_con.setIsolationLevel(uni_level);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkIsOpen();
        int uni_level = 0;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            uni_level = this.u_con.getIsolationLevel();
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
        switch (uni_level) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 6: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIsOpen();
        CUBRIDStatement stmt = new CUBRIDStatement(this, resultSetType, resultSetConcurrency, this.holdability);
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepare(sql, resultSetType, resultSetConcurrency, this.holdability, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Statement createStatement(int type, int concur, int holdable) throws SQLException {
        this.checkIsOpen();
        if (holdable == 1 && (type == 1005 || concur == 1008)) {
            throw new UnsupportedOperationException();
        }
        CUBRIDStatement stmt = new CUBRIDStatement(this, type, concur, holdable);
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkIsOpen();
        if (this.holdability == 1) {
            if (this.u_con.supportHoldableResult()) {
                return 1;
            }
            return 2;
        }
        return this.holdability;
    }

    @Override
    public CallableStatement prepareCall(String sql, int type, int concur, int holdable) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepare(sql, 1003, 1007, this.holdability, autoGeneratedKeys);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int type, int concur, int holdable) throws SQLException {
        if (holdable == 1 && (type == 1005 || concur == 1008)) {
            throw new UnsupportedOperationException();
        }
        return this.prepare(sql, type, concur, holdable, 2);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] indexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] colName) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setHoldability(int holdable) throws SQLException {
        this.checkIsOpen();
        this.holdability = holdable;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setCharset(String charsetName) throws UnsupportedEncodingException {
        this.u_con.setCharset(charsetName);
    }

    public synchronized CUBRIDConnectionKey Login(String SignedData) throws SQLException {
        return null;
    }

    public synchronized CUBRIDConnectionKey Login(byte[] SignedData) throws SQLException {
        return null;
    }

    public void Logout() {
    }

    public void SetSignedConnection() {
    }

    public synchronized UConnection getUConnection() throws SQLException {
        this.checkIsOpen();
        return this.u_con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLockTimeout(int timeout) throws SQLException {
        this.checkIsOpen();
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            this.u_con.setLockTimeout(timeout);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int setCASChangeMode(int mode) throws SQLException {
        int prev_mode = 0;
        this.checkIsOpen();
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            if (mode != 1 && mode != 2) {
                throw this.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
            }
            prev_mode = this.u_con.setCASChangeMode(mode);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
        return prev_mode;
    }

    public void setAutoGeneratedKeys(boolean isGeneratedKeys) {
        this.isAutoGeneratedKeys = isGeneratedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UStatement prepare(String sql, byte prepareFlag) throws SQLException {
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            this.u_con.setBeginTime();
            us = this.u_con.prepare(sql, prepareFlag);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                return us;
            }
        }
        UError cpErr = new UError(this.error);
        this.autoRollback();
        throw this.createCUBRIDException(cpErr);
    }

    void autoCommit() throws SQLException {
        this.checkIsOpen();
        if (this.auto_commit) {
            this.commit();
        }
    }

    void autoRollback() throws SQLException {
        this.checkIsOpen();
        if (this.auto_commit) {
            this.rollback();
        }
    }

    synchronized void closeConnection() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.clear();
        this.is_closed = true;
    }

    synchronized void removeStatement(Statement s) throws SQLException {
        int i = this.statements.indexOf(s);
        if (i > -1) {
            this.statements.remove(i);
        }
    }

    private void clear() throws SQLException {
        this.closeAllStatements();
        this.closeAllOutResultSet();
        if (this.mdata != null) {
            this.mdata.close();
        }
        this.mdata = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw this.createCUBRIDException(CUBRIDJDBCErrorCode.connection_closed, null);
        }
    }

    private void addStatement(Statement s) throws SQLException {
        this.statements.add(s);
        if (this.u_con.getQueryTimeout() >= 0) {
            s.setQueryTimeout(this.u_con.getQueryTimeout());
        }
    }

    private void completeStatementForCommit() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            CUBRIDStatement stmt = (CUBRIDStatement)this.statements.get(i);
            if (stmt.getHoldability() == 1) {
                stmt.setCurrentTransaction(false);
                continue;
            }
            if (stmt instanceof CUBRIDPreparedStatement) {
                this.statements.remove(i);
                if (this.u_con.brokerInfoStatementPooling()) {
                    stmt.complete();
                    continue;
                }
                stmt.close();
                continue;
            }
            stmt.complete();
        }
    }

    private void completeAllStatements() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            CUBRIDStatement stmt = (CUBRIDStatement)this.statements.get(i);
            if (stmt.getHoldability() == 1 && !stmt.isFromCurrentTransaction()) continue;
            if (stmt instanceof CUBRIDPreparedStatement) {
                this.statements.remove(i);
                if (this.u_con.brokerInfoStatementPooling()) {
                    stmt.complete();
                    continue;
                }
                stmt.close();
                continue;
            }
            stmt.complete();
        }
    }

    private void closeAllStatements() throws SQLException {
        Object[] stmts = this.statements.toArray();
        for (int i = 0; i < stmts.length; ++i) {
            CUBRIDStatement stmt = (CUBRIDStatement)stmts[i];
            stmt.close();
        }
        this.statements.clear();
    }

    private void closeAllOutResultSet() throws SQLException {
        for (int i = 0; i < this.outRs.size(); ++i) {
            CUBRIDOutResultSet rs = this.outRs.get(i);
            rs.close();
        }
        this.outRs.clear();
    }

    public void addOutResultSet(CUBRIDOutResultSet rs) {
        this.outRs.add(rs);
    }

    @Override
    public Blob createBlob() throws SQLException {
        CUBRIDBlob blob = new CUBRIDBlob(this);
        return blob;
    }

    @Override
    public Clob createClob() throws SQLException {
        CUBRIDClob clob = new CUBRIDClob(this, this.getUConnection().getCharset());
        return clob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(boolean commit) throws SQLException {
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            if (this.isAutoGeneratedKeys) {
                this.u_con.turnOnAutoCommitBySelf();
            }
            this.u_con.endTransaction(commit);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
    }

    private PreparedStatement prepare(String sql, int resultSetType, int resultSetConcurrency, int resultHoldability, int autoGeneratedKeys) throws SQLException {
        this.checkIsOpen();
        int prepareFlag = 0;
        if (resultSetType == 1005 || resultSetConcurrency == 1008) {
            prepareFlag = 2;
        }
        if (resultHoldability == 1 && this.u_con.supportHoldableResult()) {
            prepareFlag = 8;
        }
        UStatement us = this.prepare(sql, (byte)prepareFlag);
        CUBRIDPreparedStatement pstmt = new CUBRIDPreparedStatement(this, us, resultSetType, resultSetConcurrency, resultHoldability, autoGeneratedKeys);
        this.addStatement(pstmt);
        return pstmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] lobNew(int lobType) throws SQLException {
        this.checkIsOpen();
        byte[] packedLobHandle = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            packedLobHandle = this.u_con.lobNew(lobType);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
        return packedLobHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int lobWrite(byte[] packedLobHandle, long offset, byte[] buf, int start, int len) throws SQLException {
        int result;
        this.checkIsOpen();
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            result = this.u_con.lobWrite(packedLobHandle, offset, buf, start, len);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int lobRead(byte[] packedLobHandle, long offset, byte[] buf, int start, int len) throws SQLException {
        int result;
        this.checkIsOpen();
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            result = this.u_con.lobRead(packedLobHandle, offset, buf, start, len);
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.createCUBRIDException(this.error);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getShardId() {
        int lastShardId;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            lastShardId = this.u_con.getShardId();
        }
        return lastShardId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isShard() {
        boolean isShard;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            isShard = this.u_con.isConnectedToProxy();
        }
        return isShard;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    CUBRIDException createCUBRIDException(UError error) {
        CUBRIDException e = new CUBRIDException(error);
        this.u_con.logException(e);
        return e;
    }

    CUBRIDException createCUBRIDException(int errCode, Throwable t) {
        CUBRIDException e = new CUBRIDException(errCode, t);
        if (this.u_con != null) {
            this.u_con.logException(e);
        }
        return e;
    }

    CUBRIDException createCUBRIDException(int errCode, String msg, Throwable t) {
        CUBRIDException e = new CUBRIDException(errCode, msg, t);
        this.u_con.logException(e);
        return e;
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

