/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDComparator;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetWithoutQuery;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UShardInfo;
import cubrid.jdbc.jci.UStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDDatabaseMetaData
implements DatabaseMetaData {
    private static final int SQL_MAX_CHAR_LITERAL_LEN = 0x3FFFFFFF;
    CUBRIDConnection con;
    UConnection u_con;
    UError error;
    boolean is_closed;
    int major_version;
    int minor_version;
    int shard_id = -1;

    protected CUBRIDDatabaseMetaData(CUBRIDConnection c) {
        this.con = c;
        this.u_con = this.con.u_con;
        this.error = null;
        this.is_closed = false;
        this.major_version = -1;
        this.minor_version = -1;
        this.shard_id = 0;
    }

    protected CUBRIDDatabaseMetaData(CUBRIDConnection c, int sid) {
        this.con = c;
        this.u_con = this.con.u_con;
        this.error = null;
        this.is_closed = false;
        this.major_version = -1;
        this.minor_version = -1;
        this.shard_id = sid;
    }

    @Override
    public synchronized boolean allProceduresAreCallable() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean allTablesAreSelectable() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getURL() throws SQLException {
        this.checkIsOpen();
        return this.con.url;
    }

    @Override
    public synchronized String getUserName() throws SQLException {
        this.checkIsOpen();
        return this.con.user;
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullsAreSortedHigh() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullsAreSortedLow() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean nullsAreSortedAtStart() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getDatabaseProductName() throws SQLException {
        this.checkIsOpen();
        return "CUBRID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        this.checkIsOpen();
        String ver = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            ver = this.u_con.getDatabaseProductVersion();
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                StringTokenizer st = new StringTokenizer(ver, ".");
                if (st.countTokens() == 4) {
                    this.major_version = Integer.parseInt(st.nextToken());
                    this.minor_version = Integer.parseInt(st.nextToken());
                }
                return ver;
            }
        }
        throw this.con.createCUBRIDException(this.error);
    }

    @Override
    public synchronized String getDriverName() throws SQLException {
        this.checkIsOpen();
        return "CUBRID JDBC Driver";
    }

    @Override
    public synchronized String getDriverVersion() throws SQLException {
        this.checkIsOpen();
        return "9.3.9.0002";
    }

    @Override
    public int getDriverMajorVersion() {
        return CUBRIDDriver.major_version;
    }

    @Override
    public int getDriverMinorVersion() {
        return CUBRIDDriver.minor_version;
    }

    @Override
    public synchronized boolean usesLocalFiles() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean usesLocalFilePerTable() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getIdentifierQuoteString() throws SQLException {
        this.checkIsOpen();
        return "\"";
    }

    @Override
    public synchronized String getSQLKeywords() throws SQLException {
        this.checkIsOpen();
        return "ADD, ADD_MONTHS, AFTER, ALIAS, ASYNC, ATTACH, ATTRIBUTE, BEFORE, BOOLEAN, BREADTH, CALL, CHANGE, CLASS, CLASSES, CLUSTER, COMPLETION, CYCLE, DATA, DATA_TYPE___, DEPTH, DICTIONARY, DIFFERENCE, EACH, ELSEIF, EQUALS, EVALUATE, EXCLUDE, FILE, FUNCTION, GENERAL, IF, IGNORE, INCREMENT, INDEX, INHERIT, INOUT, INTERSECTION, LAST_DAY, LDB, LEAVE, LESS, LIMIT, LIST, LOOP, LPAD, LTRIM, MAXVALUE, METHOD, MINVALUE, MODIFY, MONETARY, MONTHS_BETWEEN, MULTISET, MULTISET_OF, NA, NOCYCLE, NOMAXVALUE, NOMINVALUE, NONE, OBJECT, OFF, OID, OLD, OPERATION, OPERATORS, OPTIMIZATION, OTHERS, OUT, PARAMETERS, PENDANT, PREORDER, PRIVATE, PROXY, PROTECTED, QUERY, RECURSIVE, REF, REFERENCING, REGISTER, RENAME, REPLACE, RESIGNAL, RETURN, RETURNS, ROLE, ROUTINE, ROW, RPAD, RTRIM, SAVEPOINT, SCOPE___, SEARCH, SENSITIVE, SEQUENCE, SEQUENCE_OF, SERIAL, SERIALIZABLE, SETEQ, SETNEQ, SET_OF, SHARED, SHORT, SIGNAL, SIMILAR, SQLEXCEPTION, SQLWARNING, START, TATISTICS, STDDEV, STRING, STRUCTURE, SUBCLASS, SUBSET, SUBSETEQ, SUPERCLASS, SUPERSET, SUPERSETEQ, SYS_DATE, SYS_TIME, SYS_TIMESTAMP, SYS_USER, TEST, THERE, TO_CHAR, TO_DATE, TO_NUMBER, TO_TIME, TO_TIMESTAMP, TRIGGER, TYPE, UNDER, USE, UTIME, VARIABLE, VARIANCE, VCLASS, VIRTUAL, VISIBLE, WAIT, WHILE, WITHOUT, SYS_DATETIME, TO_DATETIME";
    }

    @Override
    public synchronized String getNumericFunctions() throws SQLException {
        this.checkIsOpen();
        return "AVG, COUNT, MAX, MIN, STDDEV, SUM, VARIANCE";
    }

    @Override
    public synchronized String getStringFunctions() throws SQLException {
        this.checkIsOpen();
        return "BIT_LENGTH, CHAR_LENGTH, LOWER, LTRIM, OCTET_LENGTH, POSITION, REPLACE, RPAD, RTRIM, SUBSTRING, TRANSLATE, TRIM, TO_CHAR, TO_DATE, TO_NUMBER, TO_TIME, TO_TIMESTAMP, TO_DATETIME, UPPER";
    }

    @Override
    public synchronized String getSystemFunctions() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized String getTimeDateFunctions() throws SQLException {
        this.checkIsOpen();
        return "ADD_MONTHS, LAST_DAY, MONTH_BETWEEN, SYS_DATE, SYS_TIME, SYS_TIMESTMAP, TO_DATE, TO_TIME, TO_TIMESTAMP, TO_DATETIME";
    }

    @Override
    public synchronized String getSearchStringEscape() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized String getExtraNameCharacters() throws SQLException {
        this.checkIsOpen();
        return "%#";
    }

    @Override
    public synchronized boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsColumnAliasing() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsConvert() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsConvert(int fromType, int toType) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsTableCorrelationNames() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOrderByUnrelated() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsGroupBy() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsGroupByUnrelated() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsLikeEscapeClause() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsMultipleResultSets() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsMultipleTransactions() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsNonNullableColumns() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsANSI92FullSQL() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOuterJoins() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsFullOuterJoins() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized String getSchemaTerm() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized String getProcedureTerm() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized String getCatalogTerm() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized boolean isCatalogAtStart() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized String getCatalogSeparator() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsPositionedDelete() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsPositionedUpdate() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSelectForUpdate() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsStoredProcedures() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsSubqueriesInExists() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsSubqueriesInIns() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsUnion() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsUnionAll() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized int getMaxBinaryLiteralLength() throws SQLException {
        this.checkIsOpen();
        return 0x7FFFFFF;
    }

    @Override
    public synchronized int getMaxCharLiteralLength() throws SQLException {
        this.checkIsOpen();
        return 0x3FFFFFFF;
    }

    @Override
    public synchronized int getMaxColumnNameLength() throws SQLException {
        this.checkIsOpen();
        return 254;
    }

    @Override
    public synchronized int getMaxColumnsInGroupBy() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInIndex() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInOrderBy() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInSelect() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxColumnsInTable() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxConnections() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxCursorNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxIndexLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxSchemaNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxProcedureNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxCatalogNameLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxRowSize() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized int getMaxStatementLength() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxStatements() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxTableNameLength() throws SQLException {
        this.checkIsOpen();
        return 254;
    }

    @Override
    public synchronized int getMaxTablesInSelect() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getMaxUserNameLength() throws SQLException {
        this.checkIsOpen();
        return 31;
    }

    @Override
    public synchronized int getDefaultTransactionIsolation() throws SQLException {
        this.checkIsOpen();
        return 2;
    }

    @Override
    public synchronized boolean supportsTransactions() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        this.checkIsOpen();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "", "", "", "REMARKS", "PROCEDURE_TYPE"};
        int[] types = new int[]{2, 2, 2, 2, 2, 2, 2, 9};
        boolean[] nullable = new boolean[]{true, true, false, true, true, true, false, false};
        return new CUBRIDResultSetWithoutQuery(8, types, names, nullable, null);
    }

    @Override
    public synchronized ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
        int[] types = new int[]{2, 2, 2, 2, 9, 9, 2, 8, 8, 9, 9, 9, 2};
        boolean[] nullable = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false};
        return new CUBRIDResultSetWithoutQuery(13, types, names, nullable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        int i;
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
        int[] type = new int[]{2, 2, 2, 2, 2};
        boolean[] nullable = new boolean[]{true, true, false, false, false};
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(1, tableNamePattern, null, (byte)3, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        UColumnInfo[] column_info = us.getColumnInfo();
        int[] precision = new int[]{0, 0, column_info[0].getColumnPrecision(), 12, 0};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(5, type, names, nullable, precision);
        Object[] value = new Object[5];
        value[0] = null;
        value[1] = null;
        value[4] = null;
        int j = 0;
        if (types != null) {
            for (j = 0; j < types.length && !types[j].equalsIgnoreCase("TABLE"); ++j) {
            }
        }
        if (types == null || j < types.length) {
            value[3] = "TABLE";
            i = 0;
            while (true) {
                us.moveCursor(i++, 0);
                if (us.getRecentError().getErrorCode() != 0) break;
                us.fetch();
                if (us.getInt(1) != 2) continue;
                value[2] = us.getString(0);
                rs.addTuple(value);
            }
        }
        if (types != null) {
            for (j = 0; j < types.length && !types[j].equalsIgnoreCase("VIEW"); ++j) {
            }
        }
        if (types == null || j < types.length) {
            value[3] = "VIEW";
            i = 0;
            while (true) {
                us.moveCursor(i++, 0);
                if (us.getRecentError().getErrorCode() != 0) break;
                us.fetch();
                if (us.getInt(1) != 1) continue;
                value[2] = us.getString(0);
                rs.addTuple(value);
            }
        }
        if (types != null) {
            for (j = 0; j < types.length && !types[j].equalsIgnoreCase("SYSTEM TABLE"); ++j) {
            }
        }
        if (types == null || j < types.length) {
            value[3] = "SYSTEM TABLE";
            i = 0;
            while (true) {
                us.moveCursor(i++, 0);
                if (us.getRecentError().getErrorCode() != 0) break;
                us.fetch();
                if (us.getInt(1) != 0) continue;
                value[2] = us.getString(0);
                rs.addTuple(value);
            }
        }
        us.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getTables"));
        return rs;
    }

    @Override
    public synchronized ResultSet getSchemas() throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_SCHEM"};
        int[] types = new int[]{2};
        boolean[] nullable = new boolean[]{false};
        return new CUBRIDResultSetWithoutQuery(1, types, names, nullable, null);
    }

    @Override
    public synchronized ResultSet getCatalogs() throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT"};
        int[] types = new int[]{2};
        boolean[] nullable = new boolean[]{false};
        return new CUBRIDResultSetWithoutQuery(1, types, names, nullable, null);
    }

    @Override
    public synchronized ResultSet getTableTypes() throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_TYPE"};
        int[] types = new int[]{2};
        boolean[] nullable = new boolean[]{false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(1, types, names, nullable, null);
        Object[] value = new Object[]{"SYSTEM TABLE"};
        rs.addTuple(value);
        value[0] = "TABLE";
        rs.addTuple(value);
        value[0] = "VIEW";
        rs.addTuple(value);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
        int[] types = new int[]{2, 2, 2, 2, 9, 2, 8, 0, 8, 8, 8, 2, 2, 8, 8, 8, 8, 2};
        boolean[] nullable = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, true, true, true, false, false, false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(18, types, names, nullable, null);
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            int flag = 0;
            if (tableNamePattern == null || this.containsWildcard(tableNamePattern)) {
                flag |= 1;
            }
            if (columnNamePattern == null || this.containsWildcard(columnNamePattern)) {
                flag |= 2;
            }
            us = this.u_con.getSchemaInfo(4, tableNamePattern, columnNamePattern, (byte)flag, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        Object[] value = new Object[18];
        value[0] = null;
        value[1] = null;
        value[7] = null;
        value[9] = new Integer(10);
        value[11] = null;
        value[13] = null;
        value[14] = null;
        int i = 0;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            int err_code = us.getRecentError().getErrorCode();
            if (err_code != 0 && err_code != -21008) {
                throw this.con.createCUBRIDException(us.getRecentError());
            }
            value[2] = us.getString(10);
            value[3] = us.getString(0);
            value[6] = value[15] = new Integer(us.getInt(3));
            value[8] = new Integer(us.getInt(2));
            value[16] = new Integer(us.getInt(9));
            if (us.getInt(5) == 1) {
                value[10] = new Integer(0);
                value[17] = "NO";
            } else {
                value[10] = new Integer(1);
                value[17] = "YES";
            }
            value[12] = us.getObject(8);
            int type = us.getInt(1);
            if (type == 5) {
                value[4] = new Short(-2);
                value[5] = "BIT";
            } else if (type == 6) {
                value[4] = new Short(-3);
                value[5] = "BIT VARYING";
            } else if (type == 1) {
                value[4] = new Short(1);
                value[5] = "CHAR";
            } else if (type == 2) {
                value[4] = new Short(12);
                value[5] = "VARCHAR";
            } else if (type == 25) {
                value[4] = new Short(12);
                value[5] = "ENUM";
            } else if (type == 3) {
                value[4] = new Short(1);
                value[5] = "NCHAR";
            } else if (type == 4) {
                value[4] = new Short(12);
                value[5] = "NCHAR VARYING";
            } else if (type == 9) {
                value[4] = new Short(5);
                value[5] = "SMALLINT";
            } else if (type == 21) {
                value[4] = new Short(-5);
                value[5] = "BIGINT";
            } else if (type == 8) {
                value[4] = new Short(4);
                value[5] = "INTEGER";
            } else if (type == 7) {
                value[4] = new Short(2);
                value[5] = "NUMERIC";
            } else if (type == 11) {
                value[4] = new Short(7);
                value[5] = "FLOAT";
            } else if (type == 12) {
                value[4] = new Short(8);
                value[5] = "DOUBLE PRECISION";
            } else if (type == 10) {
                value[4] = new Short(8);
                value[5] = "MONETARY";
            } else if (type == 14) {
                value[4] = new Short(92);
                value[5] = "TIME";
            } else if (type == 13) {
                value[4] = new Short(91);
                value[5] = "DATE";
            } else if (type == 15) {
                value[4] = new Short(93);
                value[5] = "TIMESTAMP";
            } else if (type == 22) {
                value[4] = new Short(93);
                value[5] = "DATETIME";
            } else if (type == 19) {
                value[4] = new Short(1111);
                value[5] = "CLASS";
            } else if (type == 16) {
                value[4] = new Short(1111);
                value[5] = "SET";
            } else if (type == 17) {
                value[4] = new Short(1111);
                value[5] = "MULTISET";
            } else if (type == 18) {
                value[4] = new Short(1111);
                value[5] = "SEQUENCE";
            } else if (type == 23) {
                value[4] = new Short(2004);
                value[5] = "BLOB";
            } else if (type == 24) {
                value[4] = new Short(2005);
                value[5] = "CLOB";
            }
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getColumns"));
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] types = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        boolean[] nullable = new boolean[]{true, true, false, false, true, false, false, false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(8, types, names, nullable, null);
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(14, table, columnNamePattern, (byte)2, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed, null);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        Object[] value = new Object[8];
        value[0] = null;
        value[1] = null;
        value[2] = table;
        int i = 0;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            value[3] = us.getString(0);
            value[4] = null;
            value[5] = this.con.user;
            value[6] = us.getString(1);
            value[7] = us.getString(2);
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getColumnPrivileges"));
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] types = new int[]{2, 2, 2, 2, 2, 2, 2};
        boolean[] nullable = new boolean[]{true, true, false, true, false, false, false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(7, types, names, nullable, null);
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(13, tableNamePattern, null, (byte)3, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        Object[] value = new Object[7];
        value[0] = null;
        value[1] = null;
        int i = 0;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            value[2] = us.getString(0);
            value[3] = null;
            value[4] = this.con.user;
            value[5] = us.getString(1);
            value[6] = us.getString(2);
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getTablePrivileges"));
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] types = new int[]{9, 2, 9, 2, 8, 8, 9, 9};
        boolean[] Nullable = new boolean[]{false, false, false, false, false, true, false, false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(8, types, names, Nullable, null);
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(11, table, null, (byte)2, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        int i = 0;
        int min = 2100000000;
        int minindex = -1;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            if (us.getInt(0) != 0) continue;
            String const_name = us.getString(1);
            int num_of_comma = 0;
            int last_occur = -1;
            while ((last_occur = const_name.indexOf(44, last_occur + 1)) != -1) {
                ++num_of_comma;
            }
            if (num_of_comma >= min) continue;
            min = num_of_comma;
            minindex = i;
        }
        if (min == 2100000000) {
            us.close();
            this.endTransaction();
            return rs;
        }
        UStatement us2 = null;
        UConnection num_of_comma = this.u_con;
        synchronized (num_of_comma) {
            us2 = this.u_con.getSchemaInfo(4, table, null, (byte)2, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed, null);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        Object[] value = new Object[8];
        value[5] = null;
        value[7] = new Short(1);
        for (i = 0; i <= min; ++i) {
            us.moveCursor(minindex + i, 0);
            us.fetch();
            value[1] = us.getString(2);
            int j = 0;
            while (true) {
                us2.moveCursor(j, 0);
                us2.fetch();
                if (us2.getString(0).equals(value[1])) break;
                ++j;
            }
            value[6] = new Integer(us2.getInt(2));
            switch (us2.getInt(1)) {
                case 1: {
                    value[2] = new Integer(1);
                    value[3] = "CHAR";
                    value[4] = new Integer(0);
                    break;
                }
                case 2: {
                    value[2] = new Integer(12);
                    value[3] = "VARCHAR";
                    value[4] = new Integer(0);
                    break;
                }
                case 25: {
                    value[2] = new Integer(12);
                    value[3] = "ENUM";
                    value[4] = new Integer(0);
                    break;
                }
                case 9: {
                    value[2] = new Integer(5);
                    value[3] = "SMALLINT";
                    value[4] = new Integer(us2.getInt(3));
                    break;
                }
                case 8: {
                    value[2] = new Integer(4);
                    value[3] = "INTEGER";
                    value[4] = new Integer(us2.getInt(3));
                    break;
                }
                case 21: {
                    value[2] = new Integer(-5);
                    value[3] = "BIGINT";
                    value[4] = new Integer(us2.getInt(3));
                    break;
                }
                case 12: {
                    value[2] = new Integer(8);
                    value[3] = "DOUBLE";
                    value[4] = new Integer(us2.getInt(3));
                    break;
                }
                case 11: {
                    value[2] = new Integer(7);
                    value[3] = "FLOAT";
                    value[4] = new Integer(us2.getInt(3));
                    break;
                }
                case 7: {
                    value[2] = new Integer(2);
                    value[3] = "NUMERIC";
                    value[4] = new Integer(us2.getInt(3));
                    break;
                }
                case 13: {
                    value[2] = new Integer(91);
                    value[3] = "DATE";
                    value[4] = new Integer(0);
                    break;
                }
                case 14: {
                    value[2] = new Integer(92);
                    value[3] = "TIME";
                    value[4] = new Integer(0);
                    break;
                }
                case 15: {
                    value[2] = new Integer(93);
                    value[3] = "TIMESTAMP";
                    value[4] = new Integer(0);
                    break;
                }
                case 22: {
                    value[2] = new Integer(93);
                    value[3] = "DATETIME";
                    value[4] = new Integer(0);
                    break;
                }
                case 0: {
                    value[2] = new Integer(0);
                    value[3] = "";
                    value[4] = new Integer(0);
                    break;
                }
                case 23: {
                    value[2] = new Integer(2004);
                    value[3] = "BLOB";
                    value[4] = new Integer(0);
                    break;
                }
                case 24: {
                    value[2] = new Integer(2005);
                    value[3] = "CLOB";
                    value[4] = new Integer(0);
                }
            }
            rs.addTuple(value);
        }
        us.close();
        us2.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getBestRowIdentifier"));
        return rs;
    }

    @Override
    public synchronized ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] types = new int[]{9, 2, 9, 2, 8, 8, 9, 9};
        boolean[] nullable = new boolean[]{true, false, false, false, false, false, false, false};
        return new CUBRIDResultSetWithoutQuery(8, types, names, nullable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] type = new int[]{2, 2, 2, 2, 9, 2};
        boolean[] nullable = new boolean[]{true, true, false, false, false, false};
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(16, table, null, (byte)3, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(6, type, names, nullable, null);
        Object[] value = new Object[6];
        value[0] = null;
        value[1] = null;
        int i = 0;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            value[2] = us.getString(0);
            value[3] = us.getString(1);
            value[4] = us.getInt(2);
            value[5] = us.getString(3);
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        return rs;
    }

    private short convertForeignKeyAction(short serverAction) {
        switch (serverAction) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet getForeignKeys(int type, String table1, String table2) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] types = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 9, 2, 2, 9};
        boolean[] nullable = new boolean[]{true, true, false, false, true, true, false, false, false, false, false, true, true, false};
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(type, table1, table2, (byte)3, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(14, types, names, nullable, null);
        Object[] value = new Object[14];
        value[0] = null;
        value[1] = null;
        value[4] = null;
        value[5] = null;
        value[13] = 6;
        int i = 0;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            value[2] = us.getString(0);
            value[3] = us.getString(1);
            value[6] = us.getString(2);
            value[7] = us.getString(3);
            value[8] = us.getShort(4);
            value[9] = this.convertForeignKeyAction(us.getShort(5));
            value[10] = this.convertForeignKeyAction(us.getShort(6));
            value[11] = us.getString(7);
            value[12] = us.getString(8);
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        return rs;
    }

    @Override
    public synchronized ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkIsOpen();
        if (table == null) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_table_name, null);
        }
        return this.getForeignKeys(17, table, null);
    }

    @Override
    public synchronized ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkIsOpen();
        if (table == null) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_table_name, null);
        }
        return this.getForeignKeys(18, table, null);
    }

    @Override
    public synchronized ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.checkIsOpen();
        if (primaryTable == null || foreignTable == null) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_table_name, null);
        }
        return this.getForeignKeys(19, primaryTable, foreignTable);
    }

    @Override
    public synchronized ResultSet getTypeInfo() throws SQLException {
        Object column16;
        this.checkIsOpen();
        String[] names = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        int[] types = new int[]{2, 9, 8, 2, 2, 2, 9, 5, 9, 5, 5, 5, 2, 9, 9, 8, 8, 8};
        boolean[] nullable = new boolean[]{false, false, false, true, true, true, false, false, false, false, false, false, true, false, false, true, true, false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(18, types, names, nullable, null);
        Object[] column1 = new Object[]{"BIT", "NUMERIC", "NUMERIC", "BIT VARYING", "BIT VARYING", "BIT", "VARCHAR", "CHAR", "NUMERIC", "INTEGER", "BIGINT", "SMALLINT", "DOUBLE", "FLOAT", "DOUBLE", "VARCHAR", "DATE", "TIME", "TIMESTAMP", "DATETIME"};
        Object[] column2 = new Object[]{new Short(-7), new Short(-6), new Short(-5), new Short(-4), new Short(-3), new Short(-2), new Short(-1), new Short(1), new Short(2), new Short(4), new Short(-5), new Short(5), new Short(6), new Short(7), new Short(8), new Short(12), new Short(91), new Short(92), new Short(93), new Short(93)};
        Object[] column3 = new Object[]{new Integer(8), new Integer(3), new Integer(38), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(0x3FFFFFFF), new Integer(38), new Integer(10), new Integer(19), new Integer(5), new Integer(38), new Integer(38), new Integer(38), new Integer(0x3FFFFFFF), new Integer(10), new Integer(11), new Integer(22), new Integer(26)};
        Object[] column4 = new Object[]{"B'", null, null, "X'", "X'", "X'", "'", "'", null, null, null, null, null, null, null, "'", "DATE'", "TIME'", "TIMESTAMP'", "DATETIME'"};
        Object[] column5 = new Object[]{"'", null, null, "'", "'", "'", "'", "'", null, null, null, null, null, null, null, "'", "'", "'", "'", "'"};
        Object[] column6 = new Object[]{"(8)", "(3)", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        Short column7 = new Short(1);
        Object[] column8 = new Object[]{new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false)};
        Object[] column9 = new Object[]{new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(3), new Short(3), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(2), new Short(3), new Short(2), new Short(2), new Short(2), new Short(2)};
        Object[] column10 = new Object[]{new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true)};
        Object[] column11 = new Object[]{new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false)};
        Boolean column12 = new Boolean(false);
        Object[] column13 = column1;
        Object[] column14 = new Object[]{new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        Object[] column15 = new Object[]{new Integer(0), new Integer(0), new Integer(38), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(38), new Integer(0), new Integer(0), new Integer(0), new Integer(38), new Integer(38), new Integer(38), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
        Object column17 = column16 = null;
        Integer column18 = new Integer(10);
        Object[] value = new Object[18];
        value[6] = column7;
        value[11] = column12;
        value[15] = column16;
        value[16] = column17;
        value[17] = column18;
        for (int i = 0; i < 18; ++i) {
            value[0] = column1[i];
            value[1] = column2[i];
            value[2] = column3[i];
            value[3] = column4[i];
            value[4] = column5[i];
            value[5] = column6[i];
            value[7] = column8[i];
            value[8] = column9[i];
            value[9] = column10[i];
            value[10] = column11[i];
            value[12] = column13[i];
            value[13] = column14[i];
            value[14] = column15[i];
            rs.addTuple(value);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] types = new int[]{2, 2, 2, 5, 2, 2, 9, 9, 2, 2, 8, 8, 2};
        boolean[] nullable = new boolean[]{true, true, false, false, true, false, false, false, false, false, false, false, true};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(13, types, names, nullable, null);
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(11, table, null, (byte)2, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        us.moveCursor(0, 0);
        us.fetch();
        Object[] value = new Object[13];
        value[0] = null;
        value[1] = null;
        value[2] = table;
        value[4] = null;
        value[3] = new Boolean(false);
        value[5] = null;
        value[6] = new Short(0);
        value[7] = new Short(0);
        value[8] = null;
        value[9] = null;
        value[10] = new Integer(us.getInt(4));
        value[11] = new Integer(us.getInt(3));
        value[12] = null;
        rs.addTuple(value);
        value[6] = new Short(3);
        value[9] = "A";
        int i = 0;
        int ordinal = 1;
        String previousIndex = "";
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            if (unique && us.getShort(0) == 1) continue;
            value[3] = us.getShort(0) == 1 ? new Boolean(true) : new Boolean(false);
            value[5] = us.getString(1);
            if (((String)value[5]).equals(previousIndex)) {
                value[7] = new Integer(ordinal++);
            } else {
                value[7] = new Integer(1);
                ordinal = 2;
                previousIndex = (String)value[5];
            }
            value[8] = us.getString(2);
            value[10] = new Integer(us.getInt(4));
            value[11] = new Integer(us.getInt(3));
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getIndexInfo"));
        return rs;
    }

    @Override
    public synchronized boolean supportsResultSetType(int type) throws SQLException {
        this.checkIsOpen();
        if (type == 1003) {
            return true;
        }
        if (type == 1004) {
            return true;
        }
        return type == 1005;
    }

    @Override
    public synchronized boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        this.checkIsOpen();
        if (type == 1003 && concurrency == 1007) {
            return true;
        }
        if (type == 1003 && concurrency == 1008) {
            return true;
        }
        if (type == 1004 && concurrency == 1007) {
            return true;
        }
        if (type == 1004 && concurrency == 1008) {
            return true;
        }
        if (type == 1005 && concurrency == 1007) {
            return true;
        }
        return type == 1005 && concurrency == 1008;
    }

    @Override
    public synchronized boolean ownUpdatesAreVisible(int type) throws SQLException {
        this.checkIsOpen();
        return type == 1005;
    }

    @Override
    public synchronized boolean ownDeletesAreVisible(int type) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean ownInsertsAreVisible(int type) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean othersUpdatesAreVisible(int type) throws SQLException {
        this.checkIsOpen();
        return type == 1005;
    }

    @Override
    public synchronized boolean othersDeletesAreVisible(int type) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean othersInsertsAreVisible(int type) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean updatesAreDetected(int type) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean deletesAreDetected(int type) throws SQLException {
        this.checkIsOpen();
        return type == 1005;
    }

    @Override
    public synchronized boolean insertsAreDetected(int type) throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsBatchUpdates() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkIsOpen();
        return this.con;
    }

    @Override
    public synchronized ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] types = new int[]{2, 2, 2, 2, 8, 2, 8, 8, 8, 8, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 9};
        boolean[] nullable = new boolean[]{true, true, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false};
        return new CUBRIDResultSetWithoutQuery(21, types, names, nullable, null);
    }

    @Override
    public synchronized int getDatabaseMajorVersion() throws SQLException {
        this.checkIsOpen();
        if (this.major_version == -1) {
            this.getDatabaseProductVersion();
        }
        return this.major_version;
    }

    @Override
    public synchronized int getDatabaseMinorVersion() throws SQLException {
        this.checkIsOpen();
        if (this.minor_version == -1) {
            this.getDatabaseProductVersion();
        }
        return this.minor_version;
    }

    @Override
    public synchronized int getJDBCMajorVersion() throws SQLException {
        this.checkIsOpen();
        return 3;
    }

    @Override
    public synchronized int getJDBCMinorVersion() throws SQLException {
        this.checkIsOpen();
        return 0;
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        this.checkIsOpen();
        return this.con.getHoldability();
    }

    @Override
    public synchronized int getSQLStateType() throws SQLException {
        this.checkIsOpen();
        return 2;
    }

    @Override
    public synchronized boolean locatorsUpdateCopy() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsGetGeneratedKeys() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsMultipleOpenResults() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsNamedParameters() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    @Override
    public synchronized boolean supportsResultSetHoldability(int holdability) throws SQLException {
        this.checkIsOpen();
        return holdability == 2 || holdability == 1;
    }

    @Override
    public synchronized boolean supportsSavepoints() throws SQLException {
        this.checkIsOpen();
        return true;
    }

    @Override
    public synchronized boolean supportsStatementPooling() throws SQLException {
        this.checkIsOpen();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        int[] types = new int[]{2, 2, 2, 2};
        boolean[] nullable = new boolean[]{true, true, false, false};
        CUBRIDResultSetWithoutQuery rs = new CUBRIDResultSetWithoutQuery(4, types, names, nullable, null);
        UStatement us = null;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            us = this.u_con.getSchemaInfo(15, tableNamePattern, null, (byte)3, this.shard_id);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                case -21017: {
                    this.close();
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed);
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        Object[] value = new Object[4];
        value[0] = null;
        value[1] = null;
        int i = 0;
        while (true) {
            us.moveCursor(i++, 0);
            if (us.getRecentError().getErrorCode() != 0) break;
            us.fetch();
            value[2] = us.getString(0);
            value[3] = us.getString(1);
            rs.addTuple(value);
        }
        us.close();
        this.endTransaction();
        rs.sortTuples(new CUBRIDComparator("getSuperTables"));
        return rs;
    }

    @Override
    public synchronized ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.checkIsOpen();
        String[] names = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        int[] types = new int[]{2, 2, 2, 2, 2, 2};
        boolean[] nullable = new boolean[]{true, true, false, true, true, false};
        return new CUBRIDResultSetWithoutQuery(6, types, names, nullable, null);
    }

    synchronized void close() {
        this.is_closed = true;
        this.con = null;
        this.u_con = null;
        this.error = null;
        this.shard_id = -1;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            if (this.con != null) {
                throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed, null);
            }
            throw new CUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed, null);
        }
    }

    private synchronized void endTransaction() {
        if (this.u_con.getAutoCommit()) {
            this.u_con.endTransaction(true);
        }
    }

    private boolean containsWildcard(String s) {
        return s != null && (s.indexOf(37) >= 0 || s.indexOf(95) >= 0);
    }

    public synchronized void setShardId(int sid) throws SQLException {
        this.checkIsOpen();
        this.shard_id = sid;
    }

    public synchronized int getShardId() throws SQLException {
        this.checkIsOpen();
        return this.shard_id;
    }

    public synchronized String getShardDBName() throws SQLException {
        this.checkIsOpen();
        if (!this.con.isShard()) {
            return null;
        }
        UShardInfo shard_info = this.u_con.getShardInfo(this.shard_id);
        this.error = this.u_con.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        return shard_info.getDBName();
    }

    public synchronized String getShardDBServer() throws SQLException {
        this.checkIsOpen();
        if (!this.con.isShard()) {
            return null;
        }
        UShardInfo shard_info = this.u_con.getShardInfo(this.shard_id);
        this.error = this.u_con.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        return shard_info.getDBServer();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

