/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

public class CUBRIDLobHandle {
    private int lobType;
    private long lobSize;
    private byte[] packedLobHandle;
    private String locator;

    public CUBRIDLobHandle(int lobType, byte[] packedLobHandle) {
        this.lobType = lobType;
        this.packedLobHandle = packedLobHandle;
        this.initLob();
    }

    private void initLob() {
        int pos = 0;
        if (this.packedLobHandle == null) {
            throw new NullPointerException();
        }
        this.lobSize = 0L;
        for (int i = pos += 4; i < pos + 8; ++i) {
            this.lobSize <<= 8;
            this.lobSize |= (long)(this.packedLobHandle[i] & 0xFF);
        }
        int locatorSize = 0;
        for (int i = pos += 8; i < pos + 4; ++i) {
            locatorSize <<= 8;
            locatorSize |= this.packedLobHandle[i] & 0xFF;
        }
        this.locator = new String(this.packedLobHandle, pos += 4, locatorSize - 1);
    }

    public void setLobSize(long size) {
        int pos = 0;
        if (this.packedLobHandle == null) {
            throw new NullPointerException();
        }
        this.lobSize = size;
        int bitpos = 64;
        for (int i = pos += 4; i < pos + 8; ++i) {
            this.packedLobHandle[i] = (byte)(this.lobSize >>> (bitpos -= 8) & 0xFFL);
        }
    }

    public long getLobSize() {
        return this.lobSize;
    }

    public byte[] getPackedLobHandle() {
        return this.packedLobHandle;
    }

    public String toString() {
        return this.locator;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CUBRIDLobHandle) {
            CUBRIDLobHandle that = (CUBRIDLobHandle)obj;
            return this.lobType == that.lobType && this.lobSize == that.lobSize && this.locator.equals(that.locator);
        }
        return false;
    }
}

